package org.pdb.beans;

/**
 *  Data items in the PDBX_FEATURE_MONOMER category records
 *  information about properties pertaining to particular
 *  monomers in this structure.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_feature_monomerCategory>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>ASP</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>1</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>129.4</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>2</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>35.5</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>3</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>87.2</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  </PDBx:pdbx_feature_monomerCategory>
 * </pre>
 */
public class Pdbx_feature_monomer 
{
		protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.String feature;


	/**
	 *  The value of  attribute feature_name in category pdbx_feature_monomer.
	 */
	public java.lang.String getFeature() 
	{
		return feature;
	}
 
	public void setFeature(java.lang.String feature)
	{
		this.feature = feature;
	}

 	protected java.lang.String feature_assigned_by;


	/**
	 *  attribute feature_assigned_by in category pdbx_feature_monomer identifies
	 *  the individual, organization or program that
	 *  assigned the feature.
	 */
	public java.lang.String getFeature_assigned_by() 
	{
		return feature_assigned_by;
	}
 
	public void setFeature_assigned_by(java.lang.String feature_assigned_by)
	{
		this.feature_assigned_by = feature_assigned_by;
	}

 	protected java.lang.String feature_citation_id;


	/**
	 *  attribute feature_citation_id in category pdbx_feature_monomer is a
	 *  reference to a citation in the CITATION category.
	 */
	public java.lang.String getFeature_citation_id() 
	{
		return feature_citation_id;
	}
 
	public void setFeature_citation_id(java.lang.String feature_citation_id)
	{
		this.feature_citation_id = feature_citation_id;
	}

 	protected java.lang.String feature_identifier;


	/**
	 *  attribute feature_identifier in category pdbx_feature_monomer is an
	 *  additional identifier used to identify or
	 *  accession this feature.
	 */
	public java.lang.String getFeature_identifier() 
	{
		return feature_identifier;
	}
 
	public void setFeature_identifier(java.lang.String feature_identifier)
	{
		this.feature_identifier = feature_identifier;
	}

 	protected java.lang.String feature_name;


	/**
	 *  attribute feature_name in category pdbx_feature_monomer identifies a feature
	 *  by name.
	 */
	public java.lang.String getFeature_name() 
	{
		return feature_name;
	}
 
	public void setFeature_name(java.lang.String feature_name)
	{
		this.feature_name = feature_name;
	}

 	protected java.lang.String feature_software_id;


	/**
	 *  attribute feature_software_id in category pdbx_feature_monomer is a
	 *  reference to an application described in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getFeature_software_id() 
	{
		return feature_software_id;
	}
 
	public void setFeature_software_id(java.lang.String feature_software_id)
	{
		this.feature_software_id = feature_software_id;
	}

 	protected java.lang.String feature_type;


	/**
	 *  attribute feature_type in category pdbx_feature_monomer identifies the
	 *  type of feature.
	 */
	public java.lang.String getFeature_type() 
	{
		return feature_type;
	}
 
	public void setFeature_type(java.lang.String feature_type)
	{
		this.feature_type = feature_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_feature_monomer uniquely identifies
	 *  a feature in the PDBX_FEATURE_MONOMER category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 }
