package org.pdb.beans;

/**
 *  Data items in the PDBX_FEATURE_SEQUENCE_RANGE category
 *  records information about properties pertaining to
 *  this structure sequence_range.
 *  
 * <pre>
 *  Example 1 - Secondary structure computed by program DSSP.
 *  <PDBx:pdbx_feature_sequence_rangeCategory>
 *  <PDBx:pdbx_feature_sequence_range id="1">
 *  <PDBx:seq_range_id>H1</PDBx:seq_range_id>
 *  <PDBx:feature_name>secondary structure</PDBx:feature_name>
 *  <PDBx:feature>4-helix (alpha-helix)</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>DSSP</PDBx:feature_assigned_by>
 *  <PDBx:feature_software_id>DSSP</PDBx:feature_software_id>
 *  </PDBx:pdbx_feature_sequence_range>
 *  <PDBx:pdbx_feature_sequence_range id="2">
 *  <PDBx:seq_range_id>T1</PDBx:seq_range_id>
 *  <PDBx:feature_name>secondary structure</PDBx:feature_name>
 *  <PDBx:feature>hydrogen-bonded turn in beta-ladder</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>DSSP</PDBx:feature_assigned_by>
 *  <PDBx:feature_software_id>DSSP</PDBx:feature_software_id>
 *  </PDBx:pdbx_feature_sequence_range>
 *  </PDBx:pdbx_feature_sequence_rangeCategory>
 * </pre>
 */
public class Pdbx_feature_sequence_range 
{
		protected java.lang.String feature;


	/**
	 *  The value of  attribute feature_name in category pdbx_feature_sequence_range.
	 */
	public java.lang.String getFeature() 
	{
		return feature;
	}
 
	public void setFeature(java.lang.String feature)
	{
		this.feature = feature;
	}

 	protected java.lang.String feature_assigned_by;


	/**
	 *  attribute feature_assigned_by in category pdbx_feature_sequence_range identifies
	 *  the individual, organization or program that assigned
	 *  the feature.
	 */
	public java.lang.String getFeature_assigned_by() 
	{
		return feature_assigned_by;
	}
 
	public void setFeature_assigned_by(java.lang.String feature_assigned_by)
	{
		this.feature_assigned_by = feature_assigned_by;
	}

 	protected java.lang.String feature_citation_id;


	/**
	 *  attribute feature_citation_id in category pdbx_feature_sequence_range is a
	 *  reference to a citation in the CITATION category
	 */
	public java.lang.String getFeature_citation_id() 
	{
		return feature_citation_id;
	}
 
	public void setFeature_citation_id(java.lang.String feature_citation_id)
	{
		this.feature_citation_id = feature_citation_id;
	}

 	protected java.lang.String feature_identifier;


	/**
	 *  attribute feature_identifier in category pdbx_feature_sequence_range is an
	 *  additional identifier used to identify or
	 *  accession this feature.
	 */
	public java.lang.String getFeature_identifier() 
	{
		return feature_identifier;
	}
 
	public void setFeature_identifier(java.lang.String feature_identifier)
	{
		this.feature_identifier = feature_identifier;
	}

 	protected java.lang.String feature_name;


	/**
	 *  attribute feature_name in category pdbx_feature_sequence_range identifies a feature
	 *  by name.
	 */
	public java.lang.String getFeature_name() 
	{
		return feature_name;
	}
 
	public void setFeature_name(java.lang.String feature_name)
	{
		this.feature_name = feature_name;
	}

 	protected java.lang.String feature_software_id;


	/**
	 *  attribute feature_software_id in category pdbx_feature_sequence_range is a
	 *  reference to an application descripted in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getFeature_software_id() 
	{
		return feature_software_id;
	}
 
	public void setFeature_software_id(java.lang.String feature_software_id)
	{
		this.feature_software_id = feature_software_id;
	}

 	protected java.lang.String feature_type;


	/**
	 *  attribute feature_type in category pdbx_feature_sequence_range identifies the
	 *  type of feature.
	 */
	public java.lang.String getFeature_type() 
	{
		return feature_type;
	}
 
	public void setFeature_type(java.lang.String feature_type)
	{
		this.feature_type = feature_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_feature_sequence_range uniquely identifies
	 *  a feature in the PDBX_FEATURE_SEQUENCE_RANGE category
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String seq_range_id;


	/**
	 *  The value of  attribute seq_range_id
	 *  in category pdbx_feature_sequence_range references a sequence_range definition in category
	 *  PDBX_SEQUENCE_RANGE.
	 */
	public java.lang.String getSeq_range_id() 
	{
		return seq_range_id;
	}
 
	public void setSeq_range_id(java.lang.String seq_range_id)
	{
		this.seq_range_id = seq_range_id;
	}

 }
