package org.pdb.beans;

/**
 *  Structural statistics are derived from molecular dynamics and simulated annealing
 *  programs.
 *  This example is derived from the MCP-1 structure calculation statistics.
 *  For this  structure the statistics were calculated over residues 5-69 for
 *  both the monomer and dimer .
 *  <PDBx:pdbx_nmr_ensemble_rmsCategory>
 *  <PDBx:pdbx_nmr_ensemble_rms entry_id="1ABC">
 *  <PDBx:residue_range_begin>5</PDBx:residue_range_begin>
 *  <PDBx:chain_range_begin>A</PDBx:chain_range_begin>
 *  <PDBx:residue_range_end>69</PDBx:residue_range_end>
 *  <PDBx:chain_range_end>A</PDBx:chain_range_end>
 *  <PDBx:atom_type>all heavy atoms</PDBx:atom_type>
 *  <PDBx:distance_rms_dev>0.22</PDBx:distance_rms_dev>
 *  <PDBx:distance_rms_dev_error>0.06</PDBx:distance_rms_dev_error>
 *  </PDBx:pdbx_nmr_ensemble_rms>
 *  </PDBx:pdbx_nmr_ensemble_rmsCategory>
 */
public class Pdbx_nmr_ensemble_rms 
{
		protected java.lang.String atom_type;


	/**
	 *  Statistics are often calculated over only some of the atoms,
	 *  e.g. backbone, or heavy atoms. Describe which type of atoms are used for
	 *  the statistical analysis.
	 *  backbone atoms
	 *  heavy atoms
	 */
	public java.lang.String getAtom_type() 
	{
		return atom_type;
	}
 
	public void setAtom_type(java.lang.String atom_type)
	{
		this.atom_type = atom_type;
	}

 	protected java.lang.Float bond_angle_rms_dev;


	/**
	 *  The bond angle rmsd to the target values for the ensemble.
	 *  0.60
	 */
	public java.lang.Float getBond_angle_rms_dev() 
	{
		return bond_angle_rms_dev;
	}
 
	public void setBond_angle_rms_dev(java.lang.Float bond_angle_rms_dev)
	{
		this.bond_angle_rms_dev = bond_angle_rms_dev;
	}

 	protected java.lang.Float bond_angle_rms_dev_error;


	/**
	 *  The error in the bond angle rmsd.
	 *  0.01
	 */
	public java.lang.Float getBond_angle_rms_dev_error() 
	{
		return bond_angle_rms_dev_error;
	}
 
	public void setBond_angle_rms_dev_error(java.lang.Float bond_angle_rms_dev_error)
	{
		this.bond_angle_rms_dev_error = bond_angle_rms_dev_error;
	}

 	protected java.lang.String chain_range_begin;


	/**
	 *  The beginning chain id.
	 *  A
	 */
	public java.lang.String getChain_range_begin() 
	{
		return chain_range_begin;
	}
 
	public void setChain_range_begin(java.lang.String chain_range_begin)
	{
		this.chain_range_begin = chain_range_begin;
	}

 	protected java.lang.String chain_range_end;


	/**
	 *  The ending chain id:
	 *  A
	 */
	public java.lang.String getChain_range_end() 
	{
		return chain_range_end;
	}
 
	public void setChain_range_end(java.lang.String chain_range_end)
	{
		this.chain_range_end = chain_range_end;
	}

 	protected java.lang.String coord_average_rmsd_method;


	/**
	 *  Describe the method for calculating the coordinate average rmsd.
	 *  Replace with item example text
	 */
	public java.lang.String getCoord_average_rmsd_method() 
	{
		return coord_average_rmsd_method;
	}
 
	public void setCoord_average_rmsd_method(java.lang.String coord_average_rmsd_method)
	{
		this.coord_average_rmsd_method = coord_average_rmsd_method;
	}

 	protected java.lang.Float covalent_bond_rms_dev;


	/**
	 *  The covalent bond rmsd to the target value for the ensemble.
	 *  0.0066
	 */
	public java.lang.Float getCovalent_bond_rms_dev() 
	{
		return covalent_bond_rms_dev;
	}
 
	public void setCovalent_bond_rms_dev(java.lang.Float covalent_bond_rms_dev)
	{
		this.covalent_bond_rms_dev = covalent_bond_rms_dev;
	}

 	protected java.lang.Float covalent_bond_rms_dev_error;


	/**
	 *  The error in the covalent bond rmsd.
	 *  0.0001
	 */
	public java.lang.Float getCovalent_bond_rms_dev_error() 
	{
		return covalent_bond_rms_dev_error;
	}
 
	public void setCovalent_bond_rms_dev_error(java.lang.Float covalent_bond_rms_dev_error)
	{
		this.covalent_bond_rms_dev_error = covalent_bond_rms_dev_error;
	}

 	protected java.lang.Float dihedral_angles_rms_dev;


	/**
	 *  The dihedral angle rmsd to the target values for the ensemble.
	 *  0.66
	 */
	public java.lang.Float getDihedral_angles_rms_dev() 
	{
		return dihedral_angles_rms_dev;
	}
 
	public void setDihedral_angles_rms_dev(java.lang.Float dihedral_angles_rms_dev)
	{
		this.dihedral_angles_rms_dev = dihedral_angles_rms_dev;
	}

 	protected java.lang.Float dihedral_angles_rms_dev_error;


	/**
	 *  The error of the rmsd dihedral angles.
	 *  0.07
	 */
	public java.lang.Float getDihedral_angles_rms_dev_error() 
	{
		return dihedral_angles_rms_dev_error;
	}
 
	public void setDihedral_angles_rms_dev_error(java.lang.Float dihedral_angles_rms_dev_error)
	{
		this.dihedral_angles_rms_dev_error = dihedral_angles_rms_dev_error;
	}

 	protected java.lang.Float distance_rms_dev;


	/**
	 *  The distance rmsd to the mean structure for the ensemble of structures.
	 *  0.22
	 */
	public java.lang.Float getDistance_rms_dev() 
	{
		return distance_rms_dev;
	}
 
	public void setDistance_rms_dev(java.lang.Float distance_rms_dev)
	{
		this.distance_rms_dev = distance_rms_dev;
	}

 	protected java.lang.Float distance_rms_dev_error;


	/**
	 *  The error in the distance rmsd.
	 *  0.07
	 */
	public java.lang.Float getDistance_rms_dev_error() 
	{
		return distance_rms_dev_error;
	}
 
	public void setDistance_rms_dev_error(java.lang.Float distance_rms_dev_error)
	{
		this.distance_rms_dev_error = distance_rms_dev_error;
	}

 	protected java.lang.String entry_id;


	/**
	 *  '?'
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float improper_torsion_angle_rms_dev;


	/**
	 *  The improper torsion angle rmsd to the target values for the ensemble.
	 *  0.64
	 */
	public java.lang.Float getImproper_torsion_angle_rms_dev() 
	{
		return improper_torsion_angle_rms_dev;
	}
 
	public void setImproper_torsion_angle_rms_dev(java.lang.Float improper_torsion_angle_rms_dev)
	{
		this.improper_torsion_angle_rms_dev = improper_torsion_angle_rms_dev;
	}

 	protected java.lang.Float improper_torsion_angle_rms_dev_error;


	/**
	 *  The error in the improper torsion angle rmsd.
	 *  0.04
	 */
	public java.lang.Float getImproper_torsion_angle_rms_dev_error() 
	{
		return improper_torsion_angle_rms_dev_error;
	}
 
	public void setImproper_torsion_angle_rms_dev_error(java.lang.Float improper_torsion_angle_rms_dev_error)
	{
		this.improper_torsion_angle_rms_dev_error = improper_torsion_angle_rms_dev_error;
	}

 	protected java.lang.Float peptide_planarity_rms_dev;


	/**
	 *  The peptide planarity rmsd.
	 *  0.11
	 */
	public java.lang.Float getPeptide_planarity_rms_dev() 
	{
		return peptide_planarity_rms_dev;
	}
 
	public void setPeptide_planarity_rms_dev(java.lang.Float peptide_planarity_rms_dev)
	{
		this.peptide_planarity_rms_dev = peptide_planarity_rms_dev;
	}

 	protected java.lang.Float peptide_planarity_rms_dev_error;


	/**
	 *  The error in the peptide planarity rmsd.
	 *  0.05
	 */
	public java.lang.Float getPeptide_planarity_rms_dev_error() 
	{
		return peptide_planarity_rms_dev_error;
	}
 
	public void setPeptide_planarity_rms_dev_error(java.lang.Float peptide_planarity_rms_dev_error)
	{
		this.peptide_planarity_rms_dev_error = peptide_planarity_rms_dev_error;
	}

 	protected java.lang.Integer residue_range_begin;


	/**
	 *  Structure statistics are often calculated only over the well-ordered region(s)
	 *  of the biopolymer. Portions of the macromolecule are often mobile and
	 *  disordered,  hence they are excluded in calculating the statistics. To define
	 *  the range(s) over which the statistics are calculated, enter the beginning
	 *  residue number(s): e.g. if the regions used were 5-32 and 41-69, enter 5,41
	 *  5
	 *  41
	 */
	public java.lang.Integer getResidue_range_begin() 
	{
		return residue_range_begin;
	}
 
	public void setResidue_range_begin(java.lang.Integer residue_range_begin)
	{
		this.residue_range_begin = residue_range_begin;
	}

 	protected java.lang.Integer residue_range_end;


	/**
	 *  The ending residue number: e.g. 32,69.
	 *  32
	 *  69
	 */
	public java.lang.Integer getResidue_range_end() 
	{
		return residue_range_end;
	}
 
	public void setResidue_range_end(java.lang.Integer residue_range_end)
	{
		this.residue_range_end = residue_range_end;
	}

 }
