package org.pdb.beans;

/**
 *  In this section, enter information on those experiments that were
 *  used to generate constraint data. For each NMR experiment indicate
 *  which sample and which sample conditions were used for the experiment.
 *  This example was taken from the MCP-1 study.
 *  <PDBx:pdbx_nmr_exptlCategory>
 *  <PDBx:pdbx_nmr_exptl experiment_id="1" solution_id="3" conditions_id="1">
 *  <PDBx:type>3D_15N-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="2" solution_id="1" conditions_id="1">
 *  <PDBx:type>3D_13C-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="3" solution_id="1" conditions_id="2">
 *  <PDBx:type>4D_13C/15N-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="4" solution_id="1" conditions_id="1">
 *  <PDBx:type>4D_13C-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="5" solution_id="1" conditions_id="1">
 *  <PDBx:type>3D_15N-separated_ROESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="6" solution_id="3" conditions_id="1">
 *  <PDBx:type>3D_13C-separated_ROESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  </PDBx:pdbx_nmr_exptlCategory>
 */
public class Pdbx_nmr_exptl 
{
		protected java.lang.String conditions_id;


	/**
	 *  The number to identify the set of sample conditions.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getConditions_id() 
	{
		return conditions_id;
	}
 
	public void setConditions_id(java.lang.String conditions_id)
	{
		this.conditions_id = conditions_id;
	}

 	protected java.lang.String experiment_id;


	/**
	 *  A numerical ID for each experiment.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getExperiment_id() 
	{
		return experiment_id;
	}
 
	public void setExperiment_id(java.lang.String experiment_id)
	{
		this.experiment_id = experiment_id;
	}

 	protected java.lang.String solution_id;


	/**
	 *  The solution_id from the Experimental Sample to identify the sample
	 *  that these conditions refer to.
	 *  
	 *  [Remember to save the entries here before returning to the
	 *  Experimental Sample form]
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getSolution_id() 
	{
		return solution_id;
	}
 
	public void setSolution_id(java.lang.String solution_id)
	{
		this.solution_id = solution_id;
	}

 	protected java.lang.String type;


	/**
	 *  The type of NMR experiment.
	 *  2D NOESY
	 *  3D_15N-separated_NOESY
	 *  3D_13C-separated_NOESY
	 *  4D_13C-separated_NOESY
	 *  4D_13C/15N-separated_NOESY
	 *  3D_15N-separated_ROESY
	 *  3D_13C-separated_ROESY
	 *  HNCA-J
	 *  HNHA
	 *  DQF-COSY
	 *  P-COSY
	 *  PE-COSY
	 *  E-COSY
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
