package org.pdb.beans;

/**
 *  The chemical constituents of
 *  each NMR sample. Each sample is identified by a number and
 *  each component in the sample is identified by name.
 *  
 * <pre>
 *  Example 1
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied. Three solutions with different isotope compositions were
 *  studied.
 *  <PDBx:pdbx_nmr_exptl_sampleCategory>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="MCP-1">
 *  <PDBx:concentration>2.</PDBx:concentration>
 *  <PDBx:concentration_units>mM</PDBx:concentration_units>
 *  <PDBx:isotopic_labeling>U-15N,13C</PDBx:isotopic_labeling>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="H2O">
 *  <PDBx:concentration>90.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="D2O">
 *  <PDBx:concentration>10.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  </PDBx:pdbx_nmr_exptl_sampleCategory>
 *  
 *  
 *  Example 2
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied. Three solutions with different isotope compositions were
 *  studied.
 *  <PDBx:pdbx_nmr_exptl_sampleCategory>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="MCP-1">
 *  <PDBx:concentration>1.</PDBx:concentration>
 *  <PDBx:concentration_units>mM</PDBx:concentration_units>
 *  <PDBx:isotopic_labeling>U-50&#37; 15N</PDBx:isotopic_labeling>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="H2O">
 *  <PDBx:concentration>90.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="D2O">
 *  <PDBx:concentration>10.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  </PDBx:pdbx_nmr_exptl_sampleCategory>
 * </pre>
 */
public class Pdbx_nmr_exptl_sample 
{
		protected java.lang.String component;


	/**
	 *  The name of each component in the sample
	 *  ribonuclease
	 *  DNA strand 1
	 *  TRIS buffer
	 *  sodium chloride
	 *  H2O
	 *  D2O
	 */
	public java.lang.String getComponent() 
	{
		return component;
	}
 
	public void setComponent(java.lang.String component)
	{
		this.component = component;
	}

 	protected java.lang.Float concentration;


	/**
	 *  The concentration value of the component.
	 *  2.0
	 *  2.7
	 *  0.01
	 */
	public java.lang.Float getConcentration() 
	{
		return concentration;
	}
 
	public void setConcentration(java.lang.Float concentration)
	{
		this.concentration = concentration;
	}

 	protected java.lang.String concentration_units;


	/**
	 *  The concentration units of the component.
	 *  mg/mL for mg per milliliter
	 *  mM for millimolar
	 *  % for percent by volume
	 */
	public java.lang.String getConcentration_units() 
	{
		return concentration_units;
	}
 
	public void setConcentration_units(java.lang.String concentration_units)
	{
		this.concentration_units = concentration_units;
	}

 	protected java.lang.String isotopic_labeling;


	/**
	 *  The isotopic composition of each component, including
	 *  the % labeling level, if known. For example:
	 *  1. Uniform (random) labeling with 15N: U-15N
	 *  2. Uniform (random) labeling with 13C, 15N at known labeling
	 *  levels: U-95% 13C;U-98% 15N
	 *  3. Residue selective labeling: U-95% 15N-Thymine
	 *  4. Site specific labeling: 95% 13C-Ala18,
	 *  5. Natural abundance labeling in an otherwise uniformly labled
	 *  biomolecule is designated by NA: U-13C; NA-K,H
	 *  U-13C,15N
	 *  U-2H
	 */
	public java.lang.String getIsotopic_labeling() 
	{
		return isotopic_labeling;
	}
 
	public void setIsotopic_labeling(java.lang.String isotopic_labeling)
	{
		this.isotopic_labeling = isotopic_labeling;
	}

 	protected java.lang.String solution_id;


	/**
	 *  The name (number) of the sample.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getSolution_id() 
	{
		return solution_id;
	}
 
	public void setSolution_id(java.lang.String solution_id)
	{
		this.solution_id = solution_id;
	}

 }
