package org.pdb.beans;

/**
 *  The experimental conditions used to for each sample.  Each set of conditions
 *  is identified by a numerical code.
 *  This example was taken from a pH stability study.
 *  <PDBx:pdbx_nmr_exptl_sample_conditionsCategory>
 *  <PDBx:pdbx_nmr_exptl_sample_conditions conditions_id="1">
 *  <PDBx:temperature>298</PDBx:temperature>
 *  <PDBx:pressure>ambient</PDBx:pressure>
 *  <PDBx:pH>7</PDBx:pH>
 *  <PDBx:ionic_strength>25mM NaCl</PDBx:ionic_strength>
 *  </PDBx:pdbx_nmr_exptl_sample_conditions>
 *  <PDBx:pdbx_nmr_exptl_sample_conditions conditions_id="2">
 *  <PDBx:temperature>298</PDBx:temperature>
 *  <PDBx:pressure>ambient</PDBx:pressure>
 *  <PDBx:pH>3</PDBx:pH>
 *  <PDBx:ionic_strength>25mM NaCl</PDBx:ionic_strength>
 *  </PDBx:pdbx_nmr_exptl_sample_conditions>
 *  </PDBx:pdbx_nmr_exptl_sample_conditionsCategory>
 */
public class Pdbx_nmr_exptl_sample_conditions 
{
		protected java.lang.String conditions_id;


	/**
	 *  The condition number as defined above.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getConditions_id() 
	{
		return conditions_id;
	}
 
	public void setConditions_id(java.lang.String conditions_id)
	{
		this.conditions_id = conditions_id;
	}

 	protected java.lang.String ionic_strength;


	/**
	 *  The ionic strength at which the NMR data were collected -in lieu of
	 *  this enter the concentration and identity of the salt in the sample.
	 */
	public java.lang.String getIonic_strength() 
	{
		return ionic_strength;
	}
 
	public void setIonic_strength(java.lang.String ionic_strength)
	{
		this.ionic_strength = ionic_strength;
	}

 	protected java.lang.String pH;


	/**
	 *  The pH at which the NMR data were collected.
	 *  3.1
	 *  7.0
	 */
	public java.lang.String getPH() 
	{
		return pH;
	}
 
	public void setPH(java.lang.String pH)
	{
		this.pH = pH;
	}

 	protected java.lang.String pressure;


	/**
	 *  The pressure at which NMR data were collected.
	 *  ambient
	 *  1atm
	 */
	public java.lang.String getPressure() 
	{
		return pressure;
	}
 
	public void setPressure(java.lang.String pressure)
	{
		this.pressure = pressure;
	}

 	protected java.lang.String pressure_units;


	/**
	 *  The units of pressure at which NMR data were collected.
	 *  Pa
	 *  atm
	 *  Torr
	 */
	public java.lang.String getPressure_units() 
	{
		return pressure_units;
	}
 
	public void setPressure_units(java.lang.String pressure_units)
	{
		this.pressure_units = pressure_units;
	}

 	protected java.lang.String temperature;


	/**
	 *  The temperature (in Kelvin) at which NMR data were
	 *  collected.
	 *  298
	 */
	public java.lang.String getTemperature() 
	{
		return temperature;
	}
 
	public void setTemperature(java.lang.String temperature)
	{
		this.temperature = temperature;
	}

 }
