package org.pdb.beans;

/**
 *  The final force constants, including units, employed for the various
 *  experimental constraints, covalent geometry constraints, and the non-bonded
 *  interaction terms in the target function used for simulated annealing.
 *  
 *  This example is taken from a study of BAF, a dimeric DNA binding protein.
 *  The final force constants in the target function used for simulated
 *  annealing are:  Experimental Constraint terms: Distance (NOE,H-bonds),
 *  Torsion angles, J coupling, 13C shifts, 1H shifts, Dipolar coupling,
 *  D isotope shifts Covalent Geometry Constraint terms: Bond lengths,
 *  Angles, Impropers Non-bonded Interaction terms: van der Waals,
 *  Type of van der Waals term, Conformational database potential,
 *  Radius of gyration.
 *  <PDBx:pdbx_nmr_force_constantsCategory>
 *  <PDBx:pdbx_nmr_force_constants entry_id="1ABC">
 *  <PDBx:exptl_distance_term>30.</PDBx:exptl_distance_term>
 *  <PDBx:exptl_distance_term_units>kcal/mol/A**2</PDBx:exptl_distance_term_units>
 *  <PDBx:exptl_torsion_angles_term>200.</PDBx:exptl_torsion_angles_term>
 *  <PDBx:exptl_torsion_angles_term_units>kcal/mol/rad**2</PDBx:exptl_torsion_angles_term_units>
 *  <PDBx:exptl_J_coupling_term>1.</PDBx:exptl_J_coupling_term>
 *  <PDBx:exptl_J_coupling_term_units>kcal/mol/Hz**2</PDBx:exptl_J_coupling_term_units>
 *  <PDBx:exptl_13C_shift_term>0.5</PDBx:exptl_13C_shift_term>
 *  <PDBx:exptl_13C_shift_term_units>kcal/mol/ppm**2</PDBx:exptl_13C_shift_term_units>
 *  <PDBx:exptl_1H_shift_term>7.5</PDBx:exptl_1H_shift_term>
 *  <PDBx:exptl_1H_shift_term_units>kcal/mol/ppm**2</PDBx:exptl_1H_shift_term_units>
 *  <PDBx:covalent_geom_bond_term>1000.</PDBx:covalent_geom_bond_term>
 *  <PDBx:covalent_geom_bond_term_units>kcal/mol/A**2</PDBx:covalent_geom_bond_term_units>
 *  <PDBx:non-bonded_inter_van_der_Waals_term_type>4.</PDBx:non-bonded_inter_van_der_Waals_term_type>
 *  </PDBx:pdbx_nmr_force_constants>
 *  </PDBx:pdbx_nmr_force_constantsCategory>
 */
public class Pdbx_nmr_force_constants 
{
		protected java.lang.Float covalent_geom_angles_term;


	/**
	 *  The final force constant for covalent geometry angle constraints
	 *  term employed in the target function used for simulated annealing.
	 *  500
	 */
	public java.lang.Float getCovalent_geom_angles_term() 
	{
		return covalent_geom_angles_term;
	}
 
	public void setCovalent_geom_angles_term(java.lang.Float covalent_geom_angles_term)
	{
		this.covalent_geom_angles_term = covalent_geom_angles_term;
	}

 	protected java.lang.String covalent_geom_angles_term_units;


	/**
	 *  The units for the force constant for the covalent geometry angle
	 *  constraints term.
	 *  kcal/mol/rad**2
	 */
	public java.lang.String getCovalent_geom_angles_term_units() 
	{
		return covalent_geom_angles_term_units;
	}
 
	public void setCovalent_geom_angles_term_units(java.lang.String covalent_geom_angles_term_units)
	{
		this.covalent_geom_angles_term_units = covalent_geom_angles_term_units;
	}

 	protected java.lang.Float covalent_geom_bond_term;


	/**
	 *  The final force constant for the covalent geometry bond length
	 *  constraints term employed in the target function used for simulated
	 *  annealing.
	 *  1000
	 */
	public java.lang.Float getCovalent_geom_bond_term() 
	{
		return covalent_geom_bond_term;
	}
 
	public void setCovalent_geom_bond_term(java.lang.Float covalent_geom_bond_term)
	{
		this.covalent_geom_bond_term = covalent_geom_bond_term;
	}

 	protected java.lang.String covalent_geom_bond_term_units;


	/**
	 *  The units for the force constant for the covalent geometry bond
	 *  length constraints term.
	 *  kcal/mol/A**2
	 */
	public java.lang.String getCovalent_geom_bond_term_units() 
	{
		return covalent_geom_bond_term_units;
	}
 
	public void setCovalent_geom_bond_term_units(java.lang.String covalent_geom_bond_term_units)
	{
		this.covalent_geom_bond_term_units = covalent_geom_bond_term_units;
	}

 	protected java.lang.Float covalent_geom_impropers_term;


	/**
	 *  The final force constant for covalent geometry impropers
	 *  contstraints term employed in the target function used for simulated
	 *  annealing.
	 *  500
	 */
	public java.lang.Float getCovalent_geom_impropers_term() 
	{
		return covalent_geom_impropers_term;
	}
 
	public void setCovalent_geom_impropers_term(java.lang.Float covalent_geom_impropers_term)
	{
		this.covalent_geom_impropers_term = covalent_geom_impropers_term;
	}

 	protected java.lang.String covalent_geom_impropers_term_units;


	/**
	 *  The units for the force constant for the covalent geometry
	 *  impropers constraints term.
	 *  kcal/mol/rad**2
	 */
	public java.lang.String getCovalent_geom_impropers_term_units() 
	{
		return covalent_geom_impropers_term_units;
	}
 
	public void setCovalent_geom_impropers_term_units(java.lang.String covalent_geom_impropers_term_units)
	{
		this.covalent_geom_impropers_term_units = covalent_geom_impropers_term_units;
	}

 	protected java.lang.String entry_id;


	/**
	 *  You can leave this blank as an ID will be assigned by the RCSB.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float exptl_13C_shift_term;


	/**
	 *  The final force constant for 13C shift constraints term employed
	 *  in the target function used for simulated annealing.
	 *  0.5
	 */
	public java.lang.Float getExptl_13C_shift_term() 
	{
		return exptl_13C_shift_term;
	}
 
	public void setExptl_13C_shift_term(java.lang.Float exptl_13C_shift_term)
	{
		this.exptl_13C_shift_term = exptl_13C_shift_term;
	}

 	protected java.lang.String exptl_13C_shift_term_units;


	/**
	 *  The units for the force constant for the 13C shift constraints
	 *  term.
	 *  kcal/mol/ppm**2
	 */
	public java.lang.String getExptl_13C_shift_term_units() 
	{
		return exptl_13C_shift_term_units;
	}
 
	public void setExptl_13C_shift_term_units(java.lang.String exptl_13C_shift_term_units)
	{
		this.exptl_13C_shift_term_units = exptl_13C_shift_term_units;
	}

 	protected java.lang.Float exptl_1H_shift_term;


	/**
	 *  The final force constant for 1H shift constraints term employed
	 *  in the target function used for simulated annealing.
	 *  7.5
	 */
	public java.lang.Float getExptl_1H_shift_term() 
	{
		return exptl_1H_shift_term;
	}
 
	public void setExptl_1H_shift_term(java.lang.Float exptl_1H_shift_term)
	{
		this.exptl_1H_shift_term = exptl_1H_shift_term;
	}

 	protected java.lang.String exptl_1H_shift_term_units;


	/**
	 *  The units for the force constant for the 1H shift constraints term.
	 *  kcal/mol/ppm**2
	 */
	public java.lang.String getExptl_1H_shift_term_units() 
	{
		return exptl_1H_shift_term_units;
	}
 
	public void setExptl_1H_shift_term_units(java.lang.String exptl_1H_shift_term_units)
	{
		this.exptl_1H_shift_term_units = exptl_1H_shift_term_units;
	}

 	protected java.lang.Float exptl_D_isotope_shift_term;


	/**
	 *  The final force constant for Deuterium isotope shift constraints
	 *  term employed in the target function used for simulated annealing.
	 *  0.5
	 */
	public java.lang.Float getExptl_D_isotope_shift_term() 
	{
		return exptl_D_isotope_shift_term;
	}
 
	public void setExptl_D_isotope_shift_term(java.lang.Float exptl_D_isotope_shift_term)
	{
		this.exptl_D_isotope_shift_term = exptl_D_isotope_shift_term;
	}

 	protected java.lang.String exptl_D_isotope_shift_term_units;


	/**
	 *  The units for the force constant for the Deuterium isotope
	 *  shift constraints term.
	 *  kcal/mol/ppb**2
	 */
	public java.lang.String getExptl_D_isotope_shift_term_units() 
	{
		return exptl_D_isotope_shift_term_units;
	}
 
	public void setExptl_D_isotope_shift_term_units(java.lang.String exptl_D_isotope_shift_term_units)
	{
		this.exptl_D_isotope_shift_term_units = exptl_D_isotope_shift_term_units;
	}

 	protected java.lang.Float exptl_J_coupling_term;


	/**
	 *  The final force constant for J coupling term employed in the
	 *  target function used for simulated annealing.
	 *  1
	 */
	public java.lang.Float getExptl_J_coupling_term() 
	{
		return exptl_J_coupling_term;
	}
 
	public void setExptl_J_coupling_term(java.lang.Float exptl_J_coupling_term)
	{
		this.exptl_J_coupling_term = exptl_J_coupling_term;
	}

 	protected java.lang.String exptl_J_coupling_term_units;


	/**
	 *  The units for the force constant for the J coupling term.
	 *  kcal/mol/Hz**2
	 */
	public java.lang.String getExptl_J_coupling_term_units() 
	{
		return exptl_J_coupling_term_units;
	}
 
	public void setExptl_J_coupling_term_units(java.lang.String exptl_J_coupling_term_units)
	{
		this.exptl_J_coupling_term_units = exptl_J_coupling_term_units;
	}

 	protected java.lang.Float exptl_dipolar_coupling_term;


	/**
	 *  The final force constant for dipolar coupling constraint term
	 *  employed in the target function used for simulated annealing.
	 *  1
	 */
	public java.lang.Float getExptl_dipolar_coupling_term() 
	{
		return exptl_dipolar_coupling_term;
	}
 
	public void setExptl_dipolar_coupling_term(java.lang.Float exptl_dipolar_coupling_term)
	{
		this.exptl_dipolar_coupling_term = exptl_dipolar_coupling_term;
	}

 	protected java.lang.String exptl_dipolar_coupling_term_units;


	/**
	 *  The units for the force constant for the dipolar coupling
	 *  constraints term.
	 *  kcal/mol/Hz**2
	 */
	public java.lang.String getExptl_dipolar_coupling_term_units() 
	{
		return exptl_dipolar_coupling_term_units;
	}
 
	public void setExptl_dipolar_coupling_term_units(java.lang.String exptl_dipolar_coupling_term_units)
	{
		this.exptl_dipolar_coupling_term_units = exptl_dipolar_coupling_term_units;
	}

 	protected java.lang.Float exptl_distance_term;


	/**
	 *  The final force constant for distance (NOEs) constraints
	 *  term employed in the target function used for simulated annealing.
	 *  30
	 */
	public java.lang.Float getExptl_distance_term() 
	{
		return exptl_distance_term;
	}
 
	public void setExptl_distance_term(java.lang.Float exptl_distance_term)
	{
		this.exptl_distance_term = exptl_distance_term;
	}

 	protected java.lang.String exptl_distance_term_units;


	/**
	 *  The units for the force constant for the distance
	 *  constraints term.
	 *  kcal/mol/ A**2
	 */
	public java.lang.String getExptl_distance_term_units() 
	{
		return exptl_distance_term_units;
	}
 
	public void setExptl_distance_term_units(java.lang.String exptl_distance_term_units)
	{
		this.exptl_distance_term_units = exptl_distance_term_units;
	}

 	protected java.lang.Float exptl_torsion_angles_term;


	/**
	 *  The final force constant for the torsion angle term employed in
	 *  the target function used for simulated annealing.
	 *  200
	 */
	public java.lang.Float getExptl_torsion_angles_term() 
	{
		return exptl_torsion_angles_term;
	}
 
	public void setExptl_torsion_angles_term(java.lang.Float exptl_torsion_angles_term)
	{
		this.exptl_torsion_angles_term = exptl_torsion_angles_term;
	}

 	protected java.lang.String exptl_torsion_angles_term_units;


	/**
	 *  The units for the force constant for the torsion angle
	 *  constraints term.
	 *  kcal/mol/rad**2
	 */
	public java.lang.String getExptl_torsion_angles_term_units() 
	{
		return exptl_torsion_angles_term_units;
	}
 
	public void setExptl_torsion_angles_term_units(java.lang.String exptl_torsion_angles_term_units)
	{
		this.exptl_torsion_angles_term_units = exptl_torsion_angles_term_units;
	}

 	protected java.lang.Float non_bonded_inter_conf_db_potential_term;


	/**
	 *  The force constant used for the non-bonded interaction conformational
	 *  database potential term employed in the target function used for simulated
	 *  annealing.
	 *  1.0
	 */
	public java.lang.Float getNon_bonded_inter_conf_db_potential_term() 
	{
		return non_bonded_inter_conf_db_potential_term;
	}
 
	public void setNon_bonded_inter_conf_db_potential_term(java.lang.Float non_bonded_inter_conf_db_potential_term)
	{
		this.non_bonded_inter_conf_db_potential_term = non_bonded_inter_conf_db_potential_term;
	}

 	protected java.lang.Float non_bonded_inter_radius_of_gyration_term;


	/**
	 *  The force constant used for the non-bonded interaction radius of
	 *  gyration term employed in the target function used for simulated annealing.
	 *  100
	 */
	public java.lang.Float getNon_bonded_inter_radius_of_gyration_term() 
	{
		return non_bonded_inter_radius_of_gyration_term;
	}
 
	public void setNon_bonded_inter_radius_of_gyration_term(java.lang.Float non_bonded_inter_radius_of_gyration_term)
	{
		this.non_bonded_inter_radius_of_gyration_term = non_bonded_inter_radius_of_gyration_term;
	}

 	protected java.lang.String non_bonded_inter_radius_of_gyration_term_units;


	/**
	 *  The units for the force constant for the radius of gyration term.
	 *  kcal/mol/ A**2
	 */
	public java.lang.String getNon_bonded_inter_radius_of_gyration_term_units() 
	{
		return non_bonded_inter_radius_of_gyration_term_units;
	}
 
	public void setNon_bonded_inter_radius_of_gyration_term_units(java.lang.String non_bonded_inter_radius_of_gyration_term_units)
	{
		this.non_bonded_inter_radius_of_gyration_term_units = non_bonded_inter_radius_of_gyration_term_units;
	}

 	protected java.lang.Float non_bonded_inter_van_der_Waals_term;


	/**
	 *  The force constant used for the non-bonded interaction van der Waals
	 *  term employed in the target function used for simulated annealing.
	 *  4
	 */
	public java.lang.Float getNon_bonded_inter_van_der_Waals_term() 
	{
		return non_bonded_inter_van_der_Waals_term;
	}
 
	public void setNon_bonded_inter_van_der_Waals_term(java.lang.Float non_bonded_inter_van_der_Waals_term)
	{
		this.non_bonded_inter_van_der_Waals_term = non_bonded_inter_van_der_Waals_term;
	}

 	protected java.lang.String non_bonded_inter_van_der_Waals_term_type;


	/**
	 *  The type of van der Waals term employed in the target function
	 *  used for simulated annealing.
	 *  quartic
	 */
	public java.lang.String getNon_bonded_inter_van_der_Waals_term_type() 
	{
		return non_bonded_inter_van_der_Waals_term_type;
	}
 
	public void setNon_bonded_inter_van_der_Waals_term_type(java.lang.String non_bonded_inter_van_der_Waals_term_type)
	{
		this.non_bonded_inter_van_der_Waals_term_type = non_bonded_inter_van_der_Waals_term_type;
	}

 	protected java.lang.String non_bonded_inter_van_der_Waals_term_units;


	/**
	 *  The units for the force constant for the van der Waals term.
	 *  kcal/mol/ A**4
	 */
	public java.lang.String getNon_bonded_inter_van_der_Waals_term_units() 
	{
		return non_bonded_inter_van_der_Waals_term_units;
	}
 
	public void setNon_bonded_inter_van_der_Waals_term_units(java.lang.String non_bonded_inter_van_der_Waals_term_units)
	{
		this.non_bonded_inter_van_der_Waals_term_units = non_bonded_inter_van_der_Waals_term_units;
	}

 }
