package org.pdb.beans;

/**
 *  An average structure is often calculated in addition to the ensemble, or one
 *  of the ensemble is selected as a representative structure. This section
 *  describes selection of the representative structure.
 *  This example is drawn from the MCP-1 structure.
 *  <PDBx:pdbx_nmr_representativeCategory>
 *  <PDBx:pdbx_nmr_representative entry_id="1ABC">
 *  <PDBx:conformer_id>15</PDBx:conformer_id>
 *  <PDBx:selection_criteria>lowest energy</PDBx:selection_criteria>
 *  </PDBx:pdbx_nmr_representative>
 *  </PDBx:pdbx_nmr_representativeCategory>
 */
public class Pdbx_nmr_representative 
{
		protected java.lang.String conformer_id;


	/**
	 *  If a member of the ensemble has been selected as a representative
	 *  structure, identify it by its model number.
	 *  15
	 */
	public java.lang.String getConformer_id() 
	{
		return conformer_id;
	}
 
	public void setConformer_id(java.lang.String conformer_id)
	{
		this.conformer_id = conformer_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  msd will assign the ID.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String selection_criteria;


	/**
	 *  By highlighting the appropriate choice(s), describe the criteria used to
	 *  select this structure as a representative structure, or if an average
	 *  structure has been calculated describe how this was done.
	 *  
	 *  The structure closest to the average.
	 *  The structure with the lowest energy was selected.
	 *  The structure with the fewest number of violations was selected.
	 *  A minimized average structure was calculated.
	 */
	public java.lang.String getSelection_criteria() 
	{
		return selection_criteria;
	}
 
	public void setSelection_criteria(java.lang.String selection_criteria)
	{
		this.selection_criteria = selection_criteria;
	}

 }
