package org.pdb.beans;

/**
 *  Description of the software that was used for data collection, data processing,
 *  data analysis, structure calculations and refinement. The description should
 *  include the name of the software, the author of the software and the version used.
 *  This example describes the software used in the MCP-1 study.
 *  <PDBx:pdbx_nmr_softwareCategory>
 *  <PDBx:pdbx_nmr_software name="UXNMR" version="940501.3" classification="collection">
 *  <PDBx:authors>Bruker</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="FELIX" version="1.1" classification="processing">
 *  <PDBx:authors>Hare</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="ANSIG" version="3.0" classification="data analysis">
 *  <PDBx:authors>Kraulis</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="X-PLOR" version="3.8" classification="structure calculation">
 *  <PDBx:authors>Brunger</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="X-PLOR" version="3.8" classification="refinement">
 *  <PDBx:authors>Brunger</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  </PDBx:pdbx_nmr_softwareCategory>
 */
public class Pdbx_nmr_software 
{
		protected java.lang.String authors;


	/**
	 *  The name of the authors of the software used in this
	 *  procedure.
	 *  Brunger
	 *  Guentert
	 */
	public java.lang.String getAuthors() 
	{
		return authors;
	}
 
	public void setAuthors(java.lang.String authors)
	{
		this.authors = authors;
	}

 	protected java.lang.String classification;


	/**
	 *  The purpose of the software.
	 *  collection
	 *  processing
	 *  data analysis
	 *  structure solution
	 *  refinement
	 *  iterative matrix relaxation
	 */
	public java.lang.String getClassification() 
	{
		return classification;
	}
 
	public void setClassification(java.lang.String classification)
	{
		this.classification = classification;
	}

 	protected java.lang.String name;


	/**
	 *  The name of the software used for the task.
	 *  ANSIG
	 *  AURELIA
	 *  AZARA
	 *  CHARMM
	 *  CORMA
	 *  DIANA
	 *  DYANA
	 *  DSPACE
	 *  DISGEO
	 *  DGII
	 *  DISMAN
	 *  DINOSAUR
	 *  DISCOVER
	 *  FELIX
	 *  FT_NMR
	 *  GROMOS
	 *  IRMA
	 *  MARDIGRAS
	 *  NMRPipe
	 *  SA
	 *  UXNMR
	 *  VNMR
	 *  X-PLOR
	 *  XWINNMR
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String version;


	/**
	 *  The version of the software.
	 *  940501.3
	 *  2.1
	 */
	public java.lang.String getVersion() 
	{
		return version;
	}
 
	public void setVersion(java.lang.String version)
	{
		this.version = version;
	}

 }
