package org.pdb.beans;

/**
 *  The details about each spectrometer used to collect data for this
 *  deposition.
 *  The instruments described here are the ones used for the MCP-1 studies.
 *  <PDBx:pdbx_nmr_spectrometerCategory>
 *  <PDBx:pdbx_nmr_spectrometer spectrometer_id="1">
 *  <PDBx:type>Bruker AMX</PDBx:type>
 *  <PDBx:field_strength>600.</PDBx:field_strength>
 *  </PDBx:pdbx_nmr_spectrometer>
 *  <PDBx:pdbx_nmr_spectrometer spectrometer_id="2">
 *  <PDBx:type>Bruker AMX</PDBx:type>
 *  <PDBx:field_strength>500.</PDBx:field_strength>
 *  </PDBx:pdbx_nmr_spectrometer>
 *  </PDBx:pdbx_nmr_spectrometerCategory>
 */
public class Pdbx_nmr_spectrometer 
{
		protected java.lang.Float field_strength;


	/**
	 *  Select the field strength for protons in MHz.
	 *  360
	 *  400
	 *  500
	 *  600
	 *  750
	 *  800
	 *  850
	 *  900
	 *  950
	 *  1000
	 */
	public java.lang.Float getField_strength() 
	{
		return field_strength;
	}
 
	public void setField_strength(java.lang.Float field_strength)
	{
		this.field_strength = field_strength;
	}

 	protected java.lang.String manufacturer;


	/**
	 *  The name of the manufacturer of the spectrometer.
	 *  Varian
	 *  Bruker
	 *  JEOL
	 *  GE
	 */
	public java.lang.String getManufacturer() 
	{
		return manufacturer;
	}
 
	public void setManufacturer(java.lang.String manufacturer)
	{
		this.manufacturer = manufacturer;
	}

 	protected java.lang.String model;


	/**
	 *  The model of the NMR spectrometer.
	 *  AVANCE
	 *  WH
	 *  WM
	 *  AM
	 *  AMX
	 *  DMX
	 *  DRX
	 *  MSL
	 *  OMEGA
	 *  OMEGA PSG
	 *  GX
	 *  GSX
	 *  A
	 *  AL
	 *  EC
	 *  EX
	 *  LA
	 *  ECP
	 *  VXRS
	 *  UNITY
	 *  UNITYPLUS
	 *  INOVA
	 */
	public java.lang.String getModel() 
	{
		return model;
	}
 
	public void setModel(java.lang.String model)
	{
		this.model = model;
	}

 	protected java.lang.String spectrometer_id;


	/**
	 *  Assign a numerical ID to each instrument.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getSpectrometer_id() 
	{
		return spectrometer_id;
	}
 
	public void setSpectrometer_id(java.lang.String spectrometer_id)
	{
		this.spectrometer_id = spectrometer_id;
	}

 	protected java.lang.String type;


	/**
	 *  Select the instrument manufacturer(s) and the model(s) of the NMR(s)
	 *  used for this work.
	 *  Bruker WH
	 *  Bruker WM
	 *  Bruker AM
	 *  Bruker AMX
	 *  Bruker DMX
	 *  Bruker DRX
	 *  Bruker MSL
	 *  Bruker AVANCE
	 *  GE Omega
	 *  GE Omega PSG
	 *  JEOL GX
	 *  JEOL GSX
	 *  JEOL A
	 *  JEOL AL
	 *  JEOL EC
	 *  JEOL EX
	 *  JEOL LA
	 *  JEOL ECP
	 *  Varian VXRS
	 *  Varian UNITY
	 *  Varian UNITYplus
	 *  Varian INOVA
	 *  other
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
