package org.pdb.beans;

/**
 *  record the details (coordinates etc.) of anomalous scatters.
 *  
 *  
 *  
 * <pre>
 *  Example 1 -  anomalous scatters is Se
 *  <PDBx:pdbx_phasing_MAD_set_siteCategory>
 *  <PDBx:pdbx_phasing_MAD_set_site id="1">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>25.9407</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>-0.103471</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>17.4094</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  <PDBx:pdbx_phasing_MAD_set_site id="2">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>30.6534</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>6.62359</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>9.93063</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  <PDBx:pdbx_phasing_MAD_set_site id="3">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>-3.26506</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>15.5546</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>53.9529</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  </PDBx:pdbx_phasing_MAD_set_siteCategory>
 * </pre>
 */
public class Pdbx_phasing_MAD_set_site 
{
		protected java.lang.Float Cartn_x;


	/**
	 *  attribute Cartn_x in category pdbx_phasing_MAD_set_site records the X Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_x() 
	{
		return Cartn_x;
	}
 
	public void setCartn_x(java.lang.Float Cartn_x)
	{
		this.Cartn_x = Cartn_x;
	}

 	protected java.lang.Float Cartn_x_esd;


	/**
	 *  attribute Cartn_x_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation X  Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_x_esd() 
	{
		return Cartn_x_esd;
	}
 
	public void setCartn_x_esd(java.lang.Float Cartn_x_esd)
	{
		this.Cartn_x_esd = Cartn_x_esd;
	}

 	protected java.lang.Float Cartn_y;


	/**
	 *  attribute Cartn_y in category pdbx_phasing_MAD_set_site records the Y Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_y() 
	{
		return Cartn_y;
	}
 
	public void setCartn_y(java.lang.Float Cartn_y)
	{
		this.Cartn_y = Cartn_y;
	}

 	protected java.lang.Float Cartn_y_esd;


	/**
	 *  attribute Cartn_y_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation Y  Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_y_esd() 
	{
		return Cartn_y_esd;
	}
 
	public void setCartn_y_esd(java.lang.Float Cartn_y_esd)
	{
		this.Cartn_y_esd = Cartn_y_esd;
	}

 	protected java.lang.Float Cartn_z;


	/**
	 *  attribute Cartn_z in category pdbx_phasing_MAD_set_site records the Z Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_z() 
	{
		return Cartn_z;
	}
 
	public void setCartn_z(java.lang.Float Cartn_z)
	{
		this.Cartn_z = Cartn_z;
	}

 	protected java.lang.Float Cartn_z_esd;


	/**
	 *  attribute Cartn_z_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation Z  Cartesian
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getCartn_z_esd() 
	{
		return Cartn_z_esd;
	}
 
	public void setCartn_z_esd(java.lang.Float Cartn_z_esd)
	{
		this.Cartn_z_esd = Cartn_z_esd;
	}

 	protected java.lang.String atom_type_symbol;


	/**
	 *  attribute atom_type_symbol in category pdbx_phasing_MAD_set_site records the name of site
	 *  obtained from MAD phasing.
	 */
	public java.lang.String getAtom_type_symbol() 
	{
		return atom_type_symbol;
	}
 
	public void setAtom_type_symbol(java.lang.String atom_type_symbol)
	{
		this.atom_type_symbol = atom_type_symbol;
	}

 	protected java.lang.Float b_iso;


	/**
	 *  attribute b_iso in category pdbx_phasing_MAD_set_site records isotropic
	 *  temperature factor parameterthe for the site
	 *  obtained from MAD phasing.
	 */
	public java.lang.Float getB_iso() 
	{
		return b_iso;
	}
 
	public void setB_iso(java.lang.Float b_iso)
	{
		this.b_iso = b_iso;
	}

 	protected java.lang.Float b_iso_esd;


	/**
	 *  attribute b_iso_esd in category pdbx_phasing_MAD_set_site records estimated
	 *  standard deviation of isotropic
	 *  temperature factor parameterthe for the site
	 *  obtained from MAD phasing.
	 */
	public java.lang.Float getB_iso_esd() 
	{
		return b_iso_esd;
	}
 
	public void setB_iso_esd(java.lang.Float b_iso_esd)
	{
		this.b_iso_esd = b_iso_esd;
	}

 	protected java.lang.Float fract_x;


	/**
	 *  attribute fract_x in category pdbx_phasing_MAD_set_site records the X fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_x() 
	{
		return fract_x;
	}
 
	public void setFract_x(java.lang.Float fract_x)
	{
		this.fract_x = fract_x;
	}

 	protected java.lang.Float fract_x_esd;


	/**
	 *  attribute fract_x_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation X  fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_x_esd() 
	{
		return fract_x_esd;
	}
 
	public void setFract_x_esd(java.lang.Float fract_x_esd)
	{
		this.fract_x_esd = fract_x_esd;
	}

 	protected java.lang.Float fract_y;


	/**
	 *  attribute fract_y in category pdbx_phasing_MAD_set_site records the Y fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_y() 
	{
		return fract_y;
	}
 
	public void setFract_y(java.lang.Float fract_y)
	{
		this.fract_y = fract_y;
	}

 	protected java.lang.Float fract_y_esd;


	/**
	 *  attribute fract_y_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation Y  fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_y_esd() 
	{
		return fract_y_esd;
	}
 
	public void setFract_y_esd(java.lang.Float fract_y_esd)
	{
		this.fract_y_esd = fract_y_esd;
	}

 	protected java.lang.Float fract_z;


	/**
	 *  attribute fract_z in category pdbx_phasing_MAD_set_site records the Z fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_z() 
	{
		return fract_z;
	}
 
	public void setFract_z(java.lang.Float fract_z)
	{
		this.fract_z = fract_z;
	}

 	protected java.lang.Float fract_z_esd;


	/**
	 *  attribute fract_z_esd in category pdbx_phasing_MAD_set_site records the estimated
	 *  standard deviation Z  fractional
	 *  coordinate of site obtained from MAD phasing.
	 */
	public java.lang.Float getFract_z_esd() 
	{
		return fract_z_esd;
	}
 
	public void setFract_z_esd(java.lang.Float fract_z_esd)
	{
		this.fract_z_esd = fract_z_esd;
	}

 	protected java.lang.String id_;


	/**
	 *  attribute id in category pdbx_phasing_MAD_set_site records the number of site
	 *  obtained from MAD phasing.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float occupancy;


	/**
	 *  attribute occupancy in category pdbx_phasing_MAD_set_site records the fraction
	 *  of the atom type presented at this site.
	 */
	public java.lang.Float getOccupancy() 
	{
		return occupancy;
	}
 
	public void setOccupancy(java.lang.Float occupancy)
	{
		this.occupancy = occupancy;
	}

 	protected java.lang.Float occupancy_esd;


	/**
	 *  attribute occupancy_esd in category pdbx_phasing_MAD_set_site records estimated
	 *  standard deviation of the fraction
	 *  of the atom type presented at this site.
	 */
	public java.lang.Float getOccupancy_esd() 
	{
		return occupancy_esd;
	}
 
	public void setOccupancy_esd(java.lang.Float occupancy_esd)
	{
		this.occupancy_esd = occupancy_esd;
	}

 	protected java.lang.Float occupancy_iso;


	/**
	 *  The relative real isotropic occupancy of the atom type
	 *  present at this heavy-atom site in a given atom site.
	 */
	public java.lang.Float getOccupancy_iso() 
	{
		return occupancy_iso;
	}
 
	public void setOccupancy_iso(java.lang.Float occupancy_iso)
	{
		this.occupancy_iso = occupancy_iso;
	}

 	protected java.lang.String set_id;


	/**
	 *  record the phasing set.
	 */
	public java.lang.String getSet_id() 
	{
		return set_id;
	}
 
	public void setSet_id(java.lang.String set_id)
	{
		this.set_id = set_id;
	}

 }
