package org.pdb.beans;

/**
 *  Data items in the PDBX_PHASING_DM category record details about
 *  density modification
 *  
 * <pre>
 *  Example 1 - density modification from resolve
 *  <PDBx:pdbx_phasing_dmCategory>
 *  <PDBx:pdbx_phasing_dm entry_id="ABC001">
 *  <PDBx:fom_acentric>0.85</PDBx:fom_acentric>
 *  <PDBx:fom_centric>0.79</PDBx:fom_centric>
 *  <PDBx:fom>0.85</PDBx:fom>
 *  <PDBx:reflns_acentric>11351</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>1135</PDBx:reflns_centric>
 *  <PDBx:reflns>12486</PDBx:reflns>
 *  </PDBx:pdbx_phasing_dm>
 *  </PDBx:pdbx_phasing_dmCategory>
 * </pre>
 */
public class Pdbx_phasing_dm 
{
		protected java.lang.Float delta_phi_final;


	/**
	 *  The value of  attribute delta_phi_final in category pdbx_phasing_dm identifies phase difference
	 *  after density modification
	 */
	public java.lang.Float getDelta_phi_final() 
	{
		return delta_phi_final;
	}
 
	public void setDelta_phi_final(java.lang.Float delta_phi_final)
	{
		this.delta_phi_final = delta_phi_final;
	}

 	protected java.lang.Float delta_phi_initial;


	/**
	 *  The value of  attribute delta_phi_initial in category pdbx_phasing_dm identifies phase difference
	 *  before density modification
	 */
	public java.lang.Float getDelta_phi_initial() 
	{
		return delta_phi_initial;
	}
 
	public void setDelta_phi_initial(java.lang.Float delta_phi_initial)
	{
		this.delta_phi_initial = delta_phi_initial;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_phasing_dm identifies the data block.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float fom;


	/**
	 *  The value of  attribute fom in category pdbx_phasing_dm identifies the figure of merit
	 *  for all the data
	 */
	public java.lang.Float getFom() 
	{
		return fom;
	}
 
	public void setFom(java.lang.Float fom)
	{
		this.fom = fom;
	}

 	protected java.lang.Float fom_acentric;


	/**
	 *  The value of  attribute fom_acentric in category pdbx_phasing_dm identifies the figure of merit
	 *  for acentric data
	 */
	public java.lang.Float getFom_acentric() 
	{
		return fom_acentric;
	}
 
	public void setFom_acentric(java.lang.Float fom_acentric)
	{
		this.fom_acentric = fom_acentric;
	}

 	protected java.lang.Float fom_centric;


	/**
	 *  The value of  attribute fom_centric in category pdbx_phasing_dm identifies the figure of merit
	 *  for acentric data
	 */
	public java.lang.Float getFom_centric() 
	{
		return fom_centric;
	}
 
	public void setFom_centric(java.lang.Float fom_centric)
	{
		this.fom_centric = fom_centric;
	}

 	protected java.lang.String mask_type;


	/**
	 *  The value of  attribute mask_type in category pdbx_phasing_dm identifies the type of mask used for
	 *  density modification
	 */
	public java.lang.String getMask_type() 
	{
		return mask_type;
	}
 
	public void setMask_type(java.lang.String mask_type)
	{
		this.mask_type = mask_type;
	}

 	protected java.lang.String method;


	/**
	 *  The value of  attribute method in category pdbx_phasing_dm identifies the method used for
	 *  density modification
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  The value of  attribute reflns in category pdbx_phasing_dm identifies the number
	 *  of centric and acentric reflections.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  The value of  attribute reflns_acentric in category pdbx_phasing_dm identifies the number
	 *  of acentric reflections.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  The value of  attribute reflns_centric in category pdbx_phasing_dm identifies the number
	 *  of centric reflections.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 }
