package org.pdb.beans;

/**
 *  Data items in the PDBX_POINT_SYMMETRY category record details about the
 *  point symmetry group associated with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_point_symmetryCategory>
 *  <PDBx:pdbx_point_symmetry entry_id="1ABC">
 *  <PDBx:Schoenflies_symbol>I</PDBx:Schoenflies_symbol>
 *  </PDBx:pdbx_point_symmetry>
 *  </PDBx:pdbx_point_symmetryCategory>
 * </pre>
 */
public class Pdbx_point_symmetry 
{
		protected java.lang.String H_M_notation;


	/**
	 *  The Hermann-Mauguin notation for this point symmetry group.
	 *  I -> 532
	 *  O -> 432
	 *  T -> 23
	 *  Cn -> n (e.g. C5 -> 5)
	 *  Dn -> n22 (n even)
	 *  Dn -> n2  (n odd)
	 */
	public java.lang.String getH_M_notation() 
	{
		return H_M_notation;
	}
 
	public void setH_M_notation(java.lang.String H_M_notation)
	{
		this.H_M_notation = H_M_notation;
	}

 	protected java.lang.String Schoenflies_symbol;


	/**
	 *  The Schoenflies point symmetry symbol.
	 */
	public java.lang.String getSchoenflies_symbol() 
	{
		return Schoenflies_symbol;
	}
 
	public void setSchoenflies_symbol(java.lang.String Schoenflies_symbol)
	{
		this.Schoenflies_symbol = Schoenflies_symbol;
	}

 	protected java.lang.Integer circular_symmetry;


	/**
	 *  Rotational n-fold C and D point symmetry.
	 */
	public java.lang.Integer getCircular_symmetry() 
	{
		return circular_symmetry;
	}
 
	public void setCircular_symmetry(java.lang.Integer circular_symmetry)
	{
		this.circular_symmetry = circular_symmetry;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 }
