package org.pdb.beans;

/**
 *  The PDBX_POLY_SEQ_SCHEME category provides residue level nomenclature
 *  mapping for polymer entities.
 *  
 * <pre>
 *  Example 1 - based on NDB entry DDFB25
 *  <PDBx:pdbx_poly_seq_schemeCategory>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="1" mon_id="C">
 *  <PDBx:pdb_mon_id>C</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>C</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="2" mon_id="G">
 *  <PDBx:pdb_mon_id>G</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>G</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="3" mon_id="T">
 *  <PDBx:pdb_mon_id>T</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>T</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="4" mon_id="+A">
 *  <PDBx:pdb_mon_id>+A</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>+A</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="5" mon_id="C">
 *  <PDBx:pdb_mon_id>C</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>C</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  <PDBx:pdbx_poly_seq_scheme asym_id="A" entity_id="1" seq_id="6" mon_id="G">
 *  <PDBx:pdb_mon_id>G</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>G</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_poly_seq_scheme>
 *  </PDBx:pdbx_poly_seq_schemeCategory>
 * </pre>
 */
public class Pdbx_poly_seq_scheme 
{
		protected java.lang.String asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 *  1
	 *  A
	 *  2B3
	 */
	public java.lang.String getAsym_id() 
	{
		return asym_id;
	}
 
	public void setAsym_id(java.lang.String asym_id)
	{
		this.asym_id = asym_id;
	}

 	protected java.lang.String auth_mon_id;


	/**
	 *  attribute auth_comp_id in category atom_site
	 */
	public java.lang.String getAuth_mon_id() 
	{
		return auth_mon_id;
	}
 
	public void setAuth_mon_id(java.lang.String auth_mon_id)
	{
		this.auth_mon_id = auth_mon_id;
	}

 	protected java.lang.String auth_seq_num;


	/**
	 *  attribute auth_seq_id in category atom_site
	 */
	public java.lang.String getAuth_seq_num() 
	{
		return auth_seq_num;
	}
 
	public void setAuth_seq_num(java.lang.String auth_seq_num)
	{
		this.auth_seq_num = auth_seq_num;
	}

 	protected java.lang.String entity_id;


	/**
	 *  Pointer to  attribute id in category entity.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String mon_id;


	/**
	 *  Pointer to  attribute mon_id in category entity_poly_seq.
	 */
	public java.lang.String getMon_id() 
	{
		return mon_id;
	}
 
	public void setMon_id(java.lang.String mon_id)
	{
		this.mon_id = mon_id;
	}

 	protected java.lang.Integer ndb_seq_num;


	/**
	 *  NDB residue number.
	 */
	public java.lang.Integer getNdb_seq_num() 
	{
		return ndb_seq_num;
	}
 
	public void setNdb_seq_num(java.lang.Integer ndb_seq_num)
	{
		this.ndb_seq_num = ndb_seq_num;
	}

 	protected java.lang.String pdb_ins_code;


	/**
	 *  PDB insertion code.
	 */
	public java.lang.String getPdb_ins_code() 
	{
		return pdb_ins_code;
	}
 
	public void setPdb_ins_code(java.lang.String pdb_ins_code)
	{
		this.pdb_ins_code = pdb_ins_code;
	}

 	protected java.lang.String pdb_mon_id;


	/**
	 *  PDB residue name.
	 */
	public java.lang.String getPdb_mon_id() 
	{
		return pdb_mon_id;
	}
 
	public void setPdb_mon_id(java.lang.String pdb_mon_id)
	{
		this.pdb_mon_id = pdb_mon_id;
	}

 	protected java.lang.String pdb_seq_num;


	/**
	 *  PDB residue number.
	 */
	public java.lang.String getPdb_seq_num() 
	{
		return pdb_seq_num;
	}
 
	public void setPdb_seq_num(java.lang.String pdb_seq_num)
	{
		this.pdb_seq_num = pdb_seq_num;
	}

 	protected java.lang.String pdb_strand_id;


	/**
	 *  PDB strand/chain id.
	 */
	public java.lang.String getPdb_strand_id() 
	{
		return pdb_strand_id;
	}
 
	public void setPdb_strand_id(java.lang.String pdb_strand_id)
	{
		this.pdb_strand_id = pdb_strand_id;
	}

 	protected java.lang.Integer seq_id;


	/**
	 *  Pointer to  attribute num in category entity_poly_seq
	 */
	public java.lang.Integer getSeq_id() 
	{
		return seq_id;
	}
 
	public void setSeq_id(java.lang.Integer seq_id)
	{
		this.seq_id = seq_id;
	}

 }
