package org.pdb.beans;

/**
 *  This category provides a placeholder for pre-release
 *  sequence information.  After release this category
 *  should be discarded.
 *  <PDBx:pdbx_prerelease_seqCategory>
 *  <PDBx:pdbx_prerelease_seq entity_id="1">
 *  <PDBx:seq_one_letter_code>GKHNGPEHWHKDFPIAKGERQSPVDIDTHTAKYDPSLKPLSVSYDQATSLRILNNGAAFNVEFD</PDBx:seq_one_letter_code>
 *  </PDBx:pdbx_prerelease_seq>
 *  <PDBx:pdbx_prerelease_seq entity_id="2">
 *  <PDBx:seq_one_letter_code>HKDFPIAKGERQSPVDIDTHTAKYDPSLKPLSVSYDQATSLRILNN</PDBx:seq_one_letter_code>
 *  </PDBx:pdbx_prerelease_seq>
 *  </PDBx:pdbx_prerelease_seqCategory>
 */
public class Pdbx_prerelease_seq 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String seq_one_letter_code;


	/**
	 *  Chemical sequence expressed as string of one-letter
	 *  amino acid codes.
	 *  
	 *  A  for alanine or adenine
	 *  B  for ambiguous asparagine/aspartic-acid
	 *  R  for arginine
	 *  N  for asparagine
	 *  D  for aspartic-acid
	 *  C  for cysteine or cystine or cytosine
	 *  Q  for glutamine
	 *  E  for glutamic-acid
	 *  Z  for ambiguous glutamine/glutamic acid
	 *  G  for glycine or guanine
	 *  H  for histidine
	 *  I  for isoleucine
	 *  L  for leucine
	 *  K  for lysine
	 *  M  for methionine
	 *  F  for phenylalanine
	 *  P  for proline
	 *  S  for serine
	 *  T  for threonine or thymine
	 *  W  for tryptophan
	 *  Y  for tyrosine
	 *  V  for valine
	 *  U  for uracil
	 *  
	 *  MSHHWGYGKHNGPEHWHKDFPIAKGERQSPVDIDTHTAKYDPSLKPLSVSYDQATSLRILNNGAAFNVEFD
	 */
	public java.lang.String getSeq_one_letter_code() 
	{
		return seq_one_letter_code;
	}
 
	public void setSeq_one_letter_code(java.lang.String seq_one_letter_code)
	{
		this.seq_one_letter_code = org.pdb.ormapping.util.Field.removeCrLf(seq_one_letter_code);
	}

 }
