package org.pdb.beans;

/**
 *  Data items in the PDBX_SEQUENCE_RANGE category identify the
 *  beginning and ending points of polypeptide sequence segments.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_sequence_rangeCategory>
 *  <PDBx:pdbx_sequence_range seq_range_id="s1" beg_label_alt_id="" beg_label_asym_id="A" beg_label_comp_id="PRO" beg_label_seq_id="1" end_label_alt_id="" end_label_asym_id="A" end_label_comp_id="GLY" end_label_seq_id="29"></PDBx:pdbx_sequence_range>
 *  <PDBx:pdbx_sequence_range seq_range_id="s2" beg_label_alt_id="" beg_label_asym_id="D" beg_label_comp_id="PRO" beg_label_seq_id="91" end_label_alt_id="" end_label_asym_id="D" end_label_comp_id="GLY" end_label_seq_id="119"></PDBx:pdbx_sequence_range>
 *  </PDBx:pdbx_sequence_rangeCategory>
 * </pre>
 */
public class Pdbx_sequence_range 
{
		protected java.lang.String beg_auth_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_asym_id() 
	{
		return beg_auth_asym_id;
	}
 
	public void setBeg_auth_asym_id(java.lang.String beg_auth_asym_id)
	{
		this.beg_auth_asym_id = beg_auth_asym_id;
	}

 	protected java.lang.String beg_auth_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_comp_id() 
	{
		return beg_auth_comp_id;
	}
 
	public void setBeg_auth_comp_id(java.lang.String beg_auth_comp_id)
	{
		this.beg_auth_comp_id = beg_auth_comp_id;
	}

 	protected java.lang.String beg_auth_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_seq_id() 
	{
		return beg_auth_seq_id;
	}
 
	public void setBeg_auth_seq_id(java.lang.String beg_auth_seq_id)
	{
		this.beg_auth_seq_id = beg_auth_seq_id;
	}

 	protected java.lang.String beg_label_alt_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getBeg_label_alt_id() 
	{
		return beg_label_alt_id;
	}
 
	public void setBeg_label_alt_id(java.lang.String beg_label_alt_id)
	{
		this.beg_label_alt_id = beg_label_alt_id;
	}

 	protected java.lang.String beg_label_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_asym_id() 
	{
		return beg_label_asym_id;
	}
 
	public void setBeg_label_asym_id(java.lang.String beg_label_asym_id)
	{
		this.beg_label_asym_id = beg_label_asym_id;
	}

 	protected java.lang.String beg_label_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_comp_id() 
	{
		return beg_label_comp_id;
	}
 
	public void setBeg_label_comp_id(java.lang.String beg_label_comp_id)
	{
		this.beg_label_comp_id = beg_label_comp_id;
	}

 	protected java.lang.Integer beg_label_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range begins.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getBeg_label_seq_id() 
	{
		return beg_label_seq_id;
	}
 
	public void setBeg_label_seq_id(java.lang.Integer beg_label_seq_id)
	{
		this.beg_label_seq_id = beg_label_seq_id;
	}

 	protected java.lang.String end_auth_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_asym_id() 
	{
		return end_auth_asym_id;
	}
 
	public void setEnd_auth_asym_id(java.lang.String end_auth_asym_id)
	{
		this.end_auth_asym_id = end_auth_asym_id;
	}

 	protected java.lang.String end_auth_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_comp_id() 
	{
		return end_auth_comp_id;
	}
 
	public void setEnd_auth_comp_id(java.lang.String end_auth_comp_id)
	{
		this.end_auth_comp_id = end_auth_comp_id;
	}

 	protected java.lang.String end_auth_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_seq_id() 
	{
		return end_auth_seq_id;
	}
 
	public void setEnd_auth_seq_id(java.lang.String end_auth_seq_id)
	{
		this.end_auth_seq_id = end_auth_seq_id;
	}

 	protected java.lang.String end_label_alt_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getEnd_label_alt_id() 
	{
		return end_label_alt_id;
	}
 
	public void setEnd_label_alt_id(java.lang.String end_label_alt_id)
	{
		this.end_label_alt_id = end_label_alt_id;
	}

 	protected java.lang.String end_label_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_asym_id() 
	{
		return end_label_asym_id;
	}
 
	public void setEnd_label_asym_id(java.lang.String end_label_asym_id)
	{
		this.end_label_asym_id = end_label_asym_id;
	}

 	protected java.lang.String end_label_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_comp_id() 
	{
		return end_label_comp_id;
	}
 
	public void setEnd_label_comp_id(java.lang.String end_label_comp_id)
	{
		this.end_label_comp_id = end_label_comp_id;
	}

 	protected java.lang.Integer end_label_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the sequence range ends.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getEnd_label_seq_id() 
	{
		return end_label_seq_id;
	}
 
	public void setEnd_label_seq_id(java.lang.Integer end_label_seq_id)
	{
		this.end_label_seq_id = end_label_seq_id;
	}

 	protected java.lang.String seq_range_id;


	/**
	 *  This data item is an identifier for a sequence range.
	 */
	public java.lang.String getSeq_range_id() 
	{
		return seq_range_id;
	}
 
	public void setSeq_range_id(java.lang.String seq_range_id)
	{
		this.seq_range_id = seq_range_id;
	}

 }
