package org.pdb.beans;

/**
 *  Data items in the PDBX_SOLN_SCATTER_MODEL category record details about the
 *  homology model fitting to the solution scatter data.
 */
public class Pdbx_soln_scatter_model 
{
		protected java.lang.String conformer_selection_criteria;


	/**
	 *  A description of the conformer selection criteria
	 *  used.
	 *  The modelled scattering curves were assessed by calculation of the
	 *  RG, RSX-1 and RXS-2 values in the same Q ranges
	 *  used in the experimental Guinier fits. models were
	 *  then ranked using a goodness-of-fit R-factor
	 *  defined by analogy with protein crystallography
	 *  and based on the experimental curves in the Q range
	 *  extending to 1.4 nm-1.
	 */
	public java.lang.String getConformer_selection_criteria() 
	{
		return conformer_selection_criteria;
	}
 
	public void setConformer_selection_criteria(java.lang.String conformer_selection_criteria)
	{
		this.conformer_selection_criteria = conformer_selection_criteria;
	}

 	protected java.lang.String details;


	/**
	 *  A description of any additional details concerning the experiment.
	 *  Homology models were built for
	 *  the 17 SCR domains and energy minimisations were
	 *  performed to improve the connectivity in the fh model.
	 *  triantennary complex-type carbohydrate structures
	 *  (MAN3GLCNAC6GAL3FUC3NEUNAC1) were added to each of the
	 *  N-linked glycosylation sites. a library of linker peptide
	 *  conformations was used in domain modelling constrained
	 *  by the solution scattering fits. modelling with the
	 *  scattering data was also carried out by rotational
	 *  search methods. the x-ray and neutron scattering curve
	 *  I(Q) was calculated assuming a uniform scattering density
	 *  for the spheres using the debye equation as adapted to
	 *  spheres. x-ray curves were calculated from the hydrated
	 *  sphere models without corrections for wavelength spread or
	 *  beam divergence, while these corrections were applied for
	 *  the neutron curves but now using unhydrated models.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_fitting_list;


	/**
	 *  A list of the entries used to fit the model
	 *  to the scattering data
	 *  PDB CODE 1HFI, 1HCC, 1HFH, 1VCC
	 */
	public java.lang.String getEntry_fitting_list() 
	{
		return entry_fitting_list;
	}
 
	public void setEntry_fitting_list(java.lang.String entry_fitting_list)
	{
		this.entry_fitting_list = entry_fitting_list;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_soln_scatter_model must
	 *  uniquely identify the sample in the category PDBX_SOLN_SCATTER_MODEL
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the methods used in the modelling
	 *  Constrained scattering fitting of homology models
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer num_conformers_calculated;


	/**
	 *  The number of model conformers calculated.
	 */
	public java.lang.Integer getNum_conformers_calculated() 
	{
		return num_conformers_calculated;
	}
 
	public void setNum_conformers_calculated(java.lang.Integer num_conformers_calculated)
	{
		this.num_conformers_calculated = num_conformers_calculated;
	}

 	protected java.lang.Integer num_conformers_submitted;


	/**
	 *  The number of model conformers submitted in the entry
	 */
	public java.lang.Integer getNum_conformers_submitted() 
	{
		return num_conformers_submitted;
	}
 
	public void setNum_conformers_submitted(java.lang.Integer num_conformers_submitted)
	{
		this.num_conformers_submitted = num_conformers_submitted;
	}

 	protected java.lang.String scatter_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_soln_scatter in the PDBX_SOLN_SCATTER category.
	 */
	public java.lang.String getScatter_id() 
	{
		return scatter_id;
	}
 
	public void setScatter_id(java.lang.String scatter_id)
	{
		this.scatter_id = scatter_id;
	}

 	protected java.lang.String software_author_list;


	/**
	 *  A list of the software authors
	 *  MSI
	 */
	public java.lang.String getSoftware_author_list() 
	{
		return software_author_list;
	}
 
	public void setSoftware_author_list(java.lang.String software_author_list)
	{
		this.software_author_list = software_author_list;
	}

 	protected java.lang.String software_list;


	/**
	 *  A list of the software used in the modeeling
	 *  INSIGHT II, HOMOLOGY, DISCOVERY, BIOPOLYMER, DELPHI
	 */
	public java.lang.String getSoftware_list() 
	{
		return software_list;
	}
 
	public void setSoftware_list(java.lang.String software_list)
	{
		this.software_list = software_list;
	}

 }
