package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_ASSEMBLY category record details about
 *  the structural elements that form macromolecular assemblies.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_assemblyCategory>
 *  <PDBx:pdbx_struct_assembly id="1">
 *  <PDBx:details> The icosahedral virus particle.</PDBx:details>
 *  </PDBx:pdbx_struct_assembly>
 *  </PDBx:pdbx_struct_assemblyCategory>
 * </pre>
 */
public class Pdbx_struct_assembly 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the macromolecular assembly.
	 *  The icosahedral virus particle.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_struct_assembly must uniquely identify a record in
	 *  the PDBX_STRUCT_ASSEMBLY list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
