package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_ASYM_GEN category record details about
 *  the generation of the crystallographic asymmetric unit. The
 *  PDBX_STRUCT_ASYM_GEN data items provide the specifications of the
 *  components that constitute the asymmetric unit in terms of cartesian
 *  transformations of deposited coordinates.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_asym_genCategory>
 *  <PDBx:pdbx_struct_asym_gen entity_inst_id="A" oper_expression="1">
 *  <PDBx:asym_id>A</PDBx:asym_id>
 *  </PDBx:pdbx_struct_asym_gen>
 *  <PDBx:pdbx_struct_asym_gen entity_inst_id="B" oper_expression="1">
 *  <PDBx:asym_id>B</PDBx:asym_id>
 *  </PDBx:pdbx_struct_asym_gen>
 *  </PDBx:pdbx_struct_asym_genCategory>
 * </pre>
 */
public class Pdbx_struct_asym_gen 
{
		protected java.lang.String asym_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_asym in the
	 *  STRUCT_ASYM category.
	 */
	public java.lang.String getAsym_id() 
	{
		return asym_id;
	}
 
	public void setAsym_id(java.lang.String asym_id)
	{
		this.asym_id = asym_id;
	}

 	protected java.lang.String entity_inst_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_struct_entity_inst in
	 *  the PDBX_STRUCT_ENTITY_INST category.
	 */
	public java.lang.String getEntity_inst_id() 
	{
		return entity_inst_id;
	}
 
	public void setEntity_inst_id(java.lang.String entity_inst_id)
	{
		this.entity_inst_id = entity_inst_id;
	}

 	protected java.lang.String oper_expression;


	/**
	 *  Identifies the operation from category PDBX_STRUCT_OPER_LIST.
	 *  
	 *  (1)
	 *  (1-2)
	 */
	public java.lang.String getOper_expression() 
	{
		return oper_expression;
	}
 
	public void setOper_expression(java.lang.String oper_expression)
	{
		this.oper_expression = oper_expression;
	}

 }
