package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_CHEM_COMP_DIAGNOSTICS category provide
 *  annotation of diagnostics observed in chemical components.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_chem_comp_diagnosticsCategory>
 *  <PDBx:pdbx_struct_chem_comp_diagnostics ordinal="1">
 *  <PDBx:auth_comp_id>ATP</PDBx:auth_comp_id>
 *  <PDBx:auth_seq_id>10</PDBx:auth_seq_id>
 *  <PDBx:seq_num>10</PDBx:seq_num>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  <PDBx:asym_id>A</PDBx:asym_id>
 *  <PDBx:type>MISSING_ATOM</PDBx:type>
 *  </PDBx:pdbx_struct_chem_comp_diagnostics>
 *  </PDBx:pdbx_struct_chem_comp_diagnosticsCategory>
 * </pre>
 */
public class Pdbx_struct_chem_comp_diagnostics 
{
		protected java.lang.String asym_id;


	/**
	 *  Instance identifier for the polymer molecule.
	 *  A
	 *  B
	 */
	public java.lang.String getAsym_id() 
	{
		return asym_id;
	}
 
	public void setAsym_id(java.lang.String asym_id)
	{
		this.asym_id = asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  PDB component ID
	 *  NAG
	 *  ATP
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  PDB  position in the sequence.
	 *  1
	 *  2
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  An ordinal index for this category
	 *  1
	 *  2
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 	protected java.lang.String pdb_ins_code;


	/**
	 *  Insertion code of the monomer or ligand .
	 *  A
	 *  B
	 */
	public java.lang.String getPdb_ins_code() 
	{
		return pdb_ins_code;
	}
 
	public void setPdb_ins_code(java.lang.String pdb_ins_code)
	{
		this.pdb_ins_code = pdb_ins_code;
	}

 	protected java.lang.String pdb_strand_id;


	/**
	 *  PDB strand/chain id.
	 *  A
	 *  B
	 */
	public java.lang.String getPdb_strand_id() 
	{
		return pdb_strand_id;
	}
 
	public void setPdb_strand_id(java.lang.String pdb_strand_id)
	{
		this.pdb_strand_id = pdb_strand_id;
	}

 	protected java.lang.String seq_num;


	/**
	 *  Position in the sequence.
	 *  1
	 *  2
	 */
	public java.lang.String getSeq_num() 
	{
		return seq_num;
	}
 
	public void setSeq_num(java.lang.String seq_num)
	{
		this.seq_num = seq_num;
	}

 	protected java.lang.String type;


	/**
	 *  A classification of the problem with the chemical component.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
