package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_ENTITY_INST category record details about the
 *  structural elements in the deposited entry.  The entity instance is a method
 *  neutral identifier for the observed molecular entities in the deposited coordinate
 *  set.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_entity_instCategory>
 *  <PDBx:pdbx_struct_entity_inst id="A">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:pdbx_struct_entity_inst>
 *  <PDBx:pdbx_struct_entity_inst id="B">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:pdbx_struct_entity_inst>
 *  </PDBx:pdbx_struct_entity_instCategory>
 * </pre>
 */
public class Pdbx_struct_entity_inst 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of this portion of the contents
	 *  of the deposited unit.
	 *  The drug binds to this enzyme in two roughly
	 *  twofold symmetric modes. Hence this
	 *  biological unit (3) is roughly twofold
	 *  symmetric to biological unit (2). Disorder in
	 *  the protein chain indicated with alternative
	 *  ID 2 should be used with this biological unit.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_struct_entity_inst must uniquely identify a record in
	 *  the PDBX_STRUCT_ENTITY_INST list.
	 *  
	 *  The entity instance is a method neutral identifier for the observed
	 *  molecular entities in the deposited coordinate set.
	 *  1
	 *  A
	 *  2B3
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
