package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_OPER_LIST category describe
 *  Cartesian rotation and translation operations required to
 *  generate or transform the coordinates deposited with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_oper_listCategory>
 *  <PDBx:pdbx_struct_oper_list id="2">
 *  <PDBx:matrix11>0.247</PDBx:matrix11>
 *  <PDBx:matrix12>0.935</PDBx:matrix12>
 *  <PDBx:matrix13>0.256</PDBx:matrix13>
 *  <PDBx:matrix21>0.929</PDBx:matrix21>
 *  <PDBx:matrix22>0.153</PDBx:matrix22>
 *  <PDBx:matrix23>0.337</PDBx:matrix23>
 *  <PDBx:matrix31>0.276</PDBx:matrix31>
 *  <PDBx:matrix32>0.321</PDBx:matrix32>
 *  <PDBx:matrix33>-0.906</PDBx:matrix33>
 *  <PDBx:vector1>-8.253</PDBx:vector1>
 *  <PDBx:vector2>-11.743</PDBx:vector2>
 *  <PDBx:vector3>-1.782</PDBx:vector3>
 *  <PDBx:type>point symmetry operation</PDBx:type>
 *  </PDBx:pdbx_struct_oper_list>
 *  </PDBx:pdbx_struct_oper_listCategory>
 * </pre>
 */
public class Pdbx_struct_oper_list 
{
		protected java.lang.String id_;


	/**
	 *  This identifier code must uniquely identify a
	 *  record in the PDBX_STRUCT_OPER_LIST list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float matrix11;


	/**
	 *  The [1][1] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix11() 
	{
		return matrix11;
	}
 
	public void setMatrix11(java.lang.Float matrix11)
	{
		this.matrix11 = matrix11;
	}

 	protected java.lang.Float matrix12;


	/**
	 *  The [1][2] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix12() 
	{
		return matrix12;
	}
 
	public void setMatrix12(java.lang.Float matrix12)
	{
		this.matrix12 = matrix12;
	}

 	protected java.lang.Float matrix13;


	/**
	 *  The [1][3] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix13() 
	{
		return matrix13;
	}
 
	public void setMatrix13(java.lang.Float matrix13)
	{
		this.matrix13 = matrix13;
	}

 	protected java.lang.Float matrix21;


	/**
	 *  The [2][1] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix21() 
	{
		return matrix21;
	}
 
	public void setMatrix21(java.lang.Float matrix21)
	{
		this.matrix21 = matrix21;
	}

 	protected java.lang.Float matrix22;


	/**
	 *  The [2][2] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix22() 
	{
		return matrix22;
	}
 
	public void setMatrix22(java.lang.Float matrix22)
	{
		this.matrix22 = matrix22;
	}

 	protected java.lang.Float matrix23;


	/**
	 *  The [2][3] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix23() 
	{
		return matrix23;
	}
 
	public void setMatrix23(java.lang.Float matrix23)
	{
		this.matrix23 = matrix23;
	}

 	protected java.lang.Float matrix31;


	/**
	 *  The [3][1] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix31() 
	{
		return matrix31;
	}
 
	public void setMatrix31(java.lang.Float matrix31)
	{
		this.matrix31 = matrix31;
	}

 	protected java.lang.Float matrix32;


	/**
	 *  The [3][2] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix32() 
	{
		return matrix32;
	}
 
	public void setMatrix32(java.lang.Float matrix32)
	{
		this.matrix32 = matrix32;
	}

 	protected java.lang.Float matrix33;


	/**
	 *  The [3][3] element of the 3x3 matrix component of the
	 *  transformation operation.
	 */
	public java.lang.Float getMatrix33() 
	{
		return matrix33;
	}
 
	public void setMatrix33(java.lang.Float matrix33)
	{
		this.matrix33 = matrix33;
	}

 	protected java.lang.String name;


	/**
	 *  A descriptive name for the transformation operation.
	 *  1_555
	 *  two-fold rotation
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String type;


	/**
	 *  A code to indicate the type of operator.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.Float vector1;


	/**
	 *  The [1] element of the three-element vector component of the
	 *  transformation operation.
	 */
	public java.lang.Float getVector1() 
	{
		return vector1;
	}
 
	public void setVector1(java.lang.Float vector1)
	{
		this.vector1 = vector1;
	}

 	protected java.lang.Float vector2;


	/**
	 *  The [2] element of the three-element vector component of the
	 *  transformation operation.
	 */
	public java.lang.Float getVector2() 
	{
		return vector2;
	}
 
	public void setVector2(java.lang.Float vector2)
	{
		this.vector2 = vector2;
	}

 	protected java.lang.Float vector3;


	/**
	 *  The [3] element of the three-element vector component of the
	 *  transformation operation.
	 */
	public java.lang.Float getVector3() 
	{
		return vector3;
	}
 
	public void setVector3(java.lang.Float vector3)
	{
		this.vector3 = vector3;
	}

 }
