package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_REF_SEQ_FEATURE_PROP category provide a
 *  mechanism for identifying and annotating properties of sequence features.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_ref_seq_feature_propCategory>
 *  <PDBx:pdbx_struct_ref_seq_feature_prop feature_id="1" property_id="1">
 *  <PDBx:beg_db_mon_id>GLU</PDBx:beg_db_mon_id>
 *  <PDBx:end_db_mon_id>PHE</PDBx:end_db_mon_id>
 *  <PDBx:beg_db_seq_id>100</PDBx:beg_db_seq_id>
 *  <PDBx:end_db_seq_id>104</PDBx:end_db_seq_id>
 *  <PDBx:type>VARIABLE_SPLICING</PDBx:type>
 *  <PDBx:value>VSP_003456</PDBx:value>
 *  <PDBx:details>  Special splice at ... </PDBx:details>
 *  </PDBx:pdbx_struct_ref_seq_feature_prop>
 *  </PDBx:pdbx_struct_ref_seq_feature_propCategory>
 * </pre>
 */
public class Pdbx_struct_ref_seq_feature_prop 
{
		protected java.lang.String beg_db_mon_id;


	/**
	 *  The begining monomer type found at the starting  position
	 *  in the referenced database entry.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getBeg_db_mon_id() 
	{
		return beg_db_mon_id;
	}
 
	public void setBeg_db_mon_id(java.lang.String beg_db_mon_id)
	{
		this.beg_db_mon_id = beg_db_mon_id;
	}

 	protected java.lang.Integer beg_db_seq_id;


	/**
	 *  The begining monomer sequence  position
	 *  in the referenced database entry.
	 */
	public java.lang.Integer getBeg_db_seq_id() 
	{
		return beg_db_seq_id;
	}
 
	public void setBeg_db_seq_id(java.lang.Integer beg_db_seq_id)
	{
		this.beg_db_seq_id = beg_db_seq_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the property value pair.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String end_db_mon_id;


	/**
	 *  The terminal monomer type found at the ending position
	 *  in the referenced database entry.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getEnd_db_mon_id() 
	{
		return end_db_mon_id;
	}
 
	public void setEnd_db_mon_id(java.lang.String end_db_mon_id)
	{
		this.end_db_mon_id = end_db_mon_id;
	}

 	protected java.lang.Integer end_db_seq_id;


	/**
	 *  The terminal monomer sequence position
	 *  in the referenced database entry.
	 */
	public java.lang.Integer getEnd_db_seq_id() 
	{
		return end_db_seq_id;
	}
 
	public void setEnd_db_seq_id(java.lang.Integer end_db_seq_id)
	{
		this.end_db_seq_id = end_db_seq_id;
	}

 	protected java.lang.Integer feature_id;


	/**
	 *  This data item is a pointer to  attribute feature_id in category pdbx_struct_ref_seq_feature in
	 *  the STRUCT_REF_SEQ_FEATURE  category.
	 */
	public java.lang.Integer getFeature_id() 
	{
		return feature_id;
	}
 
	public void setFeature_id(java.lang.Integer feature_id)
	{
		this.feature_id = feature_id;
	}

 	protected java.lang.Integer property_id;


	/**
	 *  This uniquely identifies the a property of a sequence feature in
	 *  the STRUCT_REF_SEQ_FEATURE_PROPx  category.
	 */
	public java.lang.Integer getProperty_id() 
	{
		return property_id;
	}
 
	public void setProperty_id(java.lang.Integer property_id)
	{
		this.property_id = property_id;
	}

 	protected java.lang.String type;


	/**
	 *  Property type.
	 *  deletion', 'expression tag', 'variant', 'other
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.String value;


	/**
	 *  Property value.
	 */
	public java.lang.String getValue() 
	{
		return value;
	}
 
	public void setValue(java.lang.String value)
	{
		this.value = value;
	}

 }
