package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_SHEET_HBOND category record details
 *  about the hydrogen bonding between residue ranges in a beta sheet.
 *  This category is provided for cases where only a single hydrogen
 *  bond is used to register the two residue ranges.   Category
 *  STRUCT_SHEET_HBOND should be used when the initial and terminal
 *  hydrogen bonds for strand pair are known.
 */
public class Pdbx_struct_sheet_hbond 
{
		protected java.lang.String range_1_PDB_ins_code;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_PDB_ins_code() 
	{
		return range_1_PDB_ins_code;
	}
 
	public void setRange_1_PDB_ins_code(java.lang.String range_1_PDB_ins_code)
	{
		this.range_1_PDB_ins_code = range_1_PDB_ins_code;
	}

 	protected java.lang.String range_1_auth_asym_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_auth_asym_id() 
	{
		return range_1_auth_asym_id;
	}
 
	public void setRange_1_auth_asym_id(java.lang.String range_1_auth_asym_id)
	{
		this.range_1_auth_asym_id = range_1_auth_asym_id;
	}

 	protected java.lang.String range_1_auth_atom_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_auth_atom_id() 
	{
		return range_1_auth_atom_id;
	}
 
	public void setRange_1_auth_atom_id(java.lang.String range_1_auth_atom_id)
	{
		this.range_1_auth_atom_id = range_1_auth_atom_id;
	}

 	protected java.lang.String range_1_auth_comp_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_auth_comp_id() 
	{
		return range_1_auth_comp_id;
	}
 
	public void setRange_1_auth_comp_id(java.lang.String range_1_auth_comp_id)
	{
		this.range_1_auth_comp_id = range_1_auth_comp_id;
	}

 	protected java.lang.String range_1_auth_seq_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_auth_seq_id() 
	{
		return range_1_auth_seq_id;
	}
 
	public void setRange_1_auth_seq_id(java.lang.String range_1_auth_seq_id)
	{
		this.range_1_auth_seq_id = range_1_auth_seq_id;
	}

 	protected java.lang.String range_1_label_asym_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_label_asym_id() 
	{
		return range_1_label_asym_id;
	}
 
	public void setRange_1_label_asym_id(java.lang.String range_1_label_asym_id)
	{
		this.range_1_label_asym_id = range_1_label_asym_id;
	}

 	protected java.lang.String range_1_label_atom_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_label_atom_id() 
	{
		return range_1_label_atom_id;
	}
 
	public void setRange_1_label_atom_id(java.lang.String range_1_label_atom_id)
	{
		this.range_1_label_atom_id = range_1_label_atom_id;
	}

 	protected java.lang.String range_1_label_comp_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_label_comp_id() 
	{
		return range_1_label_comp_id;
	}
 
	public void setRange_1_label_comp_id(java.lang.String range_1_label_comp_id)
	{
		this.range_1_label_comp_id = range_1_label_comp_id;
	}

 	protected java.lang.Integer range_1_label_seq_id;


	/**
	 *  A component of the residue identifier for the first partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_1_label_seq_id() 
	{
		return range_1_label_seq_id;
	}
 
	public void setRange_1_label_seq_id(java.lang.Integer range_1_label_seq_id)
	{
		this.range_1_label_seq_id = range_1_label_seq_id;
	}

 	protected java.lang.String range_2_PDB_ins_code;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_PDB_ins_code() 
	{
		return range_2_PDB_ins_code;
	}
 
	public void setRange_2_PDB_ins_code(java.lang.String range_2_PDB_ins_code)
	{
		this.range_2_PDB_ins_code = range_2_PDB_ins_code;
	}

 	protected java.lang.String range_2_auth_asym_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_auth_asym_id() 
	{
		return range_2_auth_asym_id;
	}
 
	public void setRange_2_auth_asym_id(java.lang.String range_2_auth_asym_id)
	{
		this.range_2_auth_asym_id = range_2_auth_asym_id;
	}

 	protected java.lang.String range_2_auth_atom_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_auth_atom_id() 
	{
		return range_2_auth_atom_id;
	}
 
	public void setRange_2_auth_atom_id(java.lang.String range_2_auth_atom_id)
	{
		this.range_2_auth_atom_id = range_2_auth_atom_id;
	}

 	protected java.lang.String range_2_auth_comp_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_auth_comp_id() 
	{
		return range_2_auth_comp_id;
	}
 
	public void setRange_2_auth_comp_id(java.lang.String range_2_auth_comp_id)
	{
		this.range_2_auth_comp_id = range_2_auth_comp_id;
	}

 	protected java.lang.String range_2_auth_seq_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_auth_seq_id() 
	{
		return range_2_auth_seq_id;
	}
 
	public void setRange_2_auth_seq_id(java.lang.String range_2_auth_seq_id)
	{
		this.range_2_auth_seq_id = range_2_auth_seq_id;
	}

 	protected java.lang.String range_2_label_asym_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_label_asym_id() 
	{
		return range_2_label_asym_id;
	}
 
	public void setRange_2_label_asym_id(java.lang.String range_2_label_asym_id)
	{
		this.range_2_label_asym_id = range_2_label_asym_id;
	}

 	protected java.lang.String range_2_label_atom_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_label_atom_id() 
	{
		return range_2_label_atom_id;
	}
 
	public void setRange_2_label_atom_id(java.lang.String range_2_label_atom_id)
	{
		this.range_2_label_atom_id = range_2_label_atom_id;
	}

 	protected java.lang.String range_2_label_comp_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_label_comp_id() 
	{
		return range_2_label_comp_id;
	}
 
	public void setRange_2_label_comp_id(java.lang.String range_2_label_comp_id)
	{
		this.range_2_label_comp_id = range_2_label_comp_id;
	}

 	protected java.lang.Integer range_2_label_seq_id;


	/**
	 *  A component of the residue identifier for the second partner of the
	 *  registration hydrogen bond between two residue ranges in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_2_label_seq_id() 
	{
		return range_2_label_seq_id;
	}
 
	public void setRange_2_label_seq_id(java.lang.Integer range_2_label_seq_id)
	{
		this.range_2_label_seq_id = range_2_label_seq_id;
	}

 	protected java.lang.String range_id_1;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_1() 
	{
		return range_id_1;
	}
 
	public void setRange_id_1(java.lang.String range_id_1)
	{
		this.range_id_1 = range_id_1;
	}

 	protected java.lang.String range_id_2;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_2() 
	{
		return range_id_2;
	}
 
	public void setRange_id_2(java.lang.String range_id_2)
	{
		this.range_id_2 = range_id_2;
	}

 	protected java.lang.String sheet_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet in the
	 *  STRUCT_SHEET category.
	 */
	public java.lang.String getSheet_id() 
	{
		return sheet_id;
	}
 
	public void setSheet_id(java.lang.String sheet_id)
	{
		this.sheet_id = sheet_id;
	}

 }
