package org.pdb.beans;

/**
 *  Data items in the PDBX_VERSION category record details about the
 *  current internal version of this entry.
 *  
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_versionCategory>
 *  <PDBx:pdbx_version entry_id="1ABC" major_version="3" minor_version="12">
 *  <PDBx:revision_date>2006-12-08</PDBx:revision_date>
 *  <PDBx:details>  Update version information. </PDBx:details>
 *  </PDBx:pdbx_version>
 *  </PDBx:pdbx_versionCategory>
 * </pre>
 */
public class Pdbx_version 
{
		protected java.lang.String details;


	/**
	 *  A text description of any special details of the current version.
	 *  Includes new 3dem experimental data items
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer major_version;


	/**
	 *  Major version number for this datablock:
	 *  
	 *  3 - represents remediated data -
	 *  2 - current production data -
	 *  3
	 */
	public java.lang.Integer getMajor_version() 
	{
		return major_version;
	}
 
	public void setMajor_version(java.lang.Integer major_version)
	{
		this.major_version = major_version;
	}

 	protected java.lang.Integer minor_version;


	/**
	 *  Minor version number for this datablock:
	 *  
	 *  An integer value which is incremented for each
	 *  datablock revision.
	 *  15
	 */
	public java.lang.Integer getMinor_version() 
	{
		return minor_version;
	}
 
	public void setMinor_version(java.lang.Integer minor_version)
	{
		this.minor_version = minor_version;
	}

 	protected java.util.Date revision_date;


	/**
	 *  A date for the current version or revision. The date format is
	 *  yyyy-mm-dd.
	 *  2006-07-12
	 */
	public java.util.Date getRevision_date() 
	{
		return revision_date;
	}
 
	public void setRevision_date(java.util.Date revision_date)
	{
		this.revision_date = revision_date;
	}

 }
