package org.pdb.beans;

/**
 *  Data items in the PHASING_MAD_CLUST category record details
 *  about a cluster of experiments that contributed to the
 *  generation of a set of phases.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_clustCategory>
 *  <PDBx:phasing_MAD_clust id="4 wavelength" expt_id="1">
 *  <PDBx:number_set>4</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  <PDBx:phasing_MAD_clust id="5 wavelength" expt_id="1">
 *  <PDBx:number_set>5</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  <PDBx:phasing_MAD_clust id="5 wavelength" expt_id="2">
 *  <PDBx:number_set>5</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  </PDBx:phasing_MAD_clustCategory>
 * </pre>
 */
public class Phasing_MAD_clust 
{
		protected java.lang.String expt_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MAD_expt in the
	 *  PHASING_MAD_EXPT category.
	 */
	public java.lang.String getExpt_id() 
	{
		return expt_id;
	}
 
	public void setExpt_id(java.lang.String expt_id)
	{
		this.expt_id = expt_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category phasing_MAD_clust must, together with
	 *  attribute expt_id in category phasing_MAD_clust uniquely identify a record in the
	 *  PHASING_MAD_CLUST list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer number_set;


	/**
	 *  The number of data sets in this cluster of data sets.
	 */
	public java.lang.Integer getNumber_set() 
	{
		return number_set;
	}
 
	public void setNumber_set(java.lang.Integer number_set)
	{
		this.number_set = number_set;
	}

 }
