package org.pdb.beans;

/**
 *  Data items in the PHASING_MAD_EXPT category record details about
 *  a MAD phasing experiment, such as the number of experiments that
 *  were clustered together to produce a set of phases or the
 *  statistics for those phases.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_exptCategory>
 *  <PDBx:phasing_MAD_expt id="1">
 *  <PDBx:number_clust>2</PDBx:number_clust>
 *  <PDBx:R_normal_all>0.063</PDBx:R_normal_all>
 *  <PDBx:R_normal_anom_scat>0.451</PDBx:R_normal_anom_scat>
 *  <PDBx:delta_delta_phi>58.5</PDBx:delta_delta_phi>
 *  <PDBx:delta_phi_sigma>20.3</PDBx:delta_phi_sigma>
 *  <PDBx:mean_fom>0.88</PDBx:mean_fom>
 *  </PDBx:phasing_MAD_expt>
 *  <PDBx:phasing_MAD_expt id="2">
 *  <PDBx:number_clust>1</PDBx:number_clust>
 *  <PDBx:R_normal_all>0.051</PDBx:R_normal_all>
 *  <PDBx:R_normal_anom_scat>0.419</PDBx:R_normal_anom_scat>
 *  <PDBx:delta_delta_phi>36.8</PDBx:delta_delta_phi>
 *  <PDBx:delta_phi_sigma>18.2</PDBx:delta_phi_sigma>
 *  <PDBx:mean_fom>0.93</PDBx:mean_fom>
 *  </PDBx:phasing_MAD_expt>
 *  </PDBx:phasing_MAD_exptCategory>
 * </pre>
 */
public class Phasing_MAD_expt 
{
		protected java.lang.Float R_normal_all;


	/**
	 *  Definition...
	 */
	public java.lang.Float getR_normal_all() 
	{
		return R_normal_all;
	}
 
	public void setR_normal_all(java.lang.Float R_normal_all)
	{
		this.R_normal_all = R_normal_all;
	}

 	protected java.lang.Float R_normal_anom_scat;


	/**
	 *  Definition...
	 */
	public java.lang.Float getR_normal_anom_scat() 
	{
		return R_normal_anom_scat;
	}
 
	public void setR_normal_anom_scat(java.lang.Float R_normal_anom_scat)
	{
		this.R_normal_anom_scat = R_normal_anom_scat;
	}

 	protected java.lang.Float delta_delta_phi;


	/**
	 *  The difference between two independent determinations of
	 *  attribute delta_phi in category phasing_MAD_expt.
	 */
	public java.lang.Float getDelta_delta_phi() 
	{
		return delta_delta_phi;
	}
 
	public void setDelta_delta_phi(java.lang.Float delta_delta_phi)
	{
		this.delta_delta_phi = delta_delta_phi;
	}

 	protected java.lang.Float delta_phi;


	/**
	 *  The phase difference between F~t~(h), the structure factor due
	 *  to normal scattering from all atoms, and F~a~(h), the structure
	 *  factor due to normal scattering from only the anomalous
	 *  scatterers.
	 */
	public java.lang.Float getDelta_phi() 
	{
		return delta_phi;
	}
 
	public void setDelta_phi(java.lang.Float delta_phi)
	{
		this.delta_phi = delta_phi;
	}

 	protected java.lang.Float delta_phi_sigma;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute delta_phi in category phasing_MAD_expt.
	 */
	public java.lang.Float getDelta_phi_sigma() 
	{
		return delta_phi_sigma;
	}
 
	public void setDelta_phi_sigma(java.lang.Float delta_phi_sigma)
	{
		this.delta_phi_sigma = delta_phi_sigma;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category phasing_MAD_expt must uniquely identify each
	 *  record in the PHASING_MAD_EXPT list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float mean_fom;


	/**
	 *  The mean figure of merit.
	 */
	public java.lang.Float getMean_fom() 
	{
		return mean_fom;
	}
 
	public void setMean_fom(java.lang.Float mean_fom)
	{
		this.mean_fom = mean_fom;
	}

 	protected java.lang.Integer number_clust;


	/**
	 *  The number of clusters of data sets in this phasing experiment.
	 */
	public java.lang.Integer getNumber_clust() 
	{
		return number_clust;
	}
 
	public void setNumber_clust(java.lang.Integer number_clust)
	{
		this.number_clust = number_clust;
	}

 }
