package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR_DER_REFLN category record details
 *  about the calculated structure factors obtained in an MIR
 *  phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_refln indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 *  It is not necessary for the data items describing the measured
 *  value of F to appear in this list, as they will be
 *  given in the PHASING_SET_REFLN category. However, these
 *  items can also be listed here for completeness.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the 6,1,25 reflection
 *  of an Hg/Pt derivative of protein NS1.
 *  <PDBx:phasing_MIR_der_reflnCategory>
 *  <PDBx:phasing_MIR_der_refln index_h="6" index_k="1" index_l="25" der_id="HGPT1" set_id="NS1-96">
 *  <PDBx:F_calc_au>106.66</PDBx:F_calc_au>
 *  <PDBx:F_meas_au>204.67</PDBx:F_meas_au>
 *  <PDBx:F_meas_sigma>6.21</PDBx:F_meas_sigma>
 *  <PDBx:HL_A_iso>-3.15</PDBx:HL_A_iso>
 *  <PDBx:HL_B_iso>-0.76</PDBx:HL_B_iso>
 *  <PDBx:HL_C_iso>0.65</PDBx:HL_C_iso>
 *  <PDBx:HL_D_iso>0.23</PDBx:HL_D_iso>
 *  <PDBx:phase_calc>194.48</PDBx:phase_calc>
 *  </PDBx:phasing_MIR_der_refln>
 *  </PDBx:phasing_MIR_der_reflnCategory>
 * </pre>
 */
public class Phasing_MIR_der_refln 
{
		protected java.lang.Float F_calc;


	/**
	 *  The calculated value of the structure factor for this derivative,
	 *  in electrons.
	 */
	public java.lang.Float getF_calc() 
	{
		return F_calc;
	}
 
	public void setF_calc(java.lang.Float F_calc)
	{
		this.F_calc = F_calc;
	}

 	protected java.lang.Float F_calc_au;


	/**
	 *  The calculated value of the structure factor for this derivative,
	 *  in arbitrary units.
	 */
	public java.lang.Float getF_calc_au() 
	{
		return F_calc_au;
	}
 
	public void setF_calc_au(java.lang.Float F_calc_au)
	{
		this.F_calc_au = F_calc_au;
	}

 	protected java.lang.Float F_meas;


	/**
	 *  The measured value of the structure factor for this derivative,
	 *  in electrons.
	 */
	public java.lang.Float getF_meas() 
	{
		return F_meas;
	}
 
	public void setF_meas(java.lang.Float F_meas)
	{
		this.F_meas = F_meas;
	}

 	protected java.lang.Float F_meas_au;


	/**
	 *  The measured value of the structure factor for this derivative,
	 *  in arbitrary units.
	 */
	public java.lang.Float getF_meas_au() 
	{
		return F_meas_au;
	}
 
	public void setF_meas_au(java.lang.Float F_meas_au)
	{
		this.F_meas_au = F_meas_au;
	}

 	protected java.lang.Float F_meas_sigma;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute F_meas in category phasing_MIR_der_refln in electrons.
	 */
	public java.lang.Float getF_meas_sigma() 
	{
		return F_meas_sigma;
	}
 
	public void setF_meas_sigma(java.lang.Float F_meas_sigma)
	{
		this.F_meas_sigma = F_meas_sigma;
	}

 	protected java.lang.Float F_meas_sigma_au;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute F_meas_au in category phasing_MIR_der_refln in arbitrary units.
	 */
	public java.lang.Float getF_meas_sigma_au() 
	{
		return F_meas_sigma_au;
	}
 
	public void setF_meas_sigma_au(java.lang.Float F_meas_sigma_au)
	{
		this.F_meas_sigma_au = F_meas_sigma_au;
	}

 	protected java.lang.Float HL_A_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient A~iso~ for this
	 *  reflection for this derivative.
	 *  
	 *  -2.0 * (Fp~obs~^2^ + Fh~calc~^2^ - Fph~obs~^2^)
	 *  *  Fp~obs~ * cos(alphah~calc~)
	 *  A~iso~ =  -----------------------------------------------
	 *  E^2^
	 *  
	 *  E            = (Fph~obs~ - Fp~obs~ - Fh~calc~)^2^
	 *  for centric reflections
	 *  = [(Fph~obs~ - Fp~obs~) * 2^1/2^ - Fh~calc~]^2^
	 *  for acentric reflections
	 *  
	 *  Fp~obs~      = the observed structure-factor amplitude of the
	 *  native
	 *  Fph~obs~     = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~     = the calculated structure-factor amplitude
	 *  from the heavy-atom model
	 *  alphah~calc~ = the calculated phase from the heavy-atom model
	 *  
	 *  This coefficient appears in the expression for the phase
	 *  probability of each isomorphous derivative:
	 *  
	 *  P~i~(alpha) = exp[k + A * cos(alpha) + B * sin(alpha)
	 *  + C * cos(2 * alpha) + D * sin(2 * alpha)]
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getHL_A_iso() 
	{
		return HL_A_iso;
	}
 
	public void setHL_A_iso(java.lang.Float HL_A_iso)
	{
		this.HL_A_iso = HL_A_iso;
	}

 	protected java.lang.Float HL_B_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient B~iso~ for this
	 *  reflection for this derivative.
	 *  
	 *  -2.0 * (Fp~obs~^2^ + Fh~calc~^2^ - Fph~obs~^2^)
	 *  *  Fp~obs~ * sin(alphah~calc~)
	 *  B~iso~ =  -----------------------------------------------
	 *  E^2^
	 *  
	 *  E            = (Fph~obs~ - Fp~obs~ - Fh~calc~)^2^
	 *  for centric reflections
	 *  = [(Fph~obs~ - Fp~obs~) * 2^1/2^ - Fh~calc~]^2^
	 *  for acentric reflections
	 *  
	 *  Fp~obs~      = the observed structure-factor amplitude of the
	 *  native
	 *  Fph~obs~     = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~     = the calculated structure-factor amplitude
	 *  from the heavy-atom model
	 *  alphah~calc~ = the phase calculated from the heavy-atom model
	 *  
	 *  This coefficient appears in the expression for the phase
	 *  probability of each isomorphous derivative:
	 *  
	 *  P~i~(alpha) = exp[k + A * cos(alpha) + B * sin(alpha)
	 *  + C * cos(2 * alpha) + D * sin(2 * alpha)]
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getHL_B_iso() 
	{
		return HL_B_iso;
	}
 
	public void setHL_B_iso(java.lang.Float HL_B_iso)
	{
		this.HL_B_iso = HL_B_iso;
	}

 	protected java.lang.Float HL_C_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient C~iso~ for this
	 *  reflection for this derivative.
	 *  
	 *  -Fp~obs~^2^ * [sin(alphah~calc~)^2^
	 *  -  cos(alphah~calc~)^2^]
	 *  C~iso~ =  ------------------------------------
	 *  E^2^
	 *  
	 *  E            = (Fph~obs~ - Fp~obs~ - Fh~calc~)^2^
	 *  for centric reflections
	 *  = [(Fph~obs~ - Fp~obs~) * 2^1/2^ - Fh~calc~]^2^
	 *  for acentric reflections
	 *  
	 *  Fp~obs~      = the observed structure-factor amplitude of the
	 *  native
	 *  Fph~obs~     = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~     = the calculated structure-factor amplitude
	 *  from the heavy-atom model
	 *  alphah~calc~ = the phase calculated from the heavy-atom model
	 *  
	 *  This coefficient appears in the expression for the phase
	 *  probability of each isomorphous derivative:
	 *  
	 *  P~i~(alpha) = exp[k + A * cos(alpha) + B * sin(alpha)
	 *  + C * cos(2 * alpha) + D * sin(2 * alpha)]
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getHL_C_iso() 
	{
		return HL_C_iso;
	}
 
	public void setHL_C_iso(java.lang.Float HL_C_iso)
	{
		this.HL_C_iso = HL_C_iso;
	}

 	protected java.lang.Float HL_D_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient D~iso~ for this
	 *  reflection for this derivative.
	 *  
	 *  -2.0 * Fp~obs~^2^ * sin(alphah~calc~)^2^
	 *  * cos(alphah~calc~)^2^
	 *  D~iso~ =  ----------------------------------------
	 *  E^2^
	 *  
	 *  E            = (Fph~obs~ - Fp~obs~ - Fh~calc~)^2^
	 *  for centric reflections
	 *  = [(Fph~obs~ - Fp~obs~) * 2^1/2^ - Fh~calc~]^2^
	 *  for acentric reflections
	 *  
	 *  Fp~obs~      = the observed structure-factor amplitude of the
	 *  native
	 *  Fph~obs~     = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~     = the calculated structure-factor amplitude
	 *  from the heavy-atom model
	 *  alphah~calc~ = the phase calculated from the heavy-atom model
	 *  
	 *  This coefficient appears in the expression for the phase
	 *  probability of each isomorphous derivative:
	 *  
	 *  P~i~(alpha) = exp[k + A * cos(alpha) + B * sin(alpha)
	 *  + C * cos(2 * alpha) + D * sin(2 * alpha)]
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getHL_D_iso() 
	{
		return HL_D_iso;
	}
 
	public void setHL_D_iso(java.lang.Float HL_D_iso)
	{
		this.HL_D_iso = HL_D_iso;
	}

 	protected java.lang.String der_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MIR_der in the
	 *  PHASING_MIR_DER category.
	 */
	public java.lang.String getDer_id() 
	{
		return der_id;
	}
 
	public void setDer_id(java.lang.String der_id)
	{
		this.der_id = der_id;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h for this reflection for this derivative.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k for this reflection for this derivative.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l for this reflection for this derivative.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float phase_calc;


	/**
	 *  The calculated value of the structure-factor phase based on the
	 *  heavy-atom model for this derivative in degrees.
	 */
	public java.lang.Float getPhase_calc() 
	{
		return phase_calc;
	}
 
	public void setPhase_calc(java.lang.Float phase_calc)
	{
		this.phase_calc = phase_calc;
	}

 	protected java.lang.String set_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getSet_id() 
	{
		return set_id;
	}
 
	public void setSet_id(java.lang.String set_id)
	{
		this.set_id = set_id;
	}

 }
