package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR_DER_SHELL category record
 *  statistics, broken down into shells of resolution, for an MIR
 *  phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_shell indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with addition of an arbitrary low-resolution limit.
 *  <PDBx:phasing_MIR_der_shellCategory>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>54.</PDBx:ha_ampl>
 *  <PDBx:loc>26.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>54.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>50.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>44.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>39.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>33.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>28.</PDBx:ha_ampl>
 *  <PDBx:loc>17.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>38.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>149.</PDBx:ha_ampl>
 *  <PDBx:loc>87.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>121.</PDBx:ha_ampl>
 *  <PDBx:loc>73.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>95.</PDBx:ha_ampl>
 *  <PDBx:loc>61.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>80.</PDBx:ha_ampl>
 *  <PDBx:loc>60.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>73.</PDBx:ha_ampl>
 *  <PDBx:loc>63.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>68.</PDBx:ha_ampl>
 *  <PDBx:loc>57.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>63.</PDBx:ha_ampl>
 *  <PDBx:loc>46.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>79.</PDBx:ha_ampl>
 *  <PDBx:loc>58.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>33.</PDBx:ha_ampl>
 *  <PDBx:loc>27.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>40.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>31.</PDBx:ha_ampl>
 *  <PDBx:loc>22.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>27.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>22.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>19.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>16.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>23.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  </PDBx:phasing_MIR_der_shellCategory>
 * </pre>
 */
public class Phasing_MIR_der_shell 
{
		protected java.lang.Float R_cullis;


	/**
	 *  Residual factor R~cullis~ for centric reflections for this
	 *  derivative in this shell.
	 *  
	 *  sum| |Fph~obs~ +/- Fp~obs~| - Fh~calc~ |
	 *  R~cullis~ = ----------------------------------------
	 *  sum|Fph~obs~ - Fp~obs~|
	 *  
	 *  Fp~obs~  = the observed structure-factor amplitude of the native
	 *  Fph~obs~ = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~ = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Cullis, A. F., Muirhead, H., Perutz, M. F., Rossmann, M. G.
	 *  & North, A. C. T. (1961). Proc. R. Soc. London Ser. A,
	 *  265, 15-38.
	 */
	public java.lang.Float getR_cullis() 
	{
		return R_cullis;
	}
 
	public void setR_cullis(java.lang.Float R_cullis)
	{
		this.R_cullis = R_cullis;
	}

 	protected java.lang.Float R_kraut;


	/**
	 *  Residual factor R~kraut~ for general reflections for this
	 *  derivative in this shell.
	 *  
	 *  sum|Fph~obs~ - Fph~calc~|
	 *  R~kraut~ = -------------------------
	 *  sum|Fph~obs~|
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Kraut, J., Sieker, L. C., High, D. F. & Freer, S. T.
	 *  (1962). Proc. Natl Acad. Sci. USA, 48, 1417-1424.
	 */
	public java.lang.Float getR_kraut() 
	{
		return R_kraut;
	}
 
	public void setR_kraut(java.lang.Float R_kraut)
	{
		this.R_kraut = R_kraut;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value  for the interplanar spacings for the
	 *  reflection data for this derivative in this shell. This is called
	 *  the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data for this derivative in this shell. This is called
	 *  the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String der_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MIR_der in the
	 *  PHASING_MIR_DER category.
	 */
	public java.lang.String getDer_id() 
	{
		return der_id;
	}
 
	public void setDer_id(java.lang.String der_id)
	{
		this.der_id = der_id;
	}

 	protected java.lang.Float fom;


	/**
	 *  The mean value of the figure of merit m for reflections for this
	 *  derivative in this shell.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~alpha~ = the probability that the phase angle alpha is correct
	 *  
	 *  int is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFom() 
	{
		return fom;
	}
 
	public void setFom(java.lang.Float fom)
	{
		this.fom = fom;
	}

 	protected java.lang.Float ha_ampl;


	/**
	 *  The mean heavy-atom amplitude for reflections for this
	 *  derivative in this shell.
	 */
	public java.lang.Float getHa_ampl() 
	{
		return ha_ampl;
	}
 
	public void setHa_ampl(java.lang.Float ha_ampl)
	{
		this.ha_ampl = ha_ampl;
	}

 	protected java.lang.Float loc;


	/**
	 *  The mean lack-of-closure error loc for reflections for this
	 *  derivative in this shell.
	 *  
	 *  loc = sum|Fph~obs~ - Fph~calc~|
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLoc() 
	{
		return loc;
	}
 
	public void setLoc(java.lang.Float loc)
	{
		this.loc = loc;
	}

 	protected java.lang.Float pdbx_R_cullis_acentric;


	/**
	 *  record R Cullis obtained from acentric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_R_cullis_acentric() 
	{
		return pdbx_R_cullis_acentric;
	}
 
	public void setPdbx_R_cullis_acentric(java.lang.Float pdbx_R_cullis_acentric)
	{
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
	}

 	protected java.lang.Float pdbx_R_cullis_centric;


	/**
	 *  record R Cullis obtained from centric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_R_cullis_centric() 
	{
		return pdbx_R_cullis_centric;
	}
 
	public void setPdbx_R_cullis_centric(java.lang.Float pdbx_R_cullis_centric)
	{
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
	}

 	protected java.lang.Float pdbx_R_kraut_acentric;


	/**
	 *  record R Kraut obtained from acentric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_R_kraut_acentric() 
	{
		return pdbx_R_kraut_acentric;
	}
 
	public void setPdbx_R_kraut_acentric(java.lang.Float pdbx_R_kraut_acentric)
	{
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
	}

 	protected java.lang.Float pdbx_R_kraut_centric;


	/**
	 *  record R Kraut obtained from centric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_R_kraut_centric() 
	{
		return pdbx_R_kraut_centric;
	}
 
	public void setPdbx_R_kraut_centric(java.lang.Float pdbx_R_kraut_centric)
	{
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
	}

 	protected java.lang.Float pdbx_fom_acentric;


	/**
	 *  record figure of merit obtained from acentric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_fom_acentric() 
	{
		return pdbx_fom_acentric;
	}
 
	public void setPdbx_fom_acentric(java.lang.Float pdbx_fom_acentric)
	{
		this.pdbx_fom_acentric = pdbx_fom_acentric;
	}

 	protected java.lang.Float pdbx_fom_centric;


	/**
	 *  record figure of merit obtained from centric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_fom_centric() 
	{
		return pdbx_fom_centric;
	}
 
	public void setPdbx_fom_centric(java.lang.Float pdbx_fom_centric)
	{
		this.pdbx_fom_centric = pdbx_fom_centric;
	}

 	protected java.lang.Float pdbx_loc_acentric;


	/**
	 *  record lack of closure obtained from acentric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_loc_acentric() 
	{
		return pdbx_loc_acentric;
	}
 
	public void setPdbx_loc_acentric(java.lang.Float pdbx_loc_acentric)
	{
		this.pdbx_loc_acentric = pdbx_loc_acentric;
	}

 	protected java.lang.Float pdbx_loc_centric;


	/**
	 *  record lack of closure obtained from centric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_loc_centric() 
	{
		return pdbx_loc_centric;
	}
 
	public void setPdbx_loc_centric(java.lang.Float pdbx_loc_centric)
	{
		this.pdbx_loc_centric = pdbx_loc_centric;
	}

 	protected java.lang.Float pdbx_power_acentric;


	/**
	 *  record phasing power obtained from acentric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_power_acentric() 
	{
		return pdbx_power_acentric;
	}
 
	public void setPdbx_power_acentric(java.lang.Float pdbx_power_acentric)
	{
		this.pdbx_power_acentric = pdbx_power_acentric;
	}

 	protected java.lang.Float pdbx_power_centric;


	/**
	 *  record phasing power obtained from centric data for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_power_centric() 
	{
		return pdbx_power_centric;
	}
 
	public void setPdbx_power_centric(java.lang.Float pdbx_power_centric)
	{
		this.pdbx_power_centric = pdbx_power_centric;
	}

 	protected java.lang.Integer pdbx_reflns_acentric;


	/**
	 *  record  number of acentric reflections used for phasing for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Integer getPdbx_reflns_acentric() 
	{
		return pdbx_reflns_acentric;
	}
 
	public void setPdbx_reflns_acentric(java.lang.Integer pdbx_reflns_acentric)
	{
		this.pdbx_reflns_acentric = pdbx_reflns_acentric;
	}

 	protected java.lang.Float pdbx_reflns_centric;


	/**
	 *  record  number of centric reflections used for phasing for each
	 *  derivative, but broken into resolution shells
	 */
	public java.lang.Float getPdbx_reflns_centric() 
	{
		return pdbx_reflns_centric;
	}
 
	public void setPdbx_reflns_centric(java.lang.Float pdbx_reflns_centric)
	{
		this.pdbx_reflns_centric = pdbx_reflns_centric;
	}

 	protected java.lang.Float phase;


	/**
	 *  The mean of the phase values for reflections for this
	 *  derivative in this shell.
	 */
	public java.lang.Float getPhase() 
	{
		return phase;
	}
 
	public void setPhase(java.lang.Float phase)
	{
		this.phase = phase;
	}

 	protected java.lang.Float power;


	/**
	 *  The mean phasing power P for reflections for this derivative
	 *  in this shell.
	 *  
	 *  sum|Fh~calc~^2^|
	 *  P = (----------------------------)^1/2^
	 *  sum|Fph~obs~ - Fph~calc~|^2^
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~  = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getPower() 
	{
		return power;
	}
 
	public void setPower(java.lang.Float power)
	{
		this.power = power;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  The number of reflections in this shell.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 }
