package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR_SHELL category record statistics
 *  for an isomorphous replacement phasing experiment.broken
 *  down into shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with addition of an arbitrary low-resolution limit.
 *  <PDBx:phasing_MIR_shellCategory>
 *  <PDBx:phasing_MIR_shell d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:reflns>80</PDBx:reflns>
 *  <PDBx:FOM>0.69</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:reflns>184</PDBx:reflns>
 *  <PDBx:FOM>0.73</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:reflns>288</PDBx:reflns>
 *  <PDBx:FOM>0.72</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:reflns>406</PDBx:reflns>
 *  <PDBx:FOM>0.65</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:reflns>554</PDBx:reflns>
 *  <PDBx:FOM>0.54</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:reflns>730</PDBx:reflns>
 *  <PDBx:FOM>0.53</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:reflns>939</PDBx:reflns>
 *  <PDBx:FOM>0.50</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  </PDBx:phasing_MIR_shellCategory>
 * </pre>
 */
public class Phasing_MIR_shell 
{
		protected java.lang.Float FOM;


	/**
	 *  The mean value of the figure of merit m for reflections in this
	 *  shell.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~alpha~ = the probability that the phase angle alpha is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM() 
	{
		return FOM;
	}
 
	public void setFOM(java.lang.Float FOM)
	{
		this.FOM = FOM;
	}

 	protected java.lang.Float FOM_acentric;


	/**
	 *  The mean value of the figure of merit m for acentric reflections
	 *  in this shell.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM_acentric() 
	{
		return FOM_acentric;
	}
 
	public void setFOM_acentric(java.lang.Float FOM_acentric)
	{
		this.FOM_acentric = FOM_acentric;
	}

 	protected java.lang.Float FOM_centric;


	/**
	 *  The mean value of the figure of merit m for centric reflections
	 *  in this shell.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM_centric() 
	{
		return FOM_centric;
	}
 
	public void setFOM_centric(java.lang.Float FOM_centric)
	{
		this.FOM_centric = FOM_centric;
	}

 	protected java.lang.Float R_cullis;


	/**
	 *  Residual factor R~cullis~ for centric reflections in this shell.
	 *  
	 *  sum| |Fph~obs~ +/- Fp~obs~| - Fh~calc~ |
	 *  R~cullis~ = ----------------------------------------
	 *  sum|Fph~obs~ - Fp~obs~|
	 *  
	 *  Fp~obs~  = the observed structure-factor amplitude of the native
	 *  Fph~obs~ = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~ = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Cullis, A. F., Muirhead, H., Perutz, M. F., Rossmann, M. G.
	 *  & North, A. C. T. (1961). Proc. R. Soc. London Ser. A,
	 *  265, 15-38.
	 */
	public java.lang.Float getR_cullis() 
	{
		return R_cullis;
	}
 
	public void setR_cullis(java.lang.Float R_cullis)
	{
		this.R_cullis = R_cullis;
	}

 	protected java.lang.Float R_kraut;


	/**
	 *  Residual factor R~kraut~ for general reflections in this shell.
	 *  
	 *  sum|Fph~obs~ - Fph~calc~|
	 *  R~kraut~ = -------------------------
	 *  sum|Fph~obs~|
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Kraut, J., Sieker, L. C., High, D. F. & Freer, S. T.
	 *  (1962). Proc. Natl Acad. Sci. USA, 48, 1417-1424.
	 */
	public java.lang.Float getR_kraut() 
	{
		return R_kraut;
	}
 
	public void setR_kraut(java.lang.Float R_kraut)
	{
		this.R_kraut = R_kraut;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data in this shell. This is called the highest
	 *  resolution. Note that the resolution limits of shells in
	 *  the items  attribute d_res_high in category phasing_MIR_shell and
	 *  attribute d_res_low in category phasing_MIR_shell are independent of the resolution
	 *  limits of shells in the items  attribute d_res_high in category reflns_shell and
	 *  attribute d_res_low in category reflns_shell.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data in this shell. This is called the lowest
	 *  resolution. Note that the resolution limits of shells in the
	 *  items  attribute d_res_high in category phasing_MIR_shell and
	 *  attribute d_res_low in category phasing_MIR_shell are independent of the resolution
	 *  limits of shells in the items  attribute d_res_high in category reflns_shell and
	 *  attribute d_res_low in category reflns_shell.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Float loc;


	/**
	 *  The mean lack-of-closure error loc for reflections in this shell.
	 *  
	 *  loc = sum|Fph~obs~ - Fph~calc~|
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLoc() 
	{
		return loc;
	}
 
	public void setLoc(java.lang.Float loc)
	{
		this.loc = loc;
	}

 	protected java.lang.Float mean_phase;


	/**
	 *  The mean of the phase values for all reflections in this shell.
	 */
	public java.lang.Float getMean_phase() 
	{
		return mean_phase;
	}
 
	public void setMean_phase(java.lang.Float mean_phase)
	{
		this.mean_phase = mean_phase;
	}

 	protected java.lang.Float pdbx_R_cullis_acentric;


	/**
	 *  record R_Cullis from from acentric reflection for each shell.
	 */
	public java.lang.Float getPdbx_R_cullis_acentric() 
	{
		return pdbx_R_cullis_acentric;
	}
 
	public void setPdbx_R_cullis_acentric(java.lang.Float pdbx_R_cullis_acentric)
	{
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
	}

 	protected java.lang.Float pdbx_R_cullis_centric;


	/**
	 *  record R_Cullis from from centric reflection for each shell.
	 */
	public java.lang.Float getPdbx_R_cullis_centric() 
	{
		return pdbx_R_cullis_centric;
	}
 
	public void setPdbx_R_cullis_centric(java.lang.Float pdbx_R_cullis_centric)
	{
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
	}

 	protected java.lang.Float pdbx_R_kraut_acentric;


	/**
	 *  record R_kraut from from acentric reflection for each shell.
	 */
	public java.lang.Float getPdbx_R_kraut_acentric() 
	{
		return pdbx_R_kraut_acentric;
	}
 
	public void setPdbx_R_kraut_acentric(java.lang.Float pdbx_R_kraut_acentric)
	{
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
	}

 	protected java.lang.Float pdbx_R_kraut_centric;


	/**
	 *  record R_Kraut from from centric reflection for each shell.
	 */
	public java.lang.Float getPdbx_R_kraut_centric() 
	{
		return pdbx_R_kraut_centric;
	}
 
	public void setPdbx_R_kraut_centric(java.lang.Float pdbx_R_kraut_centric)
	{
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
	}

 	protected java.lang.Float pdbx_loc_acentric;


	/**
	 *  record lack of closure from acentric reflection for each shell.
	 */
	public java.lang.Float getPdbx_loc_acentric() 
	{
		return pdbx_loc_acentric;
	}
 
	public void setPdbx_loc_acentric(java.lang.Float pdbx_loc_acentric)
	{
		this.pdbx_loc_acentric = pdbx_loc_acentric;
	}

 	protected java.lang.Float pdbx_loc_centric;


	/**
	 *  record lack of closure from centric reflection for each shell.
	 */
	public java.lang.Float getPdbx_loc_centric() 
	{
		return pdbx_loc_centric;
	}
 
	public void setPdbx_loc_centric(java.lang.Float pdbx_loc_centric)
	{
		this.pdbx_loc_centric = pdbx_loc_centric;
	}

 	protected java.lang.Float pdbx_power_acentric;


	/**
	 *  record phasing power from acentric reflection for each shell.
	 */
	public java.lang.Float getPdbx_power_acentric() 
	{
		return pdbx_power_acentric;
	}
 
	public void setPdbx_power_acentric(java.lang.Float pdbx_power_acentric)
	{
		this.pdbx_power_acentric = pdbx_power_acentric;
	}

 	protected java.lang.Float pdbx_power_centric;


	/**
	 *  record phasing power from centric reflection for each shell.
	 */
	public java.lang.Float getPdbx_power_centric() 
	{
		return pdbx_power_centric;
	}
 
	public void setPdbx_power_centric(java.lang.Float pdbx_power_centric)
	{
		this.pdbx_power_centric = pdbx_power_centric;
	}

 	protected java.lang.Float power;


	/**
	 *  The mean phasing power P for reflections in this shell.
	 *  
	 *  sum|Fh~calc~^2^|
	 *  P = (----------------------------)^1/2^
	 *  sum|Fph~obs~ - Fph~calc~|^2^
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~  = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getPower() 
	{
		return power;
	}
 
	public void setPower(java.lang.Float power)
	{
		this.power = power;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  The number of reflections in this shell.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  The number of acentric reflections in this shell.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_anomalous;


	/**
	 *  The number of anomalous reflections in this shell.
	 */
	public java.lang.Integer getReflns_anomalous() 
	{
		return reflns_anomalous;
	}
 
	public void setReflns_anomalous(java.lang.Integer reflns_anomalous)
	{
		this.reflns_anomalous = reflns_anomalous;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  The number of centric reflections in this shell.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 }
