package org.pdb.beans;

/**
 *  Data items in the PHASING_SET category record details about
 *  the data sets used in a phasing experiment. A given data set
 *  may be used in a number of different ways; for instance, a
 *  single data set could be used both as an isomorphous derivative
 *  and as a component of a multiple-wavelength calculation. This
 *  category establishes identifiers for each data set and permits
 *  the archiving of a subset of experimental information for each
 *  data set (cell constants, wavelength, temperature etc.).
 *  
 *  This and related categories of data items are provided so that
 *  derivative intensity and phase information can be stored in
 *  the same data block as the information for the refined
 *  structure.
 *  
 *  If all the possible experimental information for each data
 *  set (raw data sets, crystal growth conditions etc.) is to be
 *  archived, these data items should be recorded in a separate
 *  data block.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for an Hg/Pt derivative of
 *  protein NS1.
 *  <PDBx:phasing_setCategory>
 *  <PDBx:phasing_set id="NS1-96">
 *  <PDBx:cell_angle_alpha>90.0</PDBx:cell_angle_alpha>
 *  <PDBx:cell_angle_beta>90.0</PDBx:cell_angle_beta>
 *  <PDBx:cell_angle_gamma>90.0</PDBx:cell_angle_gamma>
 *  <PDBx:cell_length_a>38.63</PDBx:cell_length_a>
 *  <PDBx:cell_length_b>38.63</PDBx:cell_length_b>
 *  <PDBx:cell_length_c>82.88</PDBx:cell_length_c>
 *  <PDBx:radiation_wavelength>1.5145</PDBx:radiation_wavelength>
 *  <PDBx:detector_type>image plate</PDBx:detector_type>
 *  <PDBx:detector_specific>RXII</PDBx:detector_specific>
 *  </PDBx:phasing_set>
 *  </PDBx:phasing_setCategory>
 * </pre>
 */
public class Phasing_set 
{
		protected java.lang.Float cell_angle_alpha;


	/**
	 *  Unit-cell angle alpha for this data set in degrees.
	 */
	public java.lang.Float getCell_angle_alpha() 
	{
		return cell_angle_alpha;
	}
 
	public void setCell_angle_alpha(java.lang.Float cell_angle_alpha)
	{
		this.cell_angle_alpha = cell_angle_alpha;
	}

 	protected java.lang.Float cell_angle_beta;


	/**
	 *  Unit-cell angle beta for this data set in degrees.
	 */
	public java.lang.Float getCell_angle_beta() 
	{
		return cell_angle_beta;
	}
 
	public void setCell_angle_beta(java.lang.Float cell_angle_beta)
	{
		this.cell_angle_beta = cell_angle_beta;
	}

 	protected java.lang.Float cell_angle_gamma;


	/**
	 *  Unit-cell angle gamma for this data set in degrees.
	 */
	public java.lang.Float getCell_angle_gamma() 
	{
		return cell_angle_gamma;
	}
 
	public void setCell_angle_gamma(java.lang.Float cell_angle_gamma)
	{
		this.cell_angle_gamma = cell_angle_gamma;
	}

 	protected java.lang.Float cell_length_a;


	/**
	 *  Unit-cell length a for this data set in angstroms.
	 */
	public java.lang.Float getCell_length_a() 
	{
		return cell_length_a;
	}
 
	public void setCell_length_a(java.lang.Float cell_length_a)
	{
		this.cell_length_a = cell_length_a;
	}

 	protected java.lang.Float cell_length_b;


	/**
	 *  Unit-cell length b for this data set in angstroms.
	 */
	public java.lang.Float getCell_length_b() 
	{
		return cell_length_b;
	}
 
	public void setCell_length_b(java.lang.Float cell_length_b)
	{
		this.cell_length_b = cell_length_b;
	}

 	protected java.lang.Float cell_length_c;


	/**
	 *  Unit-cell length c for this data set in angstroms.
	 */
	public java.lang.Float getCell_length_c() 
	{
		return cell_length_c;
	}
 
	public void setCell_length_c(java.lang.Float cell_length_c)
	{
		this.cell_length_c = cell_length_c;
	}

 	protected java.lang.String detector_specific;


	/**
	 *  The particular radiation detector. In general, this will be a
	 *  manufacturer, description, model number or some combination of
	 *  these.
	 *  Siemens model x
	 *  Kodak XG
	 *  MAR Research model y
	 */
	public java.lang.String getDetector_specific() 
	{
		return detector_specific;
	}
 
	public void setDetector_specific(java.lang.String detector_specific)
	{
		this.detector_specific = detector_specific;
	}

 	protected java.lang.String detector_type;


	/**
	 *  The general class of the radiation detector.
	 *  multiwire
	 *  imaging plate
	 *  CCD
	 *  film
	 */
	public java.lang.String getDetector_type() 
	{
		return detector_type;
	}
 
	public void setDetector_type(java.lang.String detector_type)
	{
		this.detector_type = detector_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category phasing_set must uniquely identify
	 *  a record in the PHASING_SET list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  KAu(CN)2
	 *  K2HgI4
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float pdbx_d_res_high;


	/**
	 *  The smallest value in angstroms for the interplanar spacings
	 *  for the reflections in this shell. This is called the highest
	 *  resolution.
	 */
	public java.lang.Float getPdbx_d_res_high() 
	{
		return pdbx_d_res_high;
	}
 
	public void setPdbx_d_res_high(java.lang.Float pdbx_d_res_high)
	{
		this.pdbx_d_res_high = pdbx_d_res_high;
	}

 	protected java.lang.Float pdbx_d_res_low;


	/**
	 *  The highest value in angstroms for the interplanar spacings
	 *  for the reflections in this shell. This is called the lowest
	 *  resolution.
	 */
	public java.lang.Float getPdbx_d_res_low() 
	{
		return pdbx_d_res_low;
	}
 
	public void setPdbx_d_res_low(java.lang.Float pdbx_d_res_low)
	{
		this.pdbx_d_res_low = pdbx_d_res_low;
	}

 	protected java.lang.String pdbx_temp_details;


	/**
	 *  The value of  attribute pdbx_temp_details in category phasing_set describes any
	 *  special details about the data collection temperature
	 *  for this phasing data set.
	 */
	public java.lang.String getPdbx_temp_details() 
	{
		return pdbx_temp_details;
	}
 
	public void setPdbx_temp_details(java.lang.String pdbx_temp_details)
	{
		this.pdbx_temp_details = pdbx_temp_details;
	}

 	protected java.lang.String radiation_source_specific;


	/**
	 *  The particular source of radiation. In general, this will be a
	 *  manufacturer, description, or model number (or some combination
	 *  of these) for laboratory sources and an institution name and
	 *  beamline name for synchrotron sources.
	 *  Rigaku RU200
	 *  Philips fine focus Mo
	 *  NSLS beamline X8C
	 */
	public java.lang.String getRadiation_source_specific() 
	{
		return radiation_source_specific;
	}
 
	public void setRadiation_source_specific(java.lang.String radiation_source_specific)
	{
		this.radiation_source_specific = radiation_source_specific;
	}

 	protected java.lang.Float radiation_wavelength;


	/**
	 *  The mean wavelength of the radiation used to measure this
	 *  data set.
	 */
	public java.lang.Float getRadiation_wavelength() 
	{
		return radiation_wavelength;
	}
 
	public void setRadiation_wavelength(java.lang.Float radiation_wavelength)
	{
		this.radiation_wavelength = radiation_wavelength;
	}

 	protected java.lang.Float temp;


	/**
	 *  The temperature in kelvins at which the data set was
	 *  measured.
	 */
	public java.lang.Float getTemp() 
	{
		return temp;
	}
 
	public void setTemp(java.lang.Float temp)
	{
		this.temp = temp;
	}

 }
