package org.pdb.beans;

/**
 *  Data items in the PUBL category are used when submitting a
 *  manuscript for publication.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:publCategory>
 *  <PDBx:publ>
 *  <PDBx:section_title>  trans-3-Benzoyl-2-(tert-butyl)-4-(iso-butyl)-
 *  1,3-oxazolidin-5-one</PDBx:section_title>
 *  <PDBx:section_abstract>  The oxazolidinone ring is a shallow envelope
 *  conformation with the tert-butyl and iso-butyl groups
 *  occupying trans-positions with respect to the ring.  The
 *  angles at the N atom sum to 356.2\&#37;, indicating a very
 *  small degree of pyramidalization at this atom.  This is
 *  consistent with electron delocalization between the N
 *  atom and the carbonyl centre [N-C=O = 1.374(3)\&#37;A].</PDBx:section_abstract>
 *  </PDBx:publ>
 *  </PDBx:publCategory>
 *  
 *  
 *  Example 2 - based on C~31~H~48~N~4~O~4~, reported by Coleman, Patrick,
 *  Andersen & Rettig [Acta Cryst. (1996), C52, 1525-1527].
 *  <PDBx:publCategory>
 *  <PDBx:publ>
 *  <PDBx:section_title>  Hemiasterlin methyl ester</PDBx:section_title>
 *  <PDBx:section_title_footnote>  IUPAC name: methyl 2,5-dimethyl-4-{2-[3-methyl-
 *  2-methylamino-3-(N-methylbenzo[b]pyrrol-
 *  3-yl)butanamido]-3,3-dimethyl-N-methyl-
 *  butanamido}-2-hexenoate.</PDBx:section_title_footnote>
 *  </PDBx:publ>
 *  </PDBx:publCategory>
 * </pre>
 */
public class Publ 
{
		protected java.lang.String contact_author;


	/**
	 *  The name and address of the author submitting the manuscript and
	 *  data block. This is the person contacted by the journal
	 *  editorial staff. It is preferable to use the separate data items
	 *  _publ.contact_author_name and _publ.contact_author_address.
	 *  Professor George Ferguson
	 *  Department of Chemistry and Biochemistry
	 *  University of Guelph
	 *  Ontario
	 *  Canada
	 *  N1G 2W1
	 */
	public java.lang.String getContact_author() 
	{
		return contact_author;
	}
 
	public void setContact_author(java.lang.String contact_author)
	{
		this.contact_author = contact_author;
	}

 	protected java.lang.String contact_author_address;


	/**
	 *  The address of the author submitting the manuscript and data
	 *  block. This is the person contacted by the journal editorial
	 *  staff.
	 *  Department of Chemistry and Biochemistry
	 *  University of Guelph
	 *  Ontario
	 *  Canada
	 *  N1G 2W1
	 */
	public java.lang.String getContact_author_address() 
	{
		return contact_author_address;
	}
 
	public void setContact_author_address(java.lang.String contact_author_address)
	{
		this.contact_author_address = contact_author_address;
	}

 	protected java.lang.String contact_author_email;


	/**
	 *  E-mail address in a form recognizable to international networks.
	 *  The format of e-mail addresses is given in Section 3.4, Address
	 *  Specification, of Internet Message Format, RFC 2822, P. Resnick
	 *  (Editor), Network Standards Group, April 2001.
	 *  name@host.domain.country
	 *  uur5@banjo.bitnet
	 */
	public java.lang.String getContact_author_email() 
	{
		return contact_author_email;
	}
 
	public void setContact_author_email(java.lang.String contact_author_email)
	{
		this.contact_author_email = contact_author_email;
	}

 	protected java.lang.String contact_author_fax;


	/**
	 *  Facsimile telephone number of the author submitting the
	 *  manuscript and data block.
	 *  
	 *  The recommended style starts with the international dialing
	 *  prefix, followed by the area code in parentheses, followed by the
	 *  local number with no spaces. The earlier convention of including
	 *  the international dialing prefix in parentheses is no longer
	 *  recommended.
	 *  12(34)9477330
	 *  12()349477330
	 */
	public java.lang.String getContact_author_fax() 
	{
		return contact_author_fax;
	}
 
	public void setContact_author_fax(java.lang.String contact_author_fax)
	{
		this.contact_author_fax = contact_author_fax;
	}

 	protected java.lang.String contact_author_name;


	/**
	 *  The name of the author submitting the manuscript and data
	 *  block. This is the person contacted by the journal editorial
	 *  staff.
	 *  Professor George Ferguson
	 */
	public java.lang.String getContact_author_name() 
	{
		return contact_author_name;
	}
 
	public void setContact_author_name(java.lang.String contact_author_name)
	{
		this.contact_author_name = contact_author_name;
	}

 	protected java.lang.String contact_author_phone;


	/**
	 *  Telephone number of the author submitting the manuscript and
	 *  data block.
	 *  
	 *  The recommended style starts with the international dialing
	 *  prefix, followed by the area code in parentheses, followed by the
	 *  local number and any extension number prefixed by 'x',
	 *  with no spaces. The earlier convention of including
	 *  the international dialing prefix in parentheses is no longer
	 *  recommended.
	 *  12(34)9477330
	 *  12()349477330
	 *  12(34)9477330x5543
	 */
	public java.lang.String getContact_author_phone() 
	{
		return contact_author_phone;
	}
 
	public void setContact_author_phone(java.lang.String contact_author_phone)
	{
		this.contact_author_phone = contact_author_phone;
	}

 	protected java.lang.String contact_letter;


	/**
	 *  A letter submitted to the journal editor by the contact author.
	 */
	public java.lang.String getContact_letter() 
	{
		return contact_letter;
	}
 
	public void setContact_letter(java.lang.String contact_letter)
	{
		this.contact_letter = contact_letter;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String manuscript_creation;


	/**
	 *  A description of the word-processor package and computer used to
	 *  create the word-processed manuscript stored as
	 *  attribute manuscript_processed in category publ.
	 *  Tex file created by FrameMaker on a Sun 3/280
	 */
	public java.lang.String getManuscript_creation() 
	{
		return manuscript_creation;
	}
 
	public void setManuscript_creation(java.lang.String manuscript_creation)
	{
		this.manuscript_creation = manuscript_creation;
	}

 	protected java.lang.String manuscript_processed;


	/**
	 *  The full manuscript of a paper (excluding possibly the figures
	 *  and the tables) output in ASCII characters from a word processor.
	 *  Information about the generation of this data item must be
	 *  specified in the data item  attribute manuscript_creation in category publ.
	 */
	public java.lang.String getManuscript_processed() 
	{
		return manuscript_processed;
	}
 
	public void setManuscript_processed(java.lang.String manuscript_processed)
	{
		this.manuscript_processed = manuscript_processed;
	}

 	protected java.lang.String manuscript_text;


	/**
	 *  The full manuscript of a paper (excluding figures and possibly
	 *  the tables) output as standard ASCII text.
	 */
	public java.lang.String getManuscript_text() 
	{
		return manuscript_text;
	}
 
	public void setManuscript_text(java.lang.String manuscript_text)
	{
		this.manuscript_text = manuscript_text;
	}

 	protected java.lang.String requested_category;


	/**
	 *  The category of paper submitted. For submission to
	 *  Acta Crystallographica Section C or
	 *  Acta Crystallographica Section E, ONLY the codes indicated
	 *  for use with these journals should be used.
	 */
	public java.lang.String getRequested_category() 
	{
		return requested_category;
	}
 
	public void setRequested_category(java.lang.String requested_category)
	{
		this.requested_category = requested_category;
	}

 	protected java.lang.String requested_coeditor_name;


	/**
	 *  The name of the co-editor whom the authors would like to
	 *  handle the submitted manuscript.
	 */
	public java.lang.String getRequested_coeditor_name() 
	{
		return requested_coeditor_name;
	}
 
	public void setRequested_coeditor_name(java.lang.String requested_coeditor_name)
	{
		this.requested_coeditor_name = requested_coeditor_name;
	}

 	protected java.lang.String requested_journal;


	/**
	 *  The name of the journal to which the manuscript is being
	 *  submitted.
	 */
	public java.lang.String getRequested_journal() 
	{
		return requested_journal;
	}
 
	public void setRequested_journal(java.lang.String requested_journal)
	{
		this.requested_journal = requested_journal;
	}

 	protected java.lang.String section_abstract;


	/**
	 *  The abstract section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_abstract() 
	{
		return section_abstract;
	}
 
	public void setSection_abstract(java.lang.String section_abstract)
	{
		this.section_abstract = section_abstract;
	}

 	protected java.lang.String section_acknowledgements;


	/**
	 *  The acknowledgements section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_acknowledgements() 
	{
		return section_acknowledgements;
	}
 
	public void setSection_acknowledgements(java.lang.String section_acknowledgements)
	{
		this.section_acknowledgements = section_acknowledgements;
	}

 	protected java.lang.String section_comment;


	/**
	 *  The comment section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_comment() 
	{
		return section_comment;
	}
 
	public void setSection_comment(java.lang.String section_comment)
	{
		this.section_comment = section_comment;
	}

 	protected java.lang.String section_discussion;


	/**
	 *  The discussion section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_discussion() 
	{
		return section_discussion;
	}
 
	public void setSection_discussion(java.lang.String section_discussion)
	{
		this.section_discussion = section_discussion;
	}

 	protected java.lang.String section_experimental;


	/**
	 *  The experimental section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed.
	 *  in category publ The _publ.section_exptl_prep, _publ.section_exptl_solution and
	 *  attribute section_exptl_refinement in category publ items are preferred for
	 *  separating the chemical preparation, structure solution and
	 *  refinement aspects of the description of the experiment.
	 */
	public java.lang.String getSection_experimental() 
	{
		return section_experimental;
	}
 
	public void setSection_experimental(java.lang.String section_experimental)
	{
		this.section_experimental = section_experimental;
	}

 	protected java.lang.String section_exptl_prep;


	/**
	 *  The experimental preparation section of a manuscript if the
	 *  manuscript is submitted in parts. As an alternative see
	 *  _publ.manuscript_text and _publ.manuscript_processed.
	 */
	public java.lang.String getSection_exptl_prep() 
	{
		return section_exptl_prep;
	}
 
	public void setSection_exptl_prep(java.lang.String section_exptl_prep)
	{
		this.section_exptl_prep = section_exptl_prep;
	}

 	protected java.lang.String section_exptl_refinement;


	/**
	 *  The experimental refinement section of a manuscript if the
	 *  manuscript is submitted in parts. As an alternative see
	 *  _publ.manuscript_text and _publ.manuscript_processed.
	 */
	public java.lang.String getSection_exptl_refinement() 
	{
		return section_exptl_refinement;
	}
 
	public void setSection_exptl_refinement(java.lang.String section_exptl_refinement)
	{
		this.section_exptl_refinement = section_exptl_refinement;
	}

 	protected java.lang.String section_exptl_solution;


	/**
	 *  The experimental solution section of a manuscript if the
	 *  manuscript is submitted in parts. As an alternative see
	 *  _publ.manuscript_text and _publ.manuscript_processed.
	 */
	public java.lang.String getSection_exptl_solution() 
	{
		return section_exptl_solution;
	}
 
	public void setSection_exptl_solution(java.lang.String section_exptl_solution)
	{
		this.section_exptl_solution = section_exptl_solution;
	}

 	protected java.lang.String section_figure_captions;


	/**
	 *  The figure captions section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_figure_captions() 
	{
		return section_figure_captions;
	}
 
	public void setSection_figure_captions(java.lang.String section_figure_captions)
	{
		this.section_figure_captions = section_figure_captions;
	}

 	protected java.lang.String section_introduction;


	/**
	 *  The introduction section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_introduction() 
	{
		return section_introduction;
	}
 
	public void setSection_introduction(java.lang.String section_introduction)
	{
		this.section_introduction = section_introduction;
	}

 	protected java.lang.String section_references;


	/**
	 *  The references section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_references() 
	{
		return section_references;
	}
 
	public void setSection_references(java.lang.String section_references)
	{
		this.section_references = section_references;
	}

 	protected java.lang.String section_synopsis;


	/**
	 *  The synopsis section of a manuscript if the manuscript is
	 *  submitted in parts. As an alternative see  attribute manuscript_text
	 *  in category publ and  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_synopsis() 
	{
		return section_synopsis;
	}
 
	public void setSection_synopsis(java.lang.String section_synopsis)
	{
		this.section_synopsis = section_synopsis;
	}

 	protected java.lang.String section_table_legends;


	/**
	 *  The table legends section of a manuscript if the manuscript
	 *  is submitted in parts. As an alternative see
	 *  _publ.manuscript_text and _publ.manuscript_processed.
	 */
	public java.lang.String getSection_table_legends() 
	{
		return section_table_legends;
	}
 
	public void setSection_table_legends(java.lang.String section_table_legends)
	{
		this.section_table_legends = section_table_legends;
	}

 	protected java.lang.String section_title;


	/**
	 *  The title of a manuscript if the manuscript is submitted in
	 *  parts. As an alternative see  attribute manuscript_text in category publ and
	 *  attribute manuscript_processed in category publ.
	 */
	public java.lang.String getSection_title() 
	{
		return section_title;
	}
 
	public void setSection_title(java.lang.String section_title)
	{
		this.section_title = section_title;
	}

 	protected java.lang.String section_title_footnote;


	/**
	 *  The footnote to the title of a manuscript if the manuscript
	 *  is submitted in parts. As an alternative see
	 *  _publ.manuscript_text and _publ.manuscript_processed.
	 */
	public java.lang.String getSection_title_footnote() 
	{
		return section_title_footnote;
	}
 
	public void setSection_title_footnote(java.lang.String section_title_footnote)
	{
		this.section_title_footnote = section_title_footnote;
	}

 }
