package org.pdb.beans;

/**
 *  Data items in the PUBL_AUTHOR category record details of
 *  the authors of a manuscript submitted for publication.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:publ_authorCategory>
 *  <PDBx:publ_author name="Willis, Anthony C.">
 *  <PDBx:address>     Research School of Chemistry
 *  Australian National University
 *  GPO Box 4
 *  Canberra, A.C.T.
 *  Australia    2601</PDBx:address>
 *  </PDBx:publ_author>
 *  </PDBx:publ_authorCategory>
 * </pre>
 */
public class Publ_author 
{
		protected java.lang.String address;


	/**
	 *  The address of a publication author. If there is more than one
	 *  author this is looped with  attribute name in category publ_author.
	 *  Department
	 *  Institute
	 *  Street
	 *  City and postcode
	 *  COUNTRY
	 */
	public java.lang.String getAddress() 
	{
		return address;
	}
 
	public void setAddress(java.lang.String address)
	{
		this.address = address;
	}

 	protected java.lang.String email;


	/**
	 *  The e-mail address of a publication author. If there is more
	 *  than one author, this will be looped with  attribute name.
	 *  in category publ_author The format of e-mail addresses is given in Section 3.4, Address
	 *  Specification, of  Internet Message Format, RFC 2822, P. Resnick
	 *  (Editor), Network Standards Group, April 2001.
	 *  name@host.domain.country
	 *  bm@iucr.org
	 */
	public java.lang.String getEmail() 
	{
		return email;
	}
 
	public void setEmail(java.lang.String email)
	{
		this.email = email;
	}

 	protected java.lang.String footnote;


	/**
	 *  A footnote accompanying an author's name in the list of authors
	 *  of a paper. Typically indicates sabbatical address, additional
	 *  affiliations or date of decease.
	 *  On leave from U. Western Australia
	 *  Also at Department of Biophysics
	 */
	public java.lang.String getFootnote() 
	{
		return footnote;
	}
 
	public void setFootnote(java.lang.String footnote)
	{
		this.footnote = footnote;
	}

 	protected java.lang.String id_iucr;


	/**
	 *  Identifier in the IUCr contact database of a publication
	 *  author.  This identifier may be available from the World
	 *  Directory of Crystallographers (http://wdc.iucr.org).
	 *  2985
	 */
	public java.lang.String getId_iucr() 
	{
		return id_iucr;
	}
 
	public void setId_iucr(java.lang.String id_iucr)
	{
		this.id_iucr = id_iucr;
	}

 	protected java.lang.String name;


	/**
	 *  The name of a publication author. If there are multiple authors
	 *  this will be looped with  attribute address in category publ_author.  The family
	 *  name(s), followed by a comma and including any dynastic
	 *  components, precedes the first names or initials.
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 }
