package org.pdb.beans;

/**
 *  Data items in the PUBL_BODY category permit the labelling of
 *  different text sections within the body of a paper.
 *  Note that these should not be used in a paper which has
 *  a standard format with sections tagged by specific data names
 *  (such as in Acta Crystallographica Section C). Typically,
 *  each journal will supply a list of the specific items it
 *  requires in its Notes for Authors.
 *  
 * <pre>
 *  Example 1 - based on a paper by R. Restori & D. Schwarzenbach
 *  [Acta Cryst. (1996), A52, 369-378].
 *  <PDBx:publ_bodyCategory>
 *  <PDBx:publ_body element="section" label="1">
 *  <PDBx:title>Introduction</PDBx:title>
 *  <PDBx:format>cif</PDBx:format>
 *  <PDBx:contents> X-ray diffraction from a crystalline material provides
 *  information on the thermally and spatially averaged
 *  electron density in the crystal...</PDBx:contents>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="section" label="2">
 *  <PDBx:title>Theory</PDBx:title>
 *  <PDBx:format>tex</PDBx:format>
 *  <PDBx:contents> In the rigid-atom approximation, the dynamic electron
 *  density of an atom is described by the convolution
 *  product of the static atomic density and a probability
 *  density function,
 *  $\rho_{dyn}(\bf r) = \rho_{stat}(\bf r) * P(\bf r). \eqno(1)$</PDBx:contents>
 *  </PDBx:publ_body>
 *  </PDBx:publ_bodyCategory>
 *  
 *  
 *  Example 2 - based on a paper by R. J. Papoular, Y. Vekhter & P. Coppens
 *  [Acta Cryst. (1996), A52, 397-407].
 *  <PDBx:publ_bodyCategory>
 *  <PDBx:publ_body element="section" label="3">
 *  <PDBx:title> The two-channel method for retrieval of the deformation
 *  electron density</PDBx:title>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsection" label="3.1">
 *  <PDBx:title>The two-channel entropy S[\D\r(r)]</PDBx:title>
 *  <PDBx:contents> As the wide dynamic range involved in the total electron
 *  density...</PDBx:contents>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsection" label="3.2">
 *  <PDBx:title>Uniform vs informative prior model densities</PDBx:title>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsubsection" label="3.2.1">
 *  <PDBx:title>Use of uniform models</PDBx:title>
 *  <PDBx:contents> Straightforward algebra leads to expressions analogous
 *  to...</PDBx:contents>
 *  </PDBx:publ_body>
 *  </PDBx:publ_bodyCategory>
 * </pre>
 */
public class Publ_body 
{
		protected java.lang.String contents;


	/**
	 *  A text section of a paper.
	 */
	public java.lang.String getContents() 
	{
		return contents;
	}
 
	public void setContents(java.lang.String contents)
	{
		this.contents = contents;
	}

 	protected java.lang.String element;


	/**
	 *  The functional role of the associated text section.
	 */
	public java.lang.String getElement() 
	{
		return element;
	}
 
	public void setElement(java.lang.String element)
	{
		this.element = element;
	}

 	protected java.lang.String format;


	/**
	 *  Code indicating the appropriate typesetting conventions
	 *  for accented characters and special symbols in the text
	 *  section.
	 */
	public java.lang.String getFormat() 
	{
		return format;
	}
 
	public void setFormat(java.lang.String format)
	{
		this.format = format;
	}

 	protected java.lang.String label;


	/**
	 *  Code identifying the section of text.
	 *  1
	 *  1.1
	 *  2.1.3
	 */
	public java.lang.String getLabel() 
	{
		return label;
	}
 
	public void setLabel(java.lang.String label)
	{
		this.label = label;
	}

 	protected java.lang.String title;


	/**
	 *  Title of the associated section of text.
	 */
	public java.lang.String getTitle() 
	{
		return title;
	}
 
	public void setTitle(java.lang.String title)
	{
		this.title = title;
	}

 }
