package org.pdb.beans;

/**
 *  Data items in the REFINE category record details about the
 *  structure-refinement parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refineCategory>
 *  <PDBx:refine entry_id="5HVP">
 *  <PDBx:ls_number_reflns_obs>12901</PDBx:ls_number_reflns_obs>
 *  <PDBx:ls_number_restraints>6609</PDBx:ls_number_restraints>
 *  <PDBx:ls_number_parameters>7032</PDBx:ls_number_parameters>
 *  <PDBx:ls_weighting_scheme>calc</PDBx:ls_weighting_scheme>
 *  <PDBx:ls_weighting_details> Sigdel model of Konnert-Hendrickson:
 *  Sigdel: Afsig +  Bfsig*(sin(theta)/lambda-1/6)
 *  Afsig = 22.0, Bfsig = -150.0 at beginning of refinement
 *  Afsig = 15.5, Bfsig =  -50.0 at end of refinement</PDBx:ls_weighting_details>
 *  </PDBx:refine>
 *  </PDBx:refineCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:refineCategory>
 *  <PDBx:refine>
 *  <PDBx:details>sfls:_F_calc_weight_full_matrix</PDBx:details>
 *  <PDBx:ls_structure_factor_coef>F</PDBx:ls_structure_factor_coef>
 *  <PDBx:ls_matrix_type>full</PDBx:ls_matrix_type>
 *  <PDBx:ls_weighting_scheme>calc</PDBx:ls_weighting_scheme>
 *  <PDBx:ls_weighting_details>w=1/(\s^2^(F)+0.0004F^2^)</PDBx:ls_weighting_details>
 *  <PDBx:ls_hydrogen_treatment>refxyz except H332B noref</PDBx:ls_hydrogen_treatment>
 *  <PDBx:ls_extinction_method>Zachariasen</PDBx:ls_extinction_method>
 *  <PDBx:ls_extinction_coef>3514.</PDBx:ls_extinction_coef>
 *  <PDBx:ls_extinction_expression> Larson, A. C. (1970). &quot;Crystallographic Computing&quot;, edited
 *  by F. R. Ahmed. Eq. (22) p. 292. Copenhagen: Munksgaard.</PDBx:ls_extinction_expression>
 *  <PDBx:ls_abs_structure_details> The absolute configuration was assigned to agree with the
 *  known chirality at C3 arising from its precursor l-leucine.</PDBx:ls_abs_structure_details>
 *  <PDBx:ls_abs_structure_Flack>0.</PDBx:ls_abs_structure_Flack>
 *  <PDBx:ls_number_reflns_obs>1408</PDBx:ls_number_reflns_obs>
 *  <PDBx:ls_number_parameters>272</PDBx:ls_number_parameters>
 *  <PDBx:ls_number_restraints>0</PDBx:ls_number_restraints>
 *  <PDBx:ls_number_constraints>0</PDBx:ls_number_constraints>
 *  <PDBx:ls_R_factor_all>.038</PDBx:ls_R_factor_all>
 *  <PDBx:ls_R_factor_obs>.034</PDBx:ls_R_factor_obs>
 *  <PDBx:ls_wR_factor_all>.044</PDBx:ls_wR_factor_all>
 *  <PDBx:ls_wR_factor_obs>.042</PDBx:ls_wR_factor_obs>
 *  <PDBx:ls_goodness_of_fit_all>1.462</PDBx:ls_goodness_of_fit_all>
 *  <PDBx:ls_goodness_of_fit_obs>1.515</PDBx:ls_goodness_of_fit_obs>
 *  <PDBx:ls_shift_over_esd_max>.535</PDBx:ls_shift_over_esd_max>
 *  <PDBx:ls_shift_over_esd_mean>.044</PDBx:ls_shift_over_esd_mean>
 *  <PDBx:diff_density_min>-.108</PDBx:diff_density_min>
 *  <PDBx:diff_density_max>.131</PDBx:diff_density_max>
 *  </PDBx:refine>
 *  </PDBx:refineCategory>
 * </pre>
 */
public class Refine 
{
		protected java.lang.Float B_iso_max;


	/**
	 *  The maximum isotropic displacement parameter (B value)
	 *  found in the coordinate set.
	 */
	public java.lang.Float getB_iso_max() 
	{
		return B_iso_max;
	}
 
	public void setB_iso_max(java.lang.Float B_iso_max)
	{
		this.B_iso_max = B_iso_max;
	}

 	protected java.lang.Float B_iso_mean;


	/**
	 *  The mean isotropic displacement parameter (B value)
	 *  for the coordinate set.
	 */
	public java.lang.Float getB_iso_mean() 
	{
		return B_iso_mean;
	}
 
	public void setB_iso_mean(java.lang.Float B_iso_mean)
	{
		this.B_iso_mean = B_iso_mean;
	}

 	protected java.lang.Float B_iso_min;


	/**
	 *  The minimum isotropic displacement parameter (B value)
	 *  found in the coordinate set.
	 */
	public java.lang.Float getB_iso_min() 
	{
		return B_iso_min;
	}
 
	public void setB_iso_min(java.lang.Float B_iso_min)
	{
		this.B_iso_min = B_iso_min;
	}

 	protected java.lang.Float aniso_B11;


	/**
	 *  The [1][1] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B11() 
	{
		return aniso_B11;
	}
 
	public void setAniso_B11(java.lang.Float aniso_B11)
	{
		this.aniso_B11 = aniso_B11;
	}

 	protected java.lang.Float aniso_B12;


	/**
	 *  The [1][2] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B12() 
	{
		return aniso_B12;
	}
 
	public void setAniso_B12(java.lang.Float aniso_B12)
	{
		this.aniso_B12 = aniso_B12;
	}

 	protected java.lang.Float aniso_B13;


	/**
	 *  The [1][3] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B13() 
	{
		return aniso_B13;
	}
 
	public void setAniso_B13(java.lang.Float aniso_B13)
	{
		this.aniso_B13 = aniso_B13;
	}

 	protected java.lang.Float aniso_B22;


	/**
	 *  The [2][2] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B22() 
	{
		return aniso_B22;
	}
 
	public void setAniso_B22(java.lang.Float aniso_B22)
	{
		this.aniso_B22 = aniso_B22;
	}

 	protected java.lang.Float aniso_B23;


	/**
	 *  The [2][3] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B23() 
	{
		return aniso_B23;
	}
 
	public void setAniso_B23(java.lang.Float aniso_B23)
	{
		this.aniso_B23 = aniso_B23;
	}

 	protected java.lang.Float aniso_B33;


	/**
	 *  The [3][3] element of the matrix that defines the overall
	 *  anisotropic displacement model if one was refined for this
	 *  structure.
	 */
	public java.lang.Float getAniso_B33() 
	{
		return aniso_B33;
	}
 
	public void setAniso_B33(java.lang.Float aniso_B33)
	{
		this.aniso_B33 = aniso_B33;
	}

 	protected java.lang.Float correlation_coeff_Fo_to_Fc;


	/**
	 *  The correlation coefficient between the observed and
	 *  calculated structure factors for reflections included in
	 *  the refinement.
	 *  
	 *  The correlation coefficient is scale-independent and gives
	 *  an idea of the quality of the refined model.
	 *  
	 *  sum~i~(Fo~i~ Fc~i~ - <Fo><Fc>)
	 *  R~corr~ = ------------------------------------------------------------
	 *  SQRT{sum~i~(Fo~i~)^2^-<Fo>^2^} SQRT{sum~i~(Fc~i~)^2^-<Fc>^2^}
	 *  
	 *  Fo = observed structure factors
	 *  Fc = calculated structure factors
	 *  <>   denotes average value
	 *  
	 *  summation is over reflections included in the refinement
	 */
	public java.lang.Float getCorrelation_coeff_Fo_to_Fc() 
	{
		return correlation_coeff_Fo_to_Fc;
	}
 
	public void setCorrelation_coeff_Fo_to_Fc(java.lang.Float correlation_coeff_Fo_to_Fc)
	{
		this.correlation_coeff_Fo_to_Fc = correlation_coeff_Fo_to_Fc;
	}

 	protected java.lang.Float correlation_coeff_Fo_to_Fc_free;


	/**
	 *  The correlation coefficient between the observed and
	 *  calculated structure factors for reflections not included
	 *  in the refinement (free reflections).
	 *  
	 *  The correlation coefficient is scale-independent and gives
	 *  an idea of the quality of the refined model.
	 *  
	 *  sum~i~(Fo~i~ Fc~i~ - <Fo><Fc>)
	 *  R~corr~ = ------------------------------------------------------------
	 *  SQRT{sum~i~(Fo~i~)^2^-<Fo>^2^} SQRT{sum~i~(Fc~i~)^2^-<Fc>^2^}
	 *  
	 *  Fo  = observed structure factors
	 *  Fc  = calculated structure factors
	 *  <>    denotes average value
	 *  
	 *  summation is over reflections not included
	 *  in the refinement (free reflections)
	 */
	public java.lang.Float getCorrelation_coeff_Fo_to_Fc_free() 
	{
		return correlation_coeff_Fo_to_Fc_free;
	}
 
	public void setCorrelation_coeff_Fo_to_Fc_free(java.lang.Float correlation_coeff_Fo_to_Fc_free)
	{
		this.correlation_coeff_Fo_to_Fc_free = correlation_coeff_Fo_to_Fc_free;
	}

 	protected java.lang.String details;


	/**
	 *  Description of special aspects of the refinement process.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Float diff_density_max;


	/**
	 *  The maximum value of the electron density in the final difference
	 *  Fourier map.
	 */
	public java.lang.Float getDiff_density_max() 
	{
		return diff_density_max;
	}
 
	public void setDiff_density_max(java.lang.Float diff_density_max)
	{
		this.diff_density_max = diff_density_max;
	}

 	protected java.lang.Float diff_density_max_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute diff_density_max in category refine.
	 */
	public java.lang.Float getDiff_density_max_esd() 
	{
		return diff_density_max_esd;
	}
 
	public void setDiff_density_max_esd(java.lang.Float diff_density_max_esd)
	{
		this.diff_density_max_esd = diff_density_max_esd;
	}

 	protected java.lang.Float diff_density_min;


	/**
	 *  The minimum value of the electron density in the final difference
	 *  Fourier map.
	 */
	public java.lang.Float getDiff_density_min() 
	{
		return diff_density_min;
	}
 
	public void setDiff_density_min(java.lang.Float diff_density_min)
	{
		this.diff_density_min = diff_density_min;
	}

 	protected java.lang.Float diff_density_min_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute diff_density_min in category refine.
	 */
	public java.lang.Float getDiff_density_min_esd() 
	{
		return diff_density_min_esd;
	}
 
	public void setDiff_density_min_esd(java.lang.Float diff_density_min_esd)
	{
		this.diff_density_min_esd = diff_density_min_esd;
	}

 	protected java.lang.Float diff_density_rms;


	/**
	 *  The root-mean-square-deviation of the electron density in the
	 *  final difference Fourier map. This value is measured with respect
	 *  to the arithmetic mean density and is derived from summations
	 *  over each grid point in the asymmetric unit of the cell. This
	 *  quantity is useful for assessing the significance of the values
	 *  of _refine.diff_density_min and _refine.diff_density_max, and
	 *  also for defining suitable contour levels.
	 */
	public java.lang.Float getDiff_density_rms() 
	{
		return diff_density_rms;
	}
 
	public void setDiff_density_rms(java.lang.Float diff_density_rms)
	{
		this.diff_density_rms = diff_density_rms;
	}

 	protected java.lang.Float diff_density_rms_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute diff_density_rms in category refine.
	 */
	public java.lang.Float getDiff_density_rms_esd() 
	{
		return diff_density_rms_esd;
	}
 
	public void setDiff_density_rms_esd(java.lang.Float diff_density_rms_esd)
	{
		this.diff_density_rms_esd = diff_density_rms_esd;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float ls_R_Fsqd_factor_obs;


	/**
	 *  Residual factor R(Fsqd) for reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns calculated on the squares of the
	 *  observed and calculated structure-factor amplitudes.
	 *  
	 *  sum|F~obs~^2^ - F~calc~^2^|
	 *  R(Fsqd) = ---------------------------
	 *  sum|F~obs~^2^|
	 *  
	 *  F~obs~^2^  = squares of the observed structure-factor amplitudes
	 *  F~calc~^2^ = squares of the calculated structure-factor
	 *  amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_Fsqd_factor_obs() 
	{
		return ls_R_Fsqd_factor_obs;
	}
 
	public void setLs_R_Fsqd_factor_obs(java.lang.Float ls_R_Fsqd_factor_obs)
	{
		this.ls_R_Fsqd_factor_obs = ls_R_Fsqd_factor_obs;
	}

 	protected java.lang.Float ls_R_I_factor_obs;


	/**
	 *  Residual factor R(I) for reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns calculated on the estimated
	 *  reflection intensities.
	 *  
	 *  This is most often calculated in Rietveld refinements against
	 *  powder data, where it is referred to as R~B~ or R~Bragg~.
	 *  
	 *  sum|I~obs~ - I~calc~|
	 *  R(I) = ---------------------
	 *  sum|I~obs~|
	 *  
	 *  I~obs~  = the net observed intensities
	 *  I~calc~ = the net calculated intensities
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_I_factor_obs() 
	{
		return ls_R_I_factor_obs;
	}
 
	public void setLs_R_I_factor_obs(java.lang.Float ls_R_I_factor_obs)
	{
		this.ls_R_I_factor_obs = ls_R_I_factor_obs;
	}

 	protected java.lang.Float ls_R_factor_R_free;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the test
	 *  reflections (i.e. were excluded from the refinement) when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_factor_R_free() 
	{
		return ls_R_factor_R_free;
	}
 
	public void setLs_R_factor_R_free(java.lang.Float ls_R_factor_R_free)
	{
		this.ls_R_factor_R_free = ls_R_factor_R_free;
	}

 	protected java.lang.Float ls_R_factor_R_free_error;


	/**
	 *  The estimated error in  attribute ls_R_factor_R_free.
	 *  in category refine The method used to estimate the error is described in the
	 *  item  attribute ls_R_factor_R_free_error_details in category refine.
	 */
	public java.lang.Float getLs_R_factor_R_free_error() 
	{
		return ls_R_factor_R_free_error;
	}
 
	public void setLs_R_factor_R_free_error(java.lang.Float ls_R_factor_R_free_error)
	{
		this.ls_R_factor_R_free_error = ls_R_factor_R_free_error;
	}

 	protected java.lang.String ls_R_factor_R_free_error_details;


	/**
	 *  Special aspects of the method used to estimated the error in
	 *  attribute ls_R_factor_R_free in category refine.
	 */
	public java.lang.String getLs_R_factor_R_free_error_details() 
	{
		return ls_R_factor_R_free_error_details;
	}
 
	public void setLs_R_factor_R_free_error_details(java.lang.String ls_R_factor_R_free_error_details)
	{
		this.ls_R_factor_R_free_error_details = ls_R_factor_R_free_error_details;
	}

 	protected java.lang.Float ls_R_factor_R_work;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the working
	 *  reflections (i.e. were included in the refinement)  when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  attribute ls_R_factor_obs in category refine should not be confused with
	 *  attribute ls_R_factor_R_work in category refine the former reports the results of a
	 *  refinement in which all observed reflections were used, the
	 *  latter a refinement in which a subset of the observed
	 *  reflections were excluded from refinement for the calculation
	 *  of a 'free' R factor. However, it would be meaningful to quote
	 *  both values if a 'free' R factor were calculated for most of
	 *  the refinement, but all of the observed reflections were used
	 *  in the final rounds of refinement; such a protocol should be
	 *  explained in  attribute details.
	 *  in category refine
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_factor_R_work() 
	{
		return ls_R_factor_R_work;
	}
 
	public void setLs_R_factor_R_work(java.lang.Float ls_R_factor_R_work)
	{
		this.ls_R_factor_R_work = ls_R_factor_R_work;
	}

 	protected java.lang.Float ls_R_factor_all;


	/**
	 *  Residual factor R for all reflections that satisfy the resolution
	 *  limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low.
	 *  in category refine
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_factor_all() 
	{
		return ls_R_factor_all;
	}
 
	public void setLs_R_factor_all(java.lang.Float ls_R_factor_all)
	{
		this.ls_R_factor_all = ls_R_factor_all;
	}

 	protected java.lang.Float ls_R_factor_gt;


	/**
	 *  Residual factor for the reflections (with number given by
	 *  attribute number_gt) in category reflns judged significantly intense (i.e. satisfying
	 *  the threshold specified by  attribute threshold_expression)
	 *  in category reflns and included in the refinement. The reflections also satisfy
	 *  the resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine.  This is the conventional R
	 *  factor. See also  attribute ls_wR_factor_ in category refine definitions.
	 *  
	 *  sum | F(obs) - F(calc) |
	 *  R = ------------------------
	 *  sum | F(obs) |
	 *  
	 *  F(obs)  = the observed structure-factor amplitudes
	 *  F(calc) = the calculated structure-factor amplitudes
	 *  
	 *  and the sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_factor_gt() 
	{
		return ls_R_factor_gt;
	}
 
	public void setLs_R_factor_gt(java.lang.Float ls_R_factor_gt)
	{
		this.ls_R_factor_gt = ls_R_factor_gt;
	}

 	protected java.lang.Float ls_R_factor_obs;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion.
	 *  in category reflns
	 *  attribute ls_R_factor_obs in category refine should not be confused with
	 *  attribute ls_R_factor_R_work in category refine the former reports the results of a
	 *  refinement in which all observed reflections were used, the
	 *  latter a refinement in which a subset of the observed
	 *  reflections were excluded from refinement for the calculation
	 *  of a 'free' R factor. However, it would be meaningful to quote
	 *  both values if a 'free' R factor were calculated for most of
	 *  the refinement, but all of the observed reflections were used
	 *  in the final rounds of refinement; such a protocol should be
	 *  explained in  attribute details.
	 *  in category refine
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_R_factor_obs() 
	{
		return ls_R_factor_obs;
	}
 
	public void setLs_R_factor_obs(java.lang.Float ls_R_factor_obs)
	{
		this.ls_R_factor_obs = ls_R_factor_obs;
	}

 	protected java.lang.Float ls_abs_structure_Flack;


	/**
	 *  The measure of absolute structure (enantiomorph or polarity) as
	 *  defined by Flack (1983).
	 *  
	 *  For centrosymmetric structures, the only permitted value, if the
	 *  data name is present, is 'inapplicable', represented by '.' .
	 *  
	 *  For noncentrosymmetric structures the value must lie in the
	 *  99.97% Gaussian confidence interval  -3u =< x =< 1 + 3u and a
	 *  standard uncertainty (estimated standard deviation) u must
	 *  be supplied. The item range of [0.0:1.0] is correctly
	 *  interpreted as meaning (0.0 - 3u) =< x =< (1.0 + 3u).
	 *  
	 *  Ref: Flack, H. D. (1983). Acta Cryst. A39, 876-881.
	 */
	public java.lang.Float getLs_abs_structure_Flack() 
	{
		return ls_abs_structure_Flack;
	}
 
	public void setLs_abs_structure_Flack(java.lang.Float ls_abs_structure_Flack)
	{
		this.ls_abs_structure_Flack = ls_abs_structure_Flack;
	}

 	protected java.lang.Float ls_abs_structure_Flack_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ls_abs_structure_Flack in category refine.
	 */
	public java.lang.Float getLs_abs_structure_Flack_esd() 
	{
		return ls_abs_structure_Flack_esd;
	}
 
	public void setLs_abs_structure_Flack_esd(java.lang.Float ls_abs_structure_Flack_esd)
	{
		this.ls_abs_structure_Flack_esd = ls_abs_structure_Flack_esd;
	}

 	protected java.lang.Float ls_abs_structure_Rogers;


	/**
	 *  The measure of absolute structure (enantiomorph or polarity) as
	 *  defined by Rogers.
	 *  
	 *  
	 *  The value must lie in the 99.97% Gaussian confidence interval
	 *  -1 -3u =< \h =< 1 + 3u and a standard uncertainty (estimated
	 *  standard deviation) u must be supplied. The item range of
	 *  [-1.0, 1.0] is correctly interpreted as meaning
	 *  (-1.0 - 3u) =< \h =< (1.0 + 3u).
	 *  
	 *  Ref: Rogers, D. (1981). Acta Cryst. A37, 734-741.
	 */
	public java.lang.Float getLs_abs_structure_Rogers() 
	{
		return ls_abs_structure_Rogers;
	}
 
	public void setLs_abs_structure_Rogers(java.lang.Float ls_abs_structure_Rogers)
	{
		this.ls_abs_structure_Rogers = ls_abs_structure_Rogers;
	}

 	protected java.lang.Float ls_abs_structure_Rogers_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ls_abs_structure_Rogers in category refine.
	 */
	public java.lang.Float getLs_abs_structure_Rogers_esd() 
	{
		return ls_abs_structure_Rogers_esd;
	}
 
	public void setLs_abs_structure_Rogers_esd(java.lang.Float ls_abs_structure_Rogers_esd)
	{
		this.ls_abs_structure_Rogers_esd = ls_abs_structure_Rogers_esd;
	}

 	protected java.lang.String ls_abs_structure_details;


	/**
	 *  The nature of the absolute structure and how it was determined.
	 *  For example, this may describe the Friedel pairs used.
	 */
	public java.lang.String getLs_abs_structure_details() 
	{
		return ls_abs_structure_details;
	}
 
	public void setLs_abs_structure_details(java.lang.String ls_abs_structure_details)
	{
		this.ls_abs_structure_details = ls_abs_structure_details;
	}

 	protected java.lang.Float ls_d_res_high;


	/**
	 *  The smallest value for the interplanar spacings for the
	 *  reflection data used in the refinement in angstroms. This is
	 *  called the highest resolution.
	 */
	public java.lang.Float getLs_d_res_high() 
	{
		return ls_d_res_high;
	}
 
	public void setLs_d_res_high(java.lang.Float ls_d_res_high)
	{
		this.ls_d_res_high = ls_d_res_high;
	}

 	protected java.lang.Float ls_d_res_low;


	/**
	 *  The largest value for the interplanar spacings for
	 *  the reflection data used in the refinement in angstroms.
	 *  This is called the lowest resolution.
	 */
	public java.lang.Float getLs_d_res_low() 
	{
		return ls_d_res_low;
	}
 
	public void setLs_d_res_low(java.lang.Float ls_d_res_low)
	{
		this.ls_d_res_low = ls_d_res_low;
	}

 	protected java.lang.Float ls_extinction_coef;


	/**
	 *  The extinction coefficient used to calculate the correction
	 *  factor applied to the structure-factor data. The nature of the
	 *  extinction coefficient is given in the definitions of
	 *  attribute ls_extinction_expression in category refine and
	 *  attribute ls_extinction_method.
	 *  in category refine
	 *  For the 'Zachariasen' method it is the r* value; for the
	 *  'Becker-Coppens type 1 isotropic' method it is the 'g' value,
	 *  and for 'Becker-Coppens type 2 isotropic' corrections it is
	 *  the 'rho' value. Note that the magnitude of these values is
	 *  usually of the order of 10000.
	 *  
	 *  Ref:  Becker, P. J. & Coppens, P. (1974). Acta Cryst. A30,
	 *  129-47, 148-153.
	 *  Zachariasen, W. H. (1967). Acta Cryst. 23, 558-564.
	 *  Larson, A. C. (1967). Acta Cryst. 23, 664-665.
	 *  Zachariasen coefficient r* = 0.347 E04
	 *  3472
	 */
	public java.lang.Float getLs_extinction_coef() 
	{
		return ls_extinction_coef;
	}
 
	public void setLs_extinction_coef(java.lang.Float ls_extinction_coef)
	{
		this.ls_extinction_coef = ls_extinction_coef;
	}

 	protected java.lang.Float ls_extinction_coef_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ls_extinction_coef in category refine.
	 */
	public java.lang.Float getLs_extinction_coef_esd() 
	{
		return ls_extinction_coef_esd;
	}
 
	public void setLs_extinction_coef_esd(java.lang.Float ls_extinction_coef_esd)
	{
		this.ls_extinction_coef_esd = ls_extinction_coef_esd;
	}

 	protected java.lang.String ls_extinction_expression;


	/**
	 *  A description of or reference to the extinction-correction
	 *  equation used to apply the data item
	 *  attribute ls_extinction_coef in category refine.  This information must be sufficient
	 *  to reproduce the extinction-correction factors applied to the
	 *  structure factors.
	 *  Larson, A. C. (1970). "Crystallographic Computing", edited by
	 *  F. R. Ahmed. Eq. (22), p.292. Copenhagen: Munksgaard.
	 */
	public java.lang.String getLs_extinction_expression() 
	{
		return ls_extinction_expression;
	}
 
	public void setLs_extinction_expression(java.lang.String ls_extinction_expression)
	{
		this.ls_extinction_expression = ls_extinction_expression;
	}

 	protected java.lang.String ls_extinction_method;


	/**
	 *  A description of the extinction-correction method applied.
	 *  This description should
	 *  include information about the correction method, either
	 *  'Becker-Coppens' or 'Zachariasen'.  The latter is sometimes
	 *  referred to as the 'Larson' method even though it employs
	 *  Zachariasen's formula.
	 *  
	 *  The Becker-Coppens procedure is referred to as 'type 1' when
	 *  correcting secondary extinction dominated by the mosaic spread;
	 *  as 'type 2' when secondary extinction is dominated by particle
	 *  size and includes a primary extinction component; and as 'mixed'
	 *  when there is a mixture of types 1 and 2.
	 *  
	 *  For the Becker-Coppens method, it is also necessary to set the
	 *  mosaic distribution as either 'Gaussian' or 'Lorentzian' and the
	 *  nature of the extinction as 'isotropic' or 'anisotropic'. Note
	 *  that if either the 'mixed' or 'anisotropic' corrections are
	 *  applied, the multiple coefficients cannot be contained in
	 *  *_extinction_coef and must be listed in  attribute details.
	 *  in category refine
	 *  Ref: Becker, P. J. & Coppens, P. (1974). Acta Cryst. A30,
	 *  129-147, 148-153.
	 *  Zachariasen, W. H. (1967). Acta Cryst. 23, 558- 564.
	 *  Larson, A. C. (1967). Acta Cryst. 23, 664-665.
	 *  B-C type 2 Gaussian isotropic
	 */
	public java.lang.String getLs_extinction_method() 
	{
		return ls_extinction_method;
	}
 
	public void setLs_extinction_method(java.lang.String ls_extinction_method)
	{
		this.ls_extinction_method = ls_extinction_method;
	}

 	protected java.lang.Float ls_goodness_of_fit_all;


	/**
	 *  The least-squares goodness-of-fit parameter S for all data
	 *  after the final cycle of refinement. Ideally, account should be
	 *  taken of parameters restrained in the least-squares refinement.
	 *  See also the definition of  attribute ls_restrained_S_all.
	 *  in category refine
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  S = ( ---------------------------- )
	 *  (       N~ref~ - N~param~      )
	 *  
	 *  Y~obs~   = the observed coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine Y~calc~  = the calculated coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine w        = the least-squares reflection weight
	 *  [1/(e.s.d. squared)]
	 *  
	 *  N~ref~   = the number of reflections used in the refinement
	 *  N~param~ = the number of refined parameters
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_goodness_of_fit_all() 
	{
		return ls_goodness_of_fit_all;
	}
 
	public void setLs_goodness_of_fit_all(java.lang.Float ls_goodness_of_fit_all)
	{
		this.ls_goodness_of_fit_all = ls_goodness_of_fit_all;
	}

 	protected java.lang.Float ls_goodness_of_fit_all_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ls_goodness_of_fit_all in category refine.
	 */
	public java.lang.Float getLs_goodness_of_fit_all_esd() 
	{
		return ls_goodness_of_fit_all_esd;
	}
 
	public void setLs_goodness_of_fit_all_esd(java.lang.Float ls_goodness_of_fit_all_esd)
	{
		this.ls_goodness_of_fit_all_esd = ls_goodness_of_fit_all_esd;
	}

 	protected java.lang.Float ls_goodness_of_fit_gt;


	/**
	 *  The least-squares goodness-of-fit parameter S for
	 *  significantly intense reflections (see
	 *  attribute threshold_expression) in category reflns after the final cycle of
	 *  refinement. Ideally, account should be taken of parameters
	 *  restrained in the least-squares refinement. See also
	 *  attribute ls_restrained_S_ in category refine definitions.
	 *  
	 *  {  sum { w [ Y(obs) - Y(calc) ]^2^ }  }^1/2^
	 *  S = { ----------------------------------- }
	 *  {            Nref - Nparam            }
	 *  
	 *  Y(obs)  = the observed coefficients
	 *  (see _refine_ls_structure_factor_coef)
	 *  Y(calc) = the calculated coefficients
	 *  (see _refine_ls_structure_factor_coef)
	 *  w       = the least-squares reflection weight
	 *  [1/(u^2^)]
	 *  u       = standard uncertainty
	 *  
	 *  Nref   = the number of reflections used in the refinement
	 *  Nparam = the number of refined parameters
	 *  
	 *  and the sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_goodness_of_fit_gt() 
	{
		return ls_goodness_of_fit_gt;
	}
 
	public void setLs_goodness_of_fit_gt(java.lang.Float ls_goodness_of_fit_gt)
	{
		this.ls_goodness_of_fit_gt = ls_goodness_of_fit_gt;
	}

 	protected java.lang.Float ls_goodness_of_fit_obs;


	/**
	 *  The least-squares goodness-of-fit parameter S for reflection data
	 *  classified as 'observed' (see  attribute observed_criterion) in category reflns after
	 *  the final cycle of refinement. Ideally, account should be taken
	 *  of parameters restrained in the least-squares refinement.
	 *  See also the definition of  attribute ls_restrained_S_obs.
	 *  in category refine
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  S = ( ---------------------------- )
	 *  (       N~ref~ - N~param~      )
	 *  
	 *  Y~obs~   = the observed coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine Y~calc~  = the calculated coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine w        = the least-squares reflection weight
	 *  [1/(e.s.d. squared)]
	 *  
	 *  N~ref~   = the number of reflections used in the refinement
	 *  N~param~ = the number of refined parameters
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_goodness_of_fit_obs() 
	{
		return ls_goodness_of_fit_obs;
	}
 
	public void setLs_goodness_of_fit_obs(java.lang.Float ls_goodness_of_fit_obs)
	{
		this.ls_goodness_of_fit_obs = ls_goodness_of_fit_obs;
	}

 	protected java.lang.Float ls_goodness_of_fit_obs_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ls_goodness_of_fit_obs in category refine.
	 */
	public java.lang.Float getLs_goodness_of_fit_obs_esd() 
	{
		return ls_goodness_of_fit_obs_esd;
	}
 
	public void setLs_goodness_of_fit_obs_esd(java.lang.Float ls_goodness_of_fit_obs_esd)
	{
		this.ls_goodness_of_fit_obs_esd = ls_goodness_of_fit_obs_esd;
	}

 	protected java.lang.Float ls_goodness_of_fit_ref;


	/**
	 *  The least-squares goodness-of-fit parameter S for all
	 *  reflections included in the refinement after the final cycle
	 *  of refinement. Ideally, account should be taken of parameters
	 *  restrained in the least-squares refinement. See also
	 *  _refine_ls_restrained_S_ definitions.
	 *  
	 *  {  sum | w | Y(obs) - Y(calc) |^2^ |  }^1/2^
	 *  S = { ----------------------------------- }
	 *  {            Nref - Nparam            }
	 *  
	 *  Y(obs)  = the observed coefficients
	 *  (see _refine_ls_structure_factor_coef)
	 *  Y(calc) = the calculated coefficients
	 *  (see _refine_ls_structure_factor_coef)
	 *  w       = the least-squares reflection weight
	 *  [1/(u^2^)]
	 *  u       = standard uncertainty
	 *  
	 *  Nref   = the number of reflections used in the refinement
	 *  Nparam = the number of refined parameters
	 *  
	 *  and the sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_goodness_of_fit_ref() 
	{
		return ls_goodness_of_fit_ref;
	}
 
	public void setLs_goodness_of_fit_ref(java.lang.Float ls_goodness_of_fit_ref)
	{
		this.ls_goodness_of_fit_ref = ls_goodness_of_fit_ref;
	}

 	protected java.lang.String ls_hydrogen_treatment;


	/**
	 *  Treatment of hydrogen atoms in the least-squares refinement.
	 */
	public java.lang.String getLs_hydrogen_treatment() 
	{
		return ls_hydrogen_treatment;
	}
 
	public void setLs_hydrogen_treatment(java.lang.String ls_hydrogen_treatment)
	{
		this.ls_hydrogen_treatment = ls_hydrogen_treatment;
	}

 	protected java.lang.String ls_matrix_type;


	/**
	 *  Type of matrix used to accumulate the least-squares derivatives.
	 */
	public java.lang.String getLs_matrix_type() 
	{
		return ls_matrix_type;
	}
 
	public void setLs_matrix_type(java.lang.String ls_matrix_type)
	{
		this.ls_matrix_type = ls_matrix_type;
	}

 	protected java.lang.Integer ls_number_constraints;


	/**
	 *  The number of constrained (non-refined or dependent) parameters
	 *  in the least-squares process. These may be due to symmetry or any
	 *  other constraint process (e.g. rigid-body refinement). See also
	 *  _atom_site.constraints and _atom_site.refinement_flags. A general
	 *  description of constraints may appear in  attribute details in category refine.
	 */
	public java.lang.Integer getLs_number_constraints() 
	{
		return ls_number_constraints;
	}
 
	public void setLs_number_constraints(java.lang.Integer ls_number_constraints)
	{
		this.ls_number_constraints = ls_number_constraints;
	}

 	protected java.lang.Integer ls_number_parameters;


	/**
	 *  The number of parameters refined in the least-squares process.
	 *  If possible, this number should include some contribution from
	 *  the restrained parameters. The restrained parameters are
	 *  distinct from the constrained parameters (where one or more
	 *  parameters are linearly dependent on the refined value of
	 *  another). Least-squares restraints often depend on geometry or
	 *  energy considerations and this makes their direct contribution
	 *  to this number, and to the goodness-of-fit calculation,
	 *  difficult to assess.
	 */
	public java.lang.Integer getLs_number_parameters() 
	{
		return ls_number_parameters;
	}
 
	public void setLs_number_parameters(java.lang.Integer ls_number_parameters)
	{
		this.ls_number_parameters = ls_number_parameters;
	}

 	protected java.lang.Integer ls_number_reflns_R_free;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low
	 *  and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the test
	 *  reflections (i.e. were excluded from the refinement) when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getLs_number_reflns_R_free() 
	{
		return ls_number_reflns_R_free;
	}
 
	public void setLs_number_reflns_R_free(java.lang.Integer ls_number_reflns_R_free)
	{
		this.ls_number_reflns_R_free = ls_number_reflns_R_free;
	}

 	protected java.lang.Integer ls_number_reflns_R_work;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low
	 *  and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the working
	 *  reflections (i.e. were included in the refinement) when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getLs_number_reflns_R_work() 
	{
		return ls_number_reflns_R_work;
	}
 
	public void setLs_number_reflns_R_work(java.lang.Integer ls_number_reflns_R_work)
	{
		this.ls_number_reflns_R_work = ls_number_reflns_R_work;
	}

 	protected java.lang.Integer ls_number_reflns_all;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low.
	 */
	public java.lang.Integer getLs_number_reflns_all() 
	{
		return ls_number_reflns_all;
	}
 
	public void setLs_number_reflns_all(java.lang.Integer ls_number_reflns_all)
	{
		this.ls_number_reflns_all = ls_number_reflns_all;
	}

 	protected java.lang.Integer ls_number_reflns_obs;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low
	 *  and the observation limit established by
	 *  attribute observed_criterion in category reflns.
	 */
	public java.lang.Integer getLs_number_reflns_obs() 
	{
		return ls_number_reflns_obs;
	}
 
	public void setLs_number_reflns_obs(java.lang.Integer ls_number_reflns_obs)
	{
		this.ls_number_reflns_obs = ls_number_reflns_obs;
	}

 	protected java.lang.Integer ls_number_restraints;


	/**
	 *  The number of restrained parameters. These are parameters which
	 *  are not directly dependent on another refined parameter.
	 *  Restrained parameters often involve geometry or energy
	 *  dependencies.
	 *  See also _atom_site.constraints and _atom_site.refinement_flags.
	 *  A general description of refinement constraints may appear in
	 *  attribute details in category refine.
	 */
	public java.lang.Integer getLs_number_restraints() 
	{
		return ls_number_restraints;
	}
 
	public void setLs_number_restraints(java.lang.Integer ls_number_restraints)
	{
		this.ls_number_restraints = ls_number_restraints;
	}

 	protected java.lang.Float ls_percent_reflns_R_free;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low
	 *  and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the test
	 *  reflections (i.e. were excluded from the refinement) when the
	 *  refinement included the calculation of a 'free' R factor,
	 *  expressed as a percentage of the number of geometrically
	 *  observable reflections that satisfy the resolution limits.
	 */
	public java.lang.Float getLs_percent_reflns_R_free() 
	{
		return ls_percent_reflns_R_free;
	}
 
	public void setLs_percent_reflns_R_free(java.lang.Float ls_percent_reflns_R_free)
	{
		this.ls_percent_reflns_R_free = ls_percent_reflns_R_free;
	}

 	protected java.lang.Float ls_percent_reflns_obs;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by _refine.ls_d_res_high and _refine.ls_d_res_low
	 *  and the observation limit established by
	 *  attribute observed_criterion in category reflns expressed as a percentage of the
	 *  number of geometrically observable reflections that satisfy
	 *  the resolution limits.
	 */
	public java.lang.Float getLs_percent_reflns_obs() 
	{
		return ls_percent_reflns_obs;
	}
 
	public void setLs_percent_reflns_obs(java.lang.Float ls_percent_reflns_obs)
	{
		this.ls_percent_reflns_obs = ls_percent_reflns_obs;
	}

 	protected java.lang.Float ls_redundancy_reflns_all;


	/**
	 *  The ratio of the total number of observations of the
	 *  reflections that satisfy the resolution limits established by
	 *  _refine.ls_d_res_high and _refine.ls_d_res_low to the number
	 *  of crystallographically unique reflections that satisfy the
	 *  same limits.
	 */
	public java.lang.Float getLs_redundancy_reflns_all() 
	{
		return ls_redundancy_reflns_all;
	}
 
	public void setLs_redundancy_reflns_all(java.lang.Float ls_redundancy_reflns_all)
	{
		this.ls_redundancy_reflns_all = ls_redundancy_reflns_all;
	}

 	protected java.lang.Float ls_redundancy_reflns_obs;


	/**
	 *  The ratio of the total number of observations of the
	 *  reflections that satisfy the resolution limits established by
	 *  _refine.ls_d_res_high and _refine.ls_d_res_low and the
	 *  observation limit established by  attribute observed_criterion in category reflns to
	 *  the number of crystallographically unique reflections that
	 *  satisfy the same limits.
	 */
	public java.lang.Float getLs_redundancy_reflns_obs() 
	{
		return ls_redundancy_reflns_obs;
	}
 
	public void setLs_redundancy_reflns_obs(java.lang.Float ls_redundancy_reflns_obs)
	{
		this.ls_redundancy_reflns_obs = ls_redundancy_reflns_obs;
	}

 	protected java.lang.Float ls_restrained_S_all;


	/**
	 *  The least-squares goodness-of-fit parameter S' for all
	 *  reflections after the final cycle of least-squares refinement.
	 *  This parameter explicitly includes the restraints applied
	 *  in the least-squares process. See also the definition of
	 *  attribute ls_goodness_of_fit_all.
	 *  in category refine
	 *  (   sum   |w    |Y~obs~  - Y~calc~|^2^| )^1/2^
	 *  ( + sum~r~|w~r~ |P~calc~ - P~targ~|^2^| )
	 *  S' = ( ------------------------------------- )
	 *  (      N~ref~ + N~restr~ - N~param~     )
	 *  
	 *  Y~obs~   = the observed coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine Y~calc~  = the calculated coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine w        = the least-squares reflection weight
	 *  [1/(e.s.d. squared)]
	 *  
	 *  P~calc~  = the calculated restraint values
	 *  P~targ~  = the target restraint values
	 *  w~r~     = the restraint weight
	 *  
	 *  N~ref~   = the number of reflections used in the refinement
	 *  (see  attribute ls_number_reflns_obs)
	 *  in category refine N~restr~ = the number of restraints
	 *  (see  attribute ls_number_restraints)
	 *  in category refine N~param~ = the number of refined parameters
	 *  (see  attribute ls_number_parameters)
	 *  in category refine
	 *  sum  is taken over the specified reflections
	 *  sumr is taken over the restraints
	 */
	public java.lang.Float getLs_restrained_S_all() 
	{
		return ls_restrained_S_all;
	}
 
	public void setLs_restrained_S_all(java.lang.Float ls_restrained_S_all)
	{
		this.ls_restrained_S_all = ls_restrained_S_all;
	}

 	protected java.lang.Float ls_restrained_S_obs;


	/**
	 *  The least-squares goodness-of-fit parameter S' for reflection
	 *  data classified as observed (see  attribute observed_criterion)
	 *  in category reflns after the final cycle of least-squares refinement. This
	 *  parameter explicitly includes the restraints applied in
	 *  the least-squares process. See also the definition of
	 *  attribute ls_goodness_of_fit_obs.
	 *  in category refine
	 *  (   sum   |w    |Y~obs~  - Y~calc~|^2^| )^1/2^
	 *  ( + sum~r~|w~r~ |P~calc~ - P~targ~|^2^| )
	 *  S' = ( ------------------------------------- )
	 *  (      N~ref~ + N~restr~ - N~param~     )
	 *  
	 *  Y~obs~   = the observed coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine Y~calc~  = the calculated coefficients
	 *  (see  attribute ls_structure_factor_coef)
	 *  in category refine w        = the least-squares reflection weight
	 *  [1/(e.s.d. squared)]
	 *  
	 *  P~calc~  = the calculated restraint values
	 *  P~targ~  = the target restraint values
	 *  w~r~     = the restraint weight
	 *  
	 *  N~ref~   = the number of reflections used in the refinement
	 *  (see  attribute ls_number_reflns_obs)
	 *  in category refine N~restr~ = the number of restraints
	 *  (see  attribute ls_number_restraints)
	 *  in category refine N~param~ = the number of refined parameters
	 *  (see  attribute ls_number_parameters)
	 *  in category refine
	 *  sum  is taken over the specified reflections
	 *  sumr is taken over the restraints
	 */
	public java.lang.Float getLs_restrained_S_obs() 
	{
		return ls_restrained_S_obs;
	}
 
	public void setLs_restrained_S_obs(java.lang.Float ls_restrained_S_obs)
	{
		this.ls_restrained_S_obs = ls_restrained_S_obs;
	}

 	protected java.lang.Float ls_shift_over_esd_max;


	/**
	 *  The largest ratio of the final least-squares parameter shift
	 *  to the final standard uncertainty (estimated standard
	 *  deviation).
	 */
	public java.lang.Float getLs_shift_over_esd_max() 
	{
		return ls_shift_over_esd_max;
	}
 
	public void setLs_shift_over_esd_max(java.lang.Float ls_shift_over_esd_max)
	{
		this.ls_shift_over_esd_max = ls_shift_over_esd_max;
	}

 	protected java.lang.Float ls_shift_over_esd_mean;


	/**
	 *  The average ratio of the final least-squares parameter shift
	 *  to the final standard uncertainty (estimated standard
	 *  deviation).
	 */
	public java.lang.Float getLs_shift_over_esd_mean() 
	{
		return ls_shift_over_esd_mean;
	}
 
	public void setLs_shift_over_esd_mean(java.lang.Float ls_shift_over_esd_mean)
	{
		this.ls_shift_over_esd_mean = ls_shift_over_esd_mean;
	}

 	protected java.lang.Float ls_shift_over_su_max;


	/**
	 *  The largest ratio of the final least-squares parameter
	 *  shift to the final standard uncertainty.
	 */
	public java.lang.Float getLs_shift_over_su_max() 
	{
		return ls_shift_over_su_max;
	}
 
	public void setLs_shift_over_su_max(java.lang.Float ls_shift_over_su_max)
	{
		this.ls_shift_over_su_max = ls_shift_over_su_max;
	}

 	protected java.lang.Float ls_shift_over_su_max_lt;


	/**
	 *  An upper limit for the largest ratio of the final
	 *  least-squares parameter shift to the final
	 *  standard uncertainty.  This item is used when the largest
	 *  value of the shift divided by the final standard uncertainty
	 *  is too small to measure.
	 */
	public java.lang.Float getLs_shift_over_su_max_lt() 
	{
		return ls_shift_over_su_max_lt;
	}
 
	public void setLs_shift_over_su_max_lt(java.lang.Float ls_shift_over_su_max_lt)
	{
		this.ls_shift_over_su_max_lt = ls_shift_over_su_max_lt;
	}

 	protected java.lang.Float ls_shift_over_su_mean;


	/**
	 *  The average ratio of the final least-squares parameter
	 *  shift to the final standard uncertainty.
	 */
	public java.lang.Float getLs_shift_over_su_mean() 
	{
		return ls_shift_over_su_mean;
	}
 
	public void setLs_shift_over_su_mean(java.lang.Float ls_shift_over_su_mean)
	{
		this.ls_shift_over_su_mean = ls_shift_over_su_mean;
	}

 	protected java.lang.Float ls_shift_over_su_mean_lt;


	/**
	 *  An upper limit for the average ratio of the final
	 *  least-squares parameter shift to the
	 *  final standard uncertainty.  This
	 *  item is used when the average value of the shift divided by
	 *  the final standard uncertainty is too small to measure.
	 */
	public java.lang.Float getLs_shift_over_su_mean_lt() 
	{
		return ls_shift_over_su_mean_lt;
	}
 
	public void setLs_shift_over_su_mean_lt(java.lang.Float ls_shift_over_su_mean_lt)
	{
		this.ls_shift_over_su_mean_lt = ls_shift_over_su_mean_lt;
	}

 	protected java.lang.String ls_structure_factor_coef;


	/**
	 *  Structure-factor coefficient |F|, F^2^ or I used in the least-
	 *  squares refinement process.
	 */
	public java.lang.String getLs_structure_factor_coef() 
	{
		return ls_structure_factor_coef;
	}
 
	public void setLs_structure_factor_coef(java.lang.String ls_structure_factor_coef)
	{
		this.ls_structure_factor_coef = ls_structure_factor_coef;
	}

 	protected java.lang.Float ls_wR_factor_R_free;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the test
	 *  reflections (i.e. were excluded from the refinement) when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_wR_factor_R_free() 
	{
		return ls_wR_factor_R_free;
	}
 
	public void setLs_wR_factor_R_free(java.lang.Float ls_wR_factor_R_free)
	{
		this.ls_wR_factor_R_free = ls_wR_factor_R_free;
	}

 	protected java.lang.Float ls_wR_factor_R_work;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion in category reflns and that were used as the working
	 *  reflections (i.e. were included in the refinement) when the
	 *  refinement included the calculation of a 'free' R factor.
	 *  Details of how reflections were assigned to the working and
	 *  test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_wR_factor_R_work() 
	{
		return ls_wR_factor_R_work;
	}
 
	public void setLs_wR_factor_R_work(java.lang.Float ls_wR_factor_R_work)
	{
		this.ls_wR_factor_R_work = ls_wR_factor_R_work;
	}

 	protected java.lang.Float ls_wR_factor_all;


	/**
	 *  Weighted residual factor wR for all reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low.
	 *  in category refine
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_wR_factor_all() 
	{
		return ls_wR_factor_all;
	}
 
	public void setLs_wR_factor_all(java.lang.Float ls_wR_factor_all)
	{
		this.ls_wR_factor_all = ls_wR_factor_all;
	}

 	protected java.lang.Float ls_wR_factor_obs;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getLs_wR_factor_obs() 
	{
		return ls_wR_factor_obs;
	}
 
	public void setLs_wR_factor_obs(java.lang.Float ls_wR_factor_obs)
	{
		this.ls_wR_factor_obs = ls_wR_factor_obs;
	}

 	protected java.lang.String ls_weighting_details;


	/**
	 *  A description of special aspects of the weighting scheme used
	 *  in least-squares refinement. Used to describe the weighting
	 *  when the value of  attribute ls_weighting_scheme in category refine is specified
	 *  as 'calc'.
	 *  Sigdel model of Konnert-Hendrickson:
	 *  Sigdel =
	 *  Afsig +  Bfsig*(sin(theta)/lambda-1/6)
	 *  Afsig = 22.0, Bfsig = 150.0
	 *  at the beginning of refinement.
	 *  Afsig = 16.0, Bfsig =  60.0
	 *  at the end of refinement.
	 */
	public java.lang.String getLs_weighting_details() 
	{
		return ls_weighting_details;
	}
 
	public void setLs_weighting_details(java.lang.String ls_weighting_details)
	{
		this.ls_weighting_details = ls_weighting_details;
	}

 	protected java.lang.String ls_weighting_scheme;


	/**
	 *  The weighting scheme applied in the least-squares process. The
	 *  standard code may be followed by a description of the weight
	 *  (but see  attribute ls_weighting_details in category refine for a preferred approach).
	 */
	public java.lang.String getLs_weighting_scheme() 
	{
		return ls_weighting_scheme;
	}
 
	public void setLs_weighting_scheme(java.lang.String ls_weighting_scheme)
	{
		this.ls_weighting_scheme = ls_weighting_scheme;
	}

 	protected java.lang.Float occupancy_max;


	/**
	 *  The maximum value for occupancy found in the coordinate set.
	 */
	public java.lang.Float getOccupancy_max() 
	{
		return occupancy_max;
	}
 
	public void setOccupancy_max(java.lang.Float occupancy_max)
	{
		this.occupancy_max = occupancy_max;
	}

 	protected java.lang.Float occupancy_min;


	/**
	 *  The minimum value for occupancy found in the coordinate set.
	 */
	public java.lang.Float getOccupancy_min() 
	{
		return occupancy_min;
	}
 
	public void setOccupancy_min(java.lang.Float occupancy_min)
	{
		this.occupancy_min = occupancy_min;
	}

 	protected java.lang.Float overall_FOM_free_R_set;


	/**
	 *  Average figure of merit of phases of reflections not included
	 *  in the refinement.
	 *  
	 *  This value is derived from the likelihood function.
	 *  
	 *  FOM           = I_1(X)/I_0(X)
	 *  
	 *  I_0, I_1      = zero- and first-order modified Bessel functions
	 *  of the first kind
	 *  X             = sigma_A |E_o| |E_c|/SIGMA
	 *  E_o, E_c      = normalized observed and calculated structure
	 *  factors
	 *  sigma_A       = <cos 2 pi s delta_x> SQRT(Sigma_P/Sigma_N)
	 *  estimated using maximum likelihood
	 *  Sigma_P       = sum_{atoms in model} f^2
	 *  Sigma_N       = sum_{atoms in crystal} f^2
	 *  f             = form factor of atoms
	 *  delta_x       = expected error
	 *  SIGMA         = (sigma_{E;exp})^2 + epsilon [1-(sigma_A)^2]
	 *  sigma_{E;exp} = uncertainties of normalized observed
	 *  structure factors
	 *  epsilon       = multiplicity of the diffracting plane
	 *  
	 *  Ref: Murshudov, G. N., Vagin, A. A. & Dodson, E. J. (1997).
	 *  Acta Cryst. D53, 240-255.
	 */
	public java.lang.Float getOverall_FOM_free_R_set() 
	{
		return overall_FOM_free_R_set;
	}
 
	public void setOverall_FOM_free_R_set(java.lang.Float overall_FOM_free_R_set)
	{
		this.overall_FOM_free_R_set = overall_FOM_free_R_set;
	}

 	protected java.lang.Float overall_FOM_work_R_set;


	/**
	 *  Average figure of merit of phases of reflections included in
	 *  the refinement.
	 *  
	 *  This value is derived from the likelihood function
	 *  
	 *  FOM           = I_1(X)/I_0(X)
	 *  
	 *  I_0, I_1      = zero- and first-order modified Bessel functions
	 *  of the first kind
	 *  X             = sigma_A |E_o| |E_c|/SIGMA
	 *  E_o, E_c      = normalized observed and calculated structure
	 *  factors
	 *  sigma_A       = <cos 2 pi s delta_x> SQRT(Sigma_P/Sigma_N)
	 *  estimated using maximum likelihood
	 *  Sigma_P       = sum_{atoms in model} f^2
	 *  Sigma_N       = sum_{atoms in crystal} f^2
	 *  f             = form factor of atoms
	 *  delta_x       = expected error
	 *  SIGMA         = (sigma_{E;exp})^2 + epsilon [1-(sigma_A)^2]
	 *  sigma_{E;exp} = uncertainties of normalized observed
	 *  structure factors
	 *  epsilon       = multiplicity of diffracting plane
	 *  
	 *  Ref: Murshudov, G. N., Vagin, A. A. & Dodson, E. J. (1997).
	 *  Acta Cryst. D53, 240-255.
	 */
	public java.lang.Float getOverall_FOM_work_R_set() 
	{
		return overall_FOM_work_R_set;
	}
 
	public void setOverall_FOM_work_R_set(java.lang.Float overall_FOM_work_R_set)
	{
		this.overall_FOM_work_R_set = overall_FOM_work_R_set;
	}

 	protected java.lang.Float overall_SU_B;


	/**
	 *  The overall standard uncertainty (estimated standard deviation)
	 *  of the displacement parameters based on a maximum-likelihood
	 *  residual.
	 *  
	 *  The overall standard uncertainty (sigma~B~)^2 gives an idea
	 *  of the uncertainty in the B values of averagely defined
	 *  atoms (atoms with B values equal to the average B value).
	 *  
	 *  N_a
	 *  (sigma~B~)^2  = 8 ----------------------------------------------
	 *  sum~i~ {[1/Sigma - (E_o)^2 (1-m^2)](SUM_AS)s^4}
	 *  
	 *  SUM_AS         = (sigma_A)^2/Sigma^2
	 *  N_a            = number of atoms
	 *  Sigma          = (sigma_{E;exp})^2 + epsilon [1-(sigma_A)^2]
	 *  E_o            = normalized structure factors
	 *  sigma_{E;exp}  = experimental uncertainties of normalized
	 *  structure factors
	 *  sigma_A        = <cos 2 pi s delta_x> SQRT(Sigma_P/Sigma_N)
	 *  estimated using maximum likelihood
	 *  Sigma_P        = sum_{atoms in model} f^2
	 *  Sigma_N        = sum_{atoms in crystal} f^2
	 *  f              = form factor of atoms
	 *  delta_x        = expected error
	 *  m              = figure of merit of phases of reflections
	 *  included in the summation
	 *  s              = reciprocal-space vector
	 *  epsilon        = multiplicity of diffracting plane
	 *  
	 *  summation is over all reflections included in refinement
	 *  
	 *  Ref: (sigma_A estimation) "Refinement of macromolecular
	 *  structures by the maximum-likelihood method",
	 *  Murshudov, G. N., Vagin, A. A. & Dodson, E. J. (1997).
	 *  Acta Cryst. D53, 240-255.
	 *  
	 *  (SU ML estimation) Murshudov, G. N. & Dodson,
	 *  E. J. (1997). Simplified error estimation a la
	 *  Cruickshank in macromolecular crystallography.
	 *  CCP4 Newsletter on Protein Crystallography, No. 33,
	 *  January 1997, pp. 31-39.
	 *  http://www.ccp4.ac.uk/newsletters/newsletter33/murshudov.html
	 */
	public java.lang.Float getOverall_SU_B() 
	{
		return overall_SU_B;
	}
 
	public void setOverall_SU_B(java.lang.Float overall_SU_B)
	{
		this.overall_SU_B = overall_SU_B;
	}

 	protected java.lang.Float overall_SU_ML;


	/**
	 *  The overall standard uncertainty (estimated standard deviation)
	 *  of the positional parameters based on a maximum likelihood
	 *  residual.
	 *  
	 *  The overall standard uncertainty (sigma~X~)^2 gives an
	 *  idea of the uncertainty in the position of averagely
	 *  defined atoms (atoms with B values equal to average B value)
	 *  
	 *  3                         N_a
	 *  (sigma~X~)^2  = -----------------------------------------------------
	 *  8 pi^2 sum~i~ {[1/Sigma - (E_o)^2 (1-m^2)](SUM_AS)s^2}
	 *  
	 *  SUM_AS         = (sigma_A)^2/Sigma^2)
	 *  N_a            = number of atoms
	 *  Sigma          = (sigma_{E;exp})^2 + epsilon [1-{sigma_A)^2]
	 *  E_o            = normalized structure factors
	 *  
	 *  sigma_{E;exp}  = experimental uncertainties of normalized
	 *  structure factors
	 *  sigma_A        = <cos 2 pi s delta_x> SQRT(Sigma_P/Sigma_N)
	 *  estimated using maximum likelihood
	 *  Sigma_P        = sum_{atoms in model} f^2
	 *  Sigma_N        = sum_{atoms in crystal} f^2
	 *  f              = form factor of atoms
	 *  delta_x        = expected error
	 *  m              = figure of merit of phases of reflections
	 *  included in the summation
	 *  s              = reciprocal-space vector
	 *  epsilon        = multiplicity of the diffracting plane
	 *  
	 *  summation is over all reflections included in refinement
	 *  
	 *  Ref: (sigma_A estimation) "Refinement of macromolecular
	 *  structures by the maximum-likelihood method",
	 *  Murshudov, G. N., Vagin, A. A. & Dodson, E. J. (1997).
	 *  Acta Cryst. D53, 240-255.
	 *  
	 *  (SU ML estimation) Murshudov, G. N. & Dodson,
	 *  E. J. (1997). Simplified error estimation a la
	 *  Cruickshank in macromolecular crystallography.
	 *  CCP4 Newsletter on Protein Crystallography, No. 33,
	 *  January 1997, pp. 31-39.
	 *  http://www.ccp4.ac.uk/newsletters/newsletter33/murshudov.html
	 */
	public java.lang.Float getOverall_SU_ML() 
	{
		return overall_SU_ML;
	}
 
	public void setOverall_SU_ML(java.lang.Float overall_SU_ML)
	{
		this.overall_SU_ML = overall_SU_ML;
	}

 	protected java.lang.Float overall_SU_R_Cruickshank_DPI;


	/**
	 *  The overall standard uncertainty (estimated standard deviation)
	 *  of the displacement parameters based on the crystallographic
	 *  R value, expressed in a formalism known as the dispersion
	 *  precision indicator (DPI).
	 *  
	 *  The overall standard uncertainty (sigma~B~) gives an idea
	 *  of the uncertainty in the B values of averagely defined
	 *  atoms (atoms with B values equal to the average B value).
	 *  
	 *  N_a
	 *  (sigma_B)^2  = 0.65 --------- (R_value)^2 (D_min)^2 C^(-2/3)
	 *  (N_o-N_p)
	 *  
	 *  
	 *  N_a      = number of atoms
	 *  N_o      = number of reflections included in refinement
	 *  N_p      = number of refined parameters
	 *  R_value  = conventional crystallographic R value
	 *  D_min    = maximum resolution
	 *  C        = completeness of data
	 *  
	 *  Ref: Cruickshank, D. W. J. (1999). Acta Cryst. D55, 583-601.
	 *  
	 *  Murshudov, G. N. & Dodson,
	 *  E. J. (1997). Simplified error estimation a la
	 *  Cruickshank in macromolecular crystallography.
	 *  CCP4 Newsletter on Protein Crystallography, No. 33,
	 *  January 1997, pp. 31-39.
	 *  http://www.ccp4.ac.uk/newsletters/newsletter33/murshudov.html
	 */
	public java.lang.Float getOverall_SU_R_Cruickshank_DPI() 
	{
		return overall_SU_R_Cruickshank_DPI;
	}
 
	public void setOverall_SU_R_Cruickshank_DPI(java.lang.Float overall_SU_R_Cruickshank_DPI)
	{
		this.overall_SU_R_Cruickshank_DPI = overall_SU_R_Cruickshank_DPI;
	}

 	protected java.lang.Float overall_SU_R_free;


	/**
	 *  The overall standard uncertainty (estimated standard deviation)
	 *  of the displacement parameters based on the free R value.
	 *  
	 *  The overall standard uncertainty gives an idea of the
	 *  uncertainty in the B values of averagely defined atoms
	 *  (atoms with B values equal to the average B value).
	 *  
	 *  N_a
	 *  (sigma_B)^2  = 0.65 ----- (R_free)^2 (D_min)^2 C^(-2/3)
	 *  N_o
	 *  
	 *  N_a    = number of atoms
	 *  N_o    = number of reflections included in refinement
	 *  R_free = conventional free crystallographic R value calculated
	 *  using reflections not included in refinement
	 *  D_min  = maximum resolution
	 *  C      = completeness of data
	 *  
	 *  Ref: Cruickshank, D. W. J. (1999). Acta Cryst. D55, 583-601.
	 *  
	 *  Murshudov, G. N. & Dodson,
	 *  E. J. (1997). Simplified error estimation a la
	 *  Cruickshank in macromolecular crystallography.
	 *  CCP4 Newsletter on Protein Crystallography, No. 33,
	 *  January 1997, pp. 31-39.
	 *  http://www.ccp4.ac.uk/newsletters/newsletter33/murshudov.html
	 */
	public java.lang.Float getOverall_SU_R_free() 
	{
		return overall_SU_R_free;
	}
 
	public void setOverall_SU_R_free(java.lang.Float overall_SU_R_free)
	{
		this.overall_SU_R_free = overall_SU_R_free;
	}

 	protected java.lang.String pdbx_R_Free_selection_details;


	/**
	 *  Details of the manner in which the cross validation
	 *  reflections were selected.
	 *  Random selection
	 */
	public java.lang.String getPdbx_R_Free_selection_details() 
	{
		return pdbx_R_Free_selection_details;
	}
 
	public void setPdbx_R_Free_selection_details(java.lang.String pdbx_R_Free_selection_details)
	{
		this.pdbx_R_Free_selection_details = pdbx_R_Free_selection_details;
	}

 	protected java.lang.Float pdbx_data_cutoff_high_absF;


	/**
	 *  Value of F at "high end" of data cutoff.
	 *  17600
	 */
	public java.lang.Float getPdbx_data_cutoff_high_absF() 
	{
		return pdbx_data_cutoff_high_absF;
	}
 
	public void setPdbx_data_cutoff_high_absF(java.lang.Float pdbx_data_cutoff_high_absF)
	{
		this.pdbx_data_cutoff_high_absF = pdbx_data_cutoff_high_absF;
	}

 	protected java.lang.Float pdbx_data_cutoff_high_rms_absF;


	/**
	 *  Value of RMS |F| used as high data cutoff.
	 *  205.1
	 */
	public java.lang.Float getPdbx_data_cutoff_high_rms_absF() 
	{
		return pdbx_data_cutoff_high_rms_absF;
	}
 
	public void setPdbx_data_cutoff_high_rms_absF(java.lang.Float pdbx_data_cutoff_high_rms_absF)
	{
		this.pdbx_data_cutoff_high_rms_absF = pdbx_data_cutoff_high_rms_absF;
	}

 	protected java.lang.Float pdbx_data_cutoff_low_absF;


	/**
	 *  Value of F at "low end" of data cutoff.
	 *  0.30
	 */
	public java.lang.Float getPdbx_data_cutoff_low_absF() 
	{
		return pdbx_data_cutoff_low_absF;
	}
 
	public void setPdbx_data_cutoff_low_absF(java.lang.Float pdbx_data_cutoff_low_absF)
	{
		this.pdbx_data_cutoff_low_absF = pdbx_data_cutoff_low_absF;
	}

 	protected java.lang.Float pdbx_density_correlation;


	/**
	 *  The density correlation coefficient is calculated from atomic
	 *  densities of (2Fobs-Fcalc) map - "Robs" and the model
	 *  map (Fcalc) - "Rcalc" :
	 *  
	 *  D_corr =  <Robs><Rcalc>/sqrt(<Robs**2><Rcalc**2>)
	 *  
	 *  where <Robs> is the mean of "observed" densities of all atoms
	 *  
	 *  <Rcalc> is the mean of "calculated" densities of
	 *  all atoms.
	 *  
	 *  The value of density for some atom from map R(x) is:
	 *  
	 *  sum_i ( R(xi) * Ratom(xi - xa) )
	 *  Dens =  ----------------------------------
	 *  sum_i ( Ratom(xi - xa) )
	 *  
	 *  where  Ratom(x) is atomic electron density for the x-th grid point.
	 *  xa - vector of the centre of atom.
	 *  xi - vector of the i-th point of grid.
	 *  Sum is taken over all grid points which have distance
	 *  from the center of the atom less than the Radius_limit.
	 *  For all atoms Radius_limit = 2.5 A.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getPdbx_density_correlation() 
	{
		return pdbx_density_correlation;
	}
 
	public void setPdbx_density_correlation(java.lang.Float pdbx_density_correlation)
	{
		this.pdbx_density_correlation = pdbx_density_correlation;
	}

 	protected java.lang.String pdbx_isotropic_thermal_model;


	/**
	 *  Whether the structure was refined with indvidual
	 *  isotropic, anisotropic or overall temperature factor.
	 *  Isotropic
	 *  Overall
	 */
	public java.lang.String getPdbx_isotropic_thermal_model() 
	{
		return pdbx_isotropic_thermal_model;
	}
 
	public void setPdbx_isotropic_thermal_model(java.lang.String pdbx_isotropic_thermal_model)
	{
		this.pdbx_isotropic_thermal_model = pdbx_isotropic_thermal_model;
	}

 	protected java.lang.String pdbx_ls_cross_valid_method;


	/**
	 *  Whether the cross validataion method was used through
	 *  out or only at the end.
	 *  FREE R-VALUE
	 */
	public java.lang.String getPdbx_ls_cross_valid_method() 
	{
		return pdbx_ls_cross_valid_method;
	}
 
	public void setPdbx_ls_cross_valid_method(java.lang.String pdbx_ls_cross_valid_method)
	{
		this.pdbx_ls_cross_valid_method = pdbx_ls_cross_valid_method;
	}

 	protected java.lang.Float pdbx_ls_sigma_F;


	/**
	 *  Data cutoff (SIGMA(F))
	 */
	public java.lang.Float getPdbx_ls_sigma_F() 
	{
		return pdbx_ls_sigma_F;
	}
 
	public void setPdbx_ls_sigma_F(java.lang.Float pdbx_ls_sigma_F)
	{
		this.pdbx_ls_sigma_F = pdbx_ls_sigma_F;
	}

 	protected java.lang.Float pdbx_ls_sigma_Fsqd;


	/**
	 *  Data cutoff (SIGMA(F^2))
	 */
	public java.lang.Float getPdbx_ls_sigma_Fsqd() 
	{
		return pdbx_ls_sigma_Fsqd;
	}
 
	public void setPdbx_ls_sigma_Fsqd(java.lang.Float pdbx_ls_sigma_Fsqd)
	{
		this.pdbx_ls_sigma_Fsqd = pdbx_ls_sigma_Fsqd;
	}

 	protected java.lang.Float pdbx_ls_sigma_I;


	/**
	 *  Data cutoff (SIGMA(I))
	 */
	public java.lang.Float getPdbx_ls_sigma_I() 
	{
		return pdbx_ls_sigma_I;
	}
 
	public void setPdbx_ls_sigma_I(java.lang.Float pdbx_ls_sigma_I)
	{
		this.pdbx_ls_sigma_I = pdbx_ls_sigma_I;
	}

 	protected java.lang.String pdbx_method_to_determine_struct;


	/**
	 *  Method(s) used to determine the structure.
	 *  AB INITIO PHASING
	 *  Direct Methods
	 *  DM
	 *  Iterative Single wavelength Anomalous Scattering
	 *  ISAS
	 *  Iterative Single Isomorphous Replacement
	 *  ISIR
	 *  Iterative Single Isomorphous Replacement with Anomalous Scattering
	 *  ISIRAS
	 *  Multi wavelength Anomalous Diffraction
	 *  MAD
	 *  Multiple Isomorphous Replacement
	 *  MIR
	 *  Multiple Isomorphous Replacement with Anomalous Scattering
	 *  MIRAS
	 *  Molecular Replacement
	 *  MR
	 *  Single Isomorphous Replacement
	 *  SIR
	 *  Single Isomorphous Replacement with Anomalous Scattering
	 *  SIRAS
	 */
	public java.lang.String getPdbx_method_to_determine_struct() 
	{
		return pdbx_method_to_determine_struct;
	}
 
	public void setPdbx_method_to_determine_struct(java.lang.String pdbx_method_to_determine_struct)
	{
		this.pdbx_method_to_determine_struct = pdbx_method_to_determine_struct;
	}

 	protected java.lang.Float pdbx_overall_ESU_R;


	/**
	 *  Overall estimated standard uncertainties of positional
	 *  parameters based on R value.
	 */
	public java.lang.Float getPdbx_overall_ESU_R() 
	{
		return pdbx_overall_ESU_R;
	}
 
	public void setPdbx_overall_ESU_R(java.lang.Float pdbx_overall_ESU_R)
	{
		this.pdbx_overall_ESU_R = pdbx_overall_ESU_R;
	}

 	protected java.lang.Float pdbx_overall_ESU_R_Free;


	/**
	 *  Overall estimated standard uncertainties of positional
	 *  parameters based on R value.
	 */
	public java.lang.Float getPdbx_overall_ESU_R_Free() 
	{
		return pdbx_overall_ESU_R_Free;
	}
 
	public void setPdbx_overall_ESU_R_Free(java.lang.Float pdbx_overall_ESU_R_Free)
	{
		this.pdbx_overall_ESU_R_Free = pdbx_overall_ESU_R_Free;
	}

 	protected java.lang.Float pdbx_pd_Fsqrd_R_factor;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute ls_d_res_high in category refine and
	 *  attribute ls_d_res_low in category refine and the observation limit established by
	 *  attribute observed_criterion.
	 *  in category reflns sum|F~obs~**2 - F~calc~**2|
	 *  R = ---------------------
	 *  sum|F~obs~**2|
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getPdbx_pd_Fsqrd_R_factor() 
	{
		return pdbx_pd_Fsqrd_R_factor;
	}
 
	public void setPdbx_pd_Fsqrd_R_factor(java.lang.Float pdbx_pd_Fsqrd_R_factor)
	{
		this.pdbx_pd_Fsqrd_R_factor = pdbx_pd_Fsqrd_R_factor;
	}

 	protected java.lang.Float pdbx_pd_Marquardt_correlation_coeff;


	/**
	 *  The correlation coefficient between the observed and
	 *  calculated structure factors for reflections included in
	 *  the refinement. This correlation factor is found in the
	 *  fitting using the Levenberg-Marquardt algorithm to search
	 *  for the minimum value of chisquare. Almost all computer
	 *  codes for Rietveld refinement employ the Gauss-Newton algorithm
	 *  to find parameters which minimize the weighted sum of squares
	 *  of the residuals.
	 *  A description of the equations is given on
	 *  http://www.water.hut.fi/~tkarvone/fr_org_s.htm
	 */
	public java.lang.Float getPdbx_pd_Marquardt_correlation_coeff() 
	{
		return pdbx_pd_Marquardt_correlation_coeff;
	}
 
	public void setPdbx_pd_Marquardt_correlation_coeff(java.lang.Float pdbx_pd_Marquardt_correlation_coeff)
	{
		this.pdbx_pd_Marquardt_correlation_coeff = pdbx_pd_Marquardt_correlation_coeff;
	}

 	protected java.lang.Integer pdbx_pd_ls_matrix_band_width;


	/**
	 *  The least squares refinement "band matrix" approximation to the full matrix.
	 */
	public java.lang.Integer getPdbx_pd_ls_matrix_band_width() 
	{
		return pdbx_pd_ls_matrix_band_width;
	}
 
	public void setPdbx_pd_ls_matrix_band_width(java.lang.Integer pdbx_pd_ls_matrix_band_width)
	{
		this.pdbx_pd_ls_matrix_band_width = pdbx_pd_ls_matrix_band_width;
	}

 	protected java.lang.Integer pdbx_pd_meas_number_of_points;


	/**
	 *  The total number of points in the measured
	 *  diffractogram.
	 */
	public java.lang.Integer getPdbx_pd_meas_number_of_points() 
	{
		return pdbx_pd_meas_number_of_points;
	}
 
	public void setPdbx_pd_meas_number_of_points(java.lang.Integer pdbx_pd_meas_number_of_points)
	{
		this.pdbx_pd_meas_number_of_points = pdbx_pd_meas_number_of_points;
	}

 	protected java.lang.Integer pdbx_pd_number_of_points;


	/**
	 *  The total number of data points in the processed diffractogram.
	 */
	public java.lang.Integer getPdbx_pd_number_of_points() 
	{
		return pdbx_pd_number_of_points;
	}
 
	public void setPdbx_pd_number_of_points(java.lang.Integer pdbx_pd_number_of_points)
	{
		this.pdbx_pd_number_of_points = pdbx_pd_number_of_points;
	}

 	protected java.lang.Integer pdbx_pd_number_of_powder_patterns;


	/**
	 *  The total number of powder patterns used.
	 */
	public java.lang.Integer getPdbx_pd_number_of_powder_patterns() 
	{
		return pdbx_pd_number_of_powder_patterns;
	}
 
	public void setPdbx_pd_number_of_powder_patterns(java.lang.Integer pdbx_pd_number_of_powder_patterns)
	{
		this.pdbx_pd_number_of_powder_patterns = pdbx_pd_number_of_powder_patterns;
	}

 	protected java.lang.Float pdbx_pd_proc_ls_prof_R_factor;


	/**
	 *  Rietveld/Profile fit R factors.
	 *  Note that the R factor computed for Rietveld refinements
	 *  using the extracted reflection intensity values (often
	 *  called the Rietveld or Bragg R factor, R~B~) is not properly
	 *  a profile R factor.
	 *  pdbx_pd_proc_ls_prof_R_factor, often called R~p~, is an
	 *  unweighted fitness metric for the agreement between the
	 *  observed and computed diffraction patterns
	 *  R~p~ = sum~i~ | I~obs~(i) - I~calc~(i) |
	 *  / sum~i~ ( I~obs~(i) )
	 *  Note that in the above equations,
	 *  w(i) is the weight for the ith data point
	 *  I~obs~(i) is the observed intensity for the ith data
	 *  point, sometimes referred to as y~i~(obs) or
	 *  y~oi~.
	 *  I~calc~(i) is the computed intensity for the ith data
	 *  point with background and other corrections
	 *  applied to match the scale of the observed dataset,
	 *  sometimes referred to as y~i~(calc) or
	 *  y~ci~.
	 *  n is the total number of data points (see  attribute pdbx_pd_number_of_points)
	 *  in category refine less the number of data points excluded from the refinement.
	 *  p is the total number of refined parameters.
	 */
	public java.lang.Float getPdbx_pd_proc_ls_prof_R_factor() 
	{
		return pdbx_pd_proc_ls_prof_R_factor;
	}
 
	public void setPdbx_pd_proc_ls_prof_R_factor(java.lang.Float pdbx_pd_proc_ls_prof_R_factor)
	{
		this.pdbx_pd_proc_ls_prof_R_factor = pdbx_pd_proc_ls_prof_R_factor;
	}

 	protected java.lang.Float pdbx_pd_proc_ls_prof_wR_factor;


	/**
	 *  Rietveld/Profile fit R factors.
	 *  Note that the R factor computed for Rietveld refinements
	 *  using the extracted reflection intensity values (often
	 *  called the Rietveld or Bragg R factor, R~B~) is not properly
	 *  a profile R factor.
	 *  pdbx_pd_proc_ls_prof_wR_factor often called R~wp~, is a
	 *  weighted fitness metric for the agreement between the
	 *  observed and computed diffraction patterns
	 *  R~wp~ = SQRT {
	 *  sum~i~ ( w(i) [ I~obs~(i) - I~calc~(i) ]^2^ )
	 *  / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }
	 *  Note that in the above equations,
	 *  w(i) is the weight for the ith data point
	 *  I~obs~(i) is the observed intensity for the ith data
	 *  point, sometimes referred to as y~i~(obs) or
	 *  y~oi~.
	 *  I~calc~(i) is the computed intensity for the ith data
	 *  point with background and other corrections
	 *  applied to match the scale of the observed dataset,
	 *  sometimes referred to as y~i~(calc) or
	 *  y~ci~.
	 *  n is the total number of data points (see  attribute pdbx_pd_number_of_points)
	 *  in category refine less the number of data points excluded from the refinement.
	 *  p is the total number of refined parameters.
	 */
	public java.lang.Float getPdbx_pd_proc_ls_prof_wR_factor() 
	{
		return pdbx_pd_proc_ls_prof_wR_factor;
	}
 
	public void setPdbx_pd_proc_ls_prof_wR_factor(java.lang.Float pdbx_pd_proc_ls_prof_wR_factor)
	{
		this.pdbx_pd_proc_ls_prof_wR_factor = pdbx_pd_proc_ls_prof_wR_factor;
	}

 	protected java.lang.Float pdbx_real_space_R;


	/**
	 *  Real space R factor of electron density for all atoms.
	 *  
	 *  The real space R factor is calculated by the equation
	 *  
	 *  R_real = [Sum~i (|Dobs - Dcal|)]/[Sum~i (|Dobs + Dcal|)]
	 *  
	 *  Where:
	 *  Dobs is the observed  electron density,
	 *  Dcal is the calculated  electron density,
	 *  summation is for all the grid points
	 *  
	 *  Ref: Branden, C.I. & Jones, T.A. (1990).  Nature, 343, 687-689
	 */
	public java.lang.Float getPdbx_real_space_R() 
	{
		return pdbx_real_space_R;
	}
 
	public void setPdbx_real_space_R(java.lang.Float pdbx_real_space_R)
	{
		this.pdbx_real_space_R = pdbx_real_space_R;
	}

 	protected java.lang.Float pdbx_solvent_ion_probe_radii;


	/**
	 *  CCP4 solvent ion proble radii
	 */
	public java.lang.Float getPdbx_solvent_ion_probe_radii() 
	{
		return pdbx_solvent_ion_probe_radii;
	}
 
	public void setPdbx_solvent_ion_probe_radii(java.lang.Float pdbx_solvent_ion_probe_radii)
	{
		this.pdbx_solvent_ion_probe_radii = pdbx_solvent_ion_probe_radii;
	}

 	protected java.lang.Float pdbx_solvent_shrinkage_radii;


	/**
	 *  CCP4 solvent shrinkage radii
	 */
	public java.lang.Float getPdbx_solvent_shrinkage_radii() 
	{
		return pdbx_solvent_shrinkage_radii;
	}
 
	public void setPdbx_solvent_shrinkage_radii(java.lang.Float pdbx_solvent_shrinkage_radii)
	{
		this.pdbx_solvent_shrinkage_radii = pdbx_solvent_shrinkage_radii;
	}

 	protected java.lang.Float pdbx_solvent_vdw_probe_radii;


	/**
	 *  CCP4 solvent proble van der Waals radii
	 */
	public java.lang.Float getPdbx_solvent_vdw_probe_radii() 
	{
		return pdbx_solvent_vdw_probe_radii;
	}
 
	public void setPdbx_solvent_vdw_probe_radii(java.lang.Float pdbx_solvent_vdw_probe_radii)
	{
		this.pdbx_solvent_vdw_probe_radii = pdbx_solvent_vdw_probe_radii;
	}

 	protected java.lang.String pdbx_starting_model;


	/**
	 *  Starting model for refinement.  Starting model for
	 *  molecular replacement should refer to a previous
	 *  structure or experiment.
	 *  BDL001
	 */
	public java.lang.String getPdbx_starting_model() 
	{
		return pdbx_starting_model;
	}
 
	public void setPdbx_starting_model(java.lang.String pdbx_starting_model)
	{
		this.pdbx_starting_model = pdbx_starting_model;
	}

 	protected java.lang.String pdbx_stereochem_target_val_spec_case;


	/**
	 *  Special case of stereochemistry target values used
	 *  in SHELXL refinement.
	 */
	public java.lang.String getPdbx_stereochem_target_val_spec_case() 
	{
		return pdbx_stereochem_target_val_spec_case;
	}
 
	public void setPdbx_stereochem_target_val_spec_case(java.lang.String pdbx_stereochem_target_val_spec_case)
	{
		this.pdbx_stereochem_target_val_spec_case = pdbx_stereochem_target_val_spec_case;
	}

 	protected java.lang.String pdbx_stereochemistry_target_values;


	/**
	 *  Stereochemistry target values used in refinement.
	 */
	public java.lang.String getPdbx_stereochemistry_target_values() 
	{
		return pdbx_stereochemistry_target_values;
	}
 
	public void setPdbx_stereochemistry_target_values(java.lang.String pdbx_stereochemistry_target_values)
	{
		this.pdbx_stereochemistry_target_values = pdbx_stereochemistry_target_values;
	}

 	protected java.lang.String solvent_model_details;


	/**
	 *  Special aspects of the solvent model used during refinement.
	 */
	public java.lang.String getSolvent_model_details() 
	{
		return solvent_model_details;
	}
 
	public void setSolvent_model_details(java.lang.String solvent_model_details)
	{
		this.solvent_model_details = solvent_model_details;
	}

 	protected java.lang.Float solvent_model_param_bsol;


	/**
	 *  The value of the BSOL solvent-model parameter describing
	 *  the average isotropic displacement parameter of disordered
	 *  solvent atoms.
	 *  
	 *  This is one of the two parameters (the other is
	 *  attribute solvent_model_param_ksol) in category refine in Tronrud's method of
	 *  modelling the contribution of bulk solvent to the
	 *  scattering. The standard scale factor is modified according
	 *  to the expression
	 *  
	 *  k0 exp(-B0 * s^2^)[1-KSOL * exp(-BSOL * s^2^)]
	 *  
	 *  where k0 and B0 are the scale factors for the protein.
	 *  
	 *  Ref: Tronrud, D. E. (1997). Methods Enzymol. 277, 243-268.
	 */
	public java.lang.Float getSolvent_model_param_bsol() 
	{
		return solvent_model_param_bsol;
	}
 
	public void setSolvent_model_param_bsol(java.lang.Float solvent_model_param_bsol)
	{
		this.solvent_model_param_bsol = solvent_model_param_bsol;
	}

 	protected java.lang.Float solvent_model_param_ksol;


	/**
	 *  The value of the KSOL solvent-model parameter describing
	 *  the ratio of the electron density in the bulk solvent to the
	 *  electron density in the molecular solute.
	 *  
	 *  This is one of the two parameters (the other is
	 *  attribute solvent_model_param_bsol) in category refine in Tronrud's method of
	 *  modelling the contribution of bulk solvent to the
	 *  scattering. The standard scale factor is modified according
	 *  to the expression
	 *  
	 *  k0 exp(-B0 * s^2^)[1-KSOL * exp(-BSOL * s^2^)]
	 *  
	 *  where k0 and B0 are the scale factors for the protein.
	 *  
	 *  Ref: Tronrud, D. E. (1997). Methods Enzymol. 277, 243-268.
	 */
	public java.lang.Float getSolvent_model_param_ksol() 
	{
		return solvent_model_param_ksol;
	}
 
	public void setSolvent_model_param_ksol(java.lang.Float solvent_model_param_ksol)
	{
		this.solvent_model_param_ksol = solvent_model_param_ksol;
	}

 }
