package org.pdb.beans;

/**
 *  Data items in the REFINE_ANALYZE category record details
 *  about the refined structure that are often used to analyze the
 *  refinement and assess its quality. A given computer program
 *  may or may not produce values corresponding to these data
 *  names.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_analyzeCategory>
 *  <PDBx:refine_analyze entry_id="5HVP">
 *  <PDBx:Luzzati_coordinate_error_obs>0.056</PDBx:Luzzati_coordinate_error_obs>
 *  <PDBx:Luzzati_d_res_low_obs>2.51</PDBx:Luzzati_d_res_low_obs>
 *  </PDBx:refine_analyze>
 *  </PDBx:refine_analyzeCategory>
 * </pre>
 */
public class Refine_analyze 
{
		protected java.lang.Float Luzzati_coordinate_error_free;


	/**
	 *  The estimated coordinate error obtained from the plot of
	 *  the R value versus sin(theta)/lambda for the reflections
	 *  treated as a test set during refinement.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_coordinate_error_free() 
	{
		return Luzzati_coordinate_error_free;
	}
 
	public void setLuzzati_coordinate_error_free(java.lang.Float Luzzati_coordinate_error_free)
	{
		this.Luzzati_coordinate_error_free = Luzzati_coordinate_error_free;
	}

 	protected java.lang.Float Luzzati_coordinate_error_obs;


	/**
	 *  The estimated coordinate error obtained from the plot of
	 *  the R value versus sin(theta)/lambda for reflections classified
	 *  as observed.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_coordinate_error_obs() 
	{
		return Luzzati_coordinate_error_obs;
	}
 
	public void setLuzzati_coordinate_error_obs(java.lang.Float Luzzati_coordinate_error_obs)
	{
		this.Luzzati_coordinate_error_obs = Luzzati_coordinate_error_obs;
	}

 	protected java.lang.Float Luzzati_d_res_low_free;


	/**
	 *  The value of the low-resolution cutoff used in constructing the
	 *  Luzzati plot for reflections treated as a test set during
	 *  refinement.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_d_res_low_free() 
	{
		return Luzzati_d_res_low_free;
	}
 
	public void setLuzzati_d_res_low_free(java.lang.Float Luzzati_d_res_low_free)
	{
		this.Luzzati_d_res_low_free = Luzzati_d_res_low_free;
	}

 	protected java.lang.Float Luzzati_d_res_low_obs;


	/**
	 *  The value of the low-resolution cutoff used in
	 *  constructing the Luzzati plot for reflections classified as
	 *  observed.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_d_res_low_obs() 
	{
		return Luzzati_d_res_low_obs;
	}
 
	public void setLuzzati_d_res_low_obs(java.lang.Float Luzzati_d_res_low_obs)
	{
		this.Luzzati_d_res_low_obs = Luzzati_d_res_low_obs;
	}

 	protected java.lang.Float Luzzati_sigma_a_free;


	/**
	 *  The value of sigma~a~ used in constructing the Luzzati plot for
	 *  the reflections treated as a test set during refinement.
	 *  Details of the estimation of sigma~a~ can be specified
	 *  in  attribute Luzzati_sigma_a_free_details.
	 *  in category refine_analyze
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_sigma_a_free() 
	{
		return Luzzati_sigma_a_free;
	}
 
	public void setLuzzati_sigma_a_free(java.lang.Float Luzzati_sigma_a_free)
	{
		this.Luzzati_sigma_a_free = Luzzati_sigma_a_free;
	}

 	protected java.lang.String Luzzati_sigma_a_free_details;


	/**
	 *  Details of the estimation of sigma~a~ for the reflections
	 *  treated as a test set during refinement.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.String getLuzzati_sigma_a_free_details() 
	{
		return Luzzati_sigma_a_free_details;
	}
 
	public void setLuzzati_sigma_a_free_details(java.lang.String Luzzati_sigma_a_free_details)
	{
		this.Luzzati_sigma_a_free_details = Luzzati_sigma_a_free_details;
	}

 	protected java.lang.Float Luzzati_sigma_a_obs;


	/**
	 *  The value of sigma~a~ used in constructing the Luzzati plot for
	 *  reflections classified as observed. Details of the
	 *  estimation of sigma~a~ can be specified in
	 *  attribute Luzzati_sigma_a_obs_details.
	 *  in category refine_analyze
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.Float getLuzzati_sigma_a_obs() 
	{
		return Luzzati_sigma_a_obs;
	}
 
	public void setLuzzati_sigma_a_obs(java.lang.Float Luzzati_sigma_a_obs)
	{
		this.Luzzati_sigma_a_obs = Luzzati_sigma_a_obs;
	}

 	protected java.lang.String Luzzati_sigma_a_obs_details;


	/**
	 *  Special aspects of the estimation of sigma~a~ for the
	 *  reflections classified as observed.
	 *  
	 *  Ref:  Luzzati, V. (1952). Traitement statistique des erreurs
	 *  dans la determination des structures cristallines. Acta
	 *  Cryst. 5, 802-810.
	 */
	public java.lang.String getLuzzati_sigma_a_obs_details() 
	{
		return Luzzati_sigma_a_obs_details;
	}
 
	public void setLuzzati_sigma_a_obs_details(java.lang.String Luzzati_sigma_a_obs_details)
	{
		this.Luzzati_sigma_a_obs_details = Luzzati_sigma_a_obs_details;
	}

 	protected java.lang.Float RG_d_res_high;


	/**
	 *  The value of the high-resolution cutoff in angstroms
	 *  used in the calculation of the Hamilton generalized
	 *  R factor (RG) stored in  attribute RG_work in category refine_analyze and
	 *  attribute RG_free.
	 *  in category refine_analyze
	 *  Ref: Hamilton, W. C. (1965). Acta Cryst. 18, 502-510.
	 */
	public java.lang.Float getRG_d_res_high() 
	{
		return RG_d_res_high;
	}
 
	public void setRG_d_res_high(java.lang.Float RG_d_res_high)
	{
		this.RG_d_res_high = RG_d_res_high;
	}

 	protected java.lang.Float RG_d_res_low;


	/**
	 *  The value of the low-resolution cutoff in angstroms
	 *  used in the calculation of the Hamilton generalized
	 *  R factor (RG) stored in  attribute RG_work in category refine_analyze and
	 *  attribute RG_free.
	 *  in category refine_analyze
	 *  Ref: Hamilton, W. C. (1965). Acta Cryst. 18, 502-510.
	 */
	public java.lang.Float getRG_d_res_low() 
	{
		return RG_d_res_low;
	}
 
	public void setRG_d_res_low(java.lang.Float RG_d_res_low)
	{
		this.RG_d_res_low = RG_d_res_low;
	}

 	protected java.lang.Float RG_free;


	/**
	 *  The Hamilton generalized R factor for all reflections that
	 *  satisfy the resolution limits established by
	 *  attribute RG_d_res_high in category refine_analyze and
	 *  attribute RG_d_res_low in category refine_analyze for the free R set of
	 *  reflections that were excluded from the refinement.
	 *  
	 *  sum_i sum_j w_{i,j}(|Fobs|_i - G|Fcalc|_i)(|Fobs|_j - G|Fcalc|_j)
	 *  RG = Sqrt( ----------------------------------------------------------------- )
	 *  sum_i sum_j w_{i,j} |Fobs|_i |Fobs|_j
	 *  
	 *  where
	 *  
	 *  |Fobs|  = the observed structure-factor amplitudes
	 *  |Fcalc| = the calculated structure-factor amplitudes
	 *  G       = the scale factor which puts |Fcalc| on the
	 *  same scale as |Fobs|
	 *  w_{i,j} = the weight for the combination of the reflections
	 *  i and j.
	 *  
	 *  sum_i and sum_j are taken over the specified reflections
	 *  
	 *  When the covariance of the amplitudes of reflection i and
	 *  reflection j is zero (i.e. the reflections are independent)
	 *  w{i,i} can be redefined as  w_i and the nested sums collapsed
	 *  into one sum.
	 *  
	 *  sum_i w_i(|Fobs|_i - G|Fcalc|_i)^2
	 *  RG = Sqrt( ----------------------------------- )
	 *  sum_i w_i |Fobs|_i^2
	 *  
	 *  Ref: Hamilton, W. C. (1965). Acta Cryst. 18, 502-510.
	 */
	public java.lang.Float getRG_free() 
	{
		return RG_free;
	}
 
	public void setRG_free(java.lang.Float RG_free)
	{
		this.RG_free = RG_free;
	}

 	protected java.lang.Float RG_free_work_ratio;


	/**
	 *  The observed ratio of RGfree to RGwork. The expected RG ratio
	 *  is the value that should be achievable at the end of a structure
	 *  refinement when only random uncorrelated errors exist in the data
	 *  and the model provided that the observations are properly
	 *  weighted. When compared with the observed RG ratio it may
	 *  indicate that a structure has not reached convergence or a
	 *  model has been over-refined with no corresponding improvement
	 *  in the model.
	 *  
	 *  In an unrestrained refinement, the ratio of RGfree to RGwork with
	 *  only random uncorrelated errors at convergence depends only
	 *  on the number of reflections and the number of parameters
	 *  according to
	 *  
	 *  sqrt[(f + m) / (f - m) ]
	 *  
	 *  where f = the number of included structure amplitudes and
	 *  target distances, and
	 *  m = the number of parameters being refined.
	 *  
	 *  In the restrained case, RGfree is calculated from a random
	 *  selection of residuals including both structure amplitudes
	 *  and restraints.  When restraints are included in the refinement,
	 *  the RG ratio requires a term for the contribution to the
	 *  minimized residual at convergence, D~restr~, due to those
	 *  restraints:
	 *  
	 *  D~restr~ = r - sum [w_i . (a_i)^t . (H)^-1 a_i]
	 *  
	 *  where
	 *  
	 *  r is the number of geometrical, displacement-parameter and
	 *  other restraints
	 *  H is the (m,m) normal matrix given by A^t.W.A
	 *  W is the (n,n) symmetric weight matrix of the included
	 *  observations
	 *  A is the least-squares design matrix of derivatives of
	 *  order (n,m)
	 *  a_i is the ith row of A
	 *  
	 *  Then the expected RGratio becomes
	 *  
	 *  sqrt [ (f + (m - r + D~restr~))/ (f - (m - r + D~restr~)) ]
	 *  
	 *  There is no data name for the expected value of RGfree/RGwork yet.
	 *  
	 *  Ref: Tickle, I. J., Laskowski, R. A. & Moss, D. S. (1998).
	 *  Acta Cryst. D54, 547-557.
	 */
	public java.lang.Float getRG_free_work_ratio() 
	{
		return RG_free_work_ratio;
	}
 
	public void setRG_free_work_ratio(java.lang.Float RG_free_work_ratio)
	{
		this.RG_free_work_ratio = RG_free_work_ratio;
	}

 	protected java.lang.Float RG_work;


	/**
	 *  The Hamilton generalized R factor for all reflections
	 *  that satisfy the resolution limits established by
	 *  attribute RG_d_res_high in category refine_analyze and
	 *  attribute RG_d_res_low in category refine_analyze and for those
	 *  reflections included in the working set when a free R set
	 *  of reflections is omitted from the refinement.
	 *  
	 *  sum_i sum_j w_{i,j}(|Fobs|_i - G|Fcalc|_i)(|Fobs|_j - G|Fcalc|_j)
	 *  RG = Sqrt( ----------------------------------------------------------------- )
	 *  sum_i sum_j w_{i,j} |Fobs|_i |Fobs|_j
	 *  
	 *  where
	 *  
	 *  |Fobs|  = the observed structure-factor amplitudes
	 *  |Fcalc| = the calculated structure-factor amplitudes
	 *  G       = the scale factor which puts |Fcalc| on the
	 *  same scale as |Fobs|
	 *  w_{i,j} = the weight for the combination of the reflections
	 *  i and j.
	 *  
	 *  sum_i and sum_j are taken over the specified reflections
	 *  
	 *  When the covariance of the amplitudes of reflection i and
	 *  reflection j is zero (i.e. the reflections are independent)
	 *  w{i,i} can be redefined as w_i and the nested sums collapsed
	 *  into one sum.
	 *  
	 *  sum_i w_i(|Fobs|_i - G|Fcalc|_i)^2
	 *  RG = Sqrt( ----------------------------------- )
	 *  sum_i w_i |Fobs|_i^2
	 *  
	 *  Ref: Hamilton, W. C. (1965). Acta Cryst. 18, 502-510.
	 */
	public java.lang.Float getRG_work() 
	{
		return RG_work;
	}
 
	public void setRG_work(java.lang.Float RG_work)
	{
		this.RG_work = RG_work;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float number_disordered_residues;


	/**
	 *  The number of discretely disordered residues in the refined
	 *  model.
	 */
	public java.lang.Float getNumber_disordered_residues() 
	{
		return number_disordered_residues;
	}
 
	public void setNumber_disordered_residues(java.lang.Float number_disordered_residues)
	{
		this.number_disordered_residues = number_disordered_residues;
	}

 	protected java.lang.Float occupancy_sum_hydrogen;


	/**
	 *  The sum of the occupancies of the hydrogen atoms in the refined
	 *  model.
	 */
	public java.lang.Float getOccupancy_sum_hydrogen() 
	{
		return occupancy_sum_hydrogen;
	}
 
	public void setOccupancy_sum_hydrogen(java.lang.Float occupancy_sum_hydrogen)
	{
		this.occupancy_sum_hydrogen = occupancy_sum_hydrogen;
	}

 	protected java.lang.Float occupancy_sum_non_hydrogen;


	/**
	 *  The sum of the occupancies of the non-hydrogen atoms in the
	 *  refined model.
	 */
	public java.lang.Float getOccupancy_sum_non_hydrogen() 
	{
		return occupancy_sum_non_hydrogen;
	}
 
	public void setOccupancy_sum_non_hydrogen(java.lang.Float occupancy_sum_non_hydrogen)
	{
		this.occupancy_sum_non_hydrogen = occupancy_sum_non_hydrogen;
	}

 	protected java.lang.Float pdbx_Luzzati_d_res_high_obs;


	/**
	 *  record the high resolution for calculating Luzzati statistics.
	 */
	public java.lang.Float getPdbx_Luzzati_d_res_high_obs() 
	{
		return pdbx_Luzzati_d_res_high_obs;
	}
 
	public void setPdbx_Luzzati_d_res_high_obs(java.lang.Float pdbx_Luzzati_d_res_high_obs)
	{
		this.pdbx_Luzzati_d_res_high_obs = pdbx_Luzzati_d_res_high_obs;
	}

 }
