package org.pdb.beans;

/**
 *  Data items in the REFINE_HIST category record details about the
 *  steps during the refinement of the structure.
 *  These data items are not meant to be as thorough a description
 *  of the refinement as is provided for the final model in other
 *  categories; rather, these data items provide a mechanism for
 *  sketching out the progress of the refinement, supported by a
 *  small set of representative statistics.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide [(POG)4 EKG (POG)5]3.
 *  <PDBx:refine_histCategory>
 *  <PDBx:refine_hist cycle_id="C134">
 *  <PDBx:d_res_high>1.85</PDBx:d_res_high>
 *  <PDBx:d_res_low>20.0</PDBx:d_res_low>
 *  <PDBx:number_atoms_solvent>217</PDBx:number_atoms_solvent>
 *  <PDBx:number_atoms_total>808</PDBx:number_atoms_total>
 *  <PDBx:number_reflns_all>6174</PDBx:number_reflns_all>
 *  <PDBx:number_reflns_obs>4886</PDBx:number_reflns_obs>
 *  <PDBx:number_reflns_R_free>476</PDBx:number_reflns_R_free>
 *  <PDBx:number_reflns_R_work>4410</PDBx:number_reflns_R_work>
 *  <PDBx:R_factor_all>.265</PDBx:R_factor_all>
 *  <PDBx:R_factor_obs>.195</PDBx:R_factor_obs>
 *  <PDBx:R_factor_R_free>.274</PDBx:R_factor_R_free>
 *  <PDBx:R_factor_R_work>.160</PDBx:R_factor_R_work>
 *  <PDBx:details> Add majority of solvent molecules. B factors refined by
 *  group. Continued to remove misplaced water molecules.</PDBx:details>
 *  </PDBx:refine_hist>
 *  </PDBx:refine_histCategory>
 * </pre>
 */
public class Refine_hist 
{
		protected java.lang.Float R_factor_R_free;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the test reflections (i.e. were excluded from the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor. Details of how reflections were assigned to the
	 *  working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_R_free() 
	{
		return R_factor_R_free;
	}
 
	public void setR_factor_R_free(java.lang.Float R_factor_R_free)
	{
		this.R_factor_R_free = R_factor_R_free;
	}

 	protected java.lang.Float R_factor_R_work;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the working reflections (i.e. were included in the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor. Details of how reflections were assigned to the
	 *  working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_R_work() 
	{
		return R_factor_R_work;
	}
 
	public void setR_factor_R_work(java.lang.Float R_factor_R_work)
	{
		this.R_factor_R_work = R_factor_R_work;
	}

 	protected java.lang.Float R_factor_all;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low.
	 *  in category refine_hist
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_all() 
	{
		return R_factor_all;
	}
 
	public void setR_factor_all(java.lang.Float R_factor_all)
	{
		this.R_factor_all = R_factor_all;
	}

 	protected java.lang.Float R_factor_obs;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation criterion
	 *  established by  attribute observed_criterion.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_obs() 
	{
		return R_factor_obs;
	}
 
	public void setR_factor_obs(java.lang.Float R_factor_obs)
	{
		this.R_factor_obs = R_factor_obs;
	}

 	protected java.lang.String cycle_id;


	/**
	 *  The value of  attribute cycle_id in category refine_hist must uniquely identify a
	 *  record in the REFINE_HIST list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getCycle_id() 
	{
		return cycle_id;
	}
 
	public void setCycle_id(java.lang.String cycle_id)
	{
		this.cycle_id = cycle_id;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data for this cycle of refinement. This is called
	 *  the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data for this cycle of refinement. This is
	 *  called the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of this cycle of the refinement
	 *  process.
	 *  Residues 13-17 fit and added to model;
	 *  substantial rebuilding of loop containing
	 *  residues 43-48; addition of first atoms to
	 *  solvent model; ten cycles of Prolsq
	 *  refinement.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Integer number_atoms_solvent;


	/**
	 *  The number of solvent atoms that were included in the model at
	 *  this cycle of the refinement.
	 */
	public java.lang.Integer getNumber_atoms_solvent() 
	{
		return number_atoms_solvent;
	}
 
	public void setNumber_atoms_solvent(java.lang.Integer number_atoms_solvent)
	{
		this.number_atoms_solvent = number_atoms_solvent;
	}

 	protected java.lang.Integer number_atoms_total;


	/**
	 *  The total number of atoms that were included in the model at
	 *  this cycle of the refinement.
	 */
	public java.lang.Integer getNumber_atoms_total() 
	{
		return number_atoms_total;
	}
 
	public void setNumber_atoms_total(java.lang.Integer number_atoms_total)
	{
		this.number_atoms_total = number_atoms_total;
	}

 	protected java.lang.Integer number_reflns_R_free;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the test reflections (i.e. were excluded from the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor. Details of how reflections were assigned to the
	 *  working and test sets are given in  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_R_free() 
	{
		return number_reflns_R_free;
	}
 
	public void setNumber_reflns_R_free(java.lang.Integer number_reflns_R_free)
	{
		this.number_reflns_R_free = number_reflns_R_free;
	}

 	protected java.lang.Integer number_reflns_R_work;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the working reflections (i.e. were included in the
	 *  refinement) when the refinement included the calculation
	 *  of a 'free' R factor. Details of how reflections were
	 *  assigned to the working and test sets are given in
	 *  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_R_work() 
	{
		return number_reflns_R_work;
	}
 
	public void setNumber_reflns_R_work(java.lang.Integer number_reflns_R_work)
	{
		this.number_reflns_R_work = number_reflns_R_work;
	}

 	protected java.lang.Integer number_reflns_all;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist.
	 */
	public java.lang.Integer getNumber_reflns_all() 
	{
		return number_reflns_all;
	}
 
	public void setNumber_reflns_all(java.lang.Integer number_reflns_all)
	{
		this.number_reflns_all = number_reflns_all;
	}

 	protected java.lang.Integer number_reflns_obs;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_hist and
	 *  attribute d_res_low in category refine_hist and the observation criterion
	 *  established by  attribute observed_criterion in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_obs() 
	{
		return number_reflns_obs;
	}
 
	public void setNumber_reflns_obs(java.lang.Integer number_reflns_obs)
	{
		this.number_reflns_obs = number_reflns_obs;
	}

 	protected java.lang.Integer pdbx_number_atoms_carb;


	/**
	 *  Number of carbohydrate atoms included in refinement
	 */
	public java.lang.Integer getPdbx_number_atoms_carb() 
	{
		return pdbx_number_atoms_carb;
	}
 
	public void setPdbx_number_atoms_carb(java.lang.Integer pdbx_number_atoms_carb)
	{
		this.pdbx_number_atoms_carb = pdbx_number_atoms_carb;
	}

 	protected java.lang.Integer pdbx_number_atoms_ligand;


	/**
	 *  Number of ligand atoms included in refinement
	 */
	public java.lang.Integer getPdbx_number_atoms_ligand() 
	{
		return pdbx_number_atoms_ligand;
	}
 
	public void setPdbx_number_atoms_ligand(java.lang.Integer pdbx_number_atoms_ligand)
	{
		this.pdbx_number_atoms_ligand = pdbx_number_atoms_ligand;
	}

 	protected java.lang.Integer pdbx_number_atoms_lipid;


	/**
	 *  Number of lipid atoms included in refinement
	 */
	public java.lang.Integer getPdbx_number_atoms_lipid() 
	{
		return pdbx_number_atoms_lipid;
	}
 
	public void setPdbx_number_atoms_lipid(java.lang.Integer pdbx_number_atoms_lipid)
	{
		this.pdbx_number_atoms_lipid = pdbx_number_atoms_lipid;
	}

 	protected java.lang.Integer pdbx_number_atoms_nucleic_acid;


	/**
	 *  Number of nucleic atoms included in refinement
	 */
	public java.lang.Integer getPdbx_number_atoms_nucleic_acid() 
	{
		return pdbx_number_atoms_nucleic_acid;
	}
 
	public void setPdbx_number_atoms_nucleic_acid(java.lang.Integer pdbx_number_atoms_nucleic_acid)
	{
		this.pdbx_number_atoms_nucleic_acid = pdbx_number_atoms_nucleic_acid;
	}

 	protected java.lang.Integer pdbx_number_atoms_protein;


	/**
	 *  Number of protein atoms included in refinement
	 */
	public java.lang.Integer getPdbx_number_atoms_protein() 
	{
		return pdbx_number_atoms_protein;
	}
 
	public void setPdbx_number_atoms_protein(java.lang.Integer pdbx_number_atoms_protein)
	{
		this.pdbx_number_atoms_protein = pdbx_number_atoms_protein;
	}

 	protected java.lang.String pdbx_pseudo_atom_details;


	/**
	 *  Details of pseduo atoms used to model unexplained density
	 */
	public java.lang.String getPdbx_pseudo_atom_details() 
	{
		return pdbx_pseudo_atom_details;
	}
 
	public void setPdbx_pseudo_atom_details(java.lang.String pdbx_pseudo_atom_details)
	{
		this.pdbx_pseudo_atom_details = pdbx_pseudo_atom_details;
	}

 }
