package org.pdb.beans;

/**
 *  Data items in the REFINE_LS_RESTR category record details about
 *  the restraints applied to various classes of parameters during
 *  the least-squares refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr type="bond_d">
 *  <PDBx:dev_ideal_target>0.020</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.018</PDBx:dev_ideal>
 *  <PDBx:number>1654</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>22</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="angle_d">
 *  <PDBx:dev_ideal_target>0.030</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.038</PDBx:dev_ideal>
 *  <PDBx:number>2246</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>139</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar_d">
 *  <PDBx:dev_ideal_target>0.040</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.043</PDBx:dev_ideal>
 *  <PDBx:number>498</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>21</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar">
 *  <PDBx:dev_ideal_target>0.020</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.015</PDBx:dev_ideal>
 *  <PDBx:number>270</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>1</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="chiral">
 *  <PDBx:dev_ideal_target>0.150</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.177</PDBx:dev_ideal>
 *  <PDBx:number>278</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>2</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="singtor_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.216</PDBx:dev_ideal>
 *  <PDBx:number>582</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="multtor_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.207</PDBx:dev_ideal>
 *  <PDBx:number>419</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="xyhbond_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.245</PDBx:dev_ideal>
 *  <PDBx:number>149</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar_tor">
 *  <PDBx:dev_ideal_target>3.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>2.6</PDBx:dev_ideal>
 *  <PDBx:number>203</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>9</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="staggered_tor">
 *  <PDBx:dev_ideal_target>15.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>17.4</PDBx:dev_ideal>
 *  <PDBx:number>298</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>31</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="orthonormal_tor">
 *  <PDBx:dev_ideal_target>20.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>18.1</PDBx:dev_ideal>
 *  <PDBx:number>12</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>1</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  </PDBx:refine_ls_restrCategory>
 * </pre>
 */
public class Refine_ls_restr 
{
		protected java.lang.String criterion;


	/**
	 *  A criterion used to define a parameter value that deviates
	 *  significantly from its ideal value in the model obtained by
	 *  restrained least-squares refinement.
	 *  > 3\s
	 */
	public java.lang.String getCriterion() 
	{
		return criterion;
	}
 
	public void setCriterion(java.lang.String criterion)
	{
		this.criterion = criterion;
	}

 	protected java.lang.Float dev_ideal;


	/**
	 *  For the given parameter type, the root-mean-square deviation
	 *  between the ideal values used as restraints in the least-squares
	 *  refinement and the values obtained by refinement. For instance,
	 *  bond distances may deviate by 0.018 \%A (r.m.s.) from ideal
	 *  values in the current model.
	 */
	public java.lang.Float getDev_ideal() 
	{
		return dev_ideal;
	}
 
	public void setDev_ideal(java.lang.Float dev_ideal)
	{
		this.dev_ideal = dev_ideal;
	}

 	protected java.lang.Float dev_ideal_target;


	/**
	 *  For the given parameter type, the target root-mean-square
	 *  deviation between the ideal values used as restraints in the
	 *  least-squares refinement and the values obtained by refinement.
	 */
	public java.lang.Float getDev_ideal_target() 
	{
		return dev_ideal_target;
	}
 
	public void setDev_ideal_target(java.lang.Float dev_ideal_target)
	{
		this.dev_ideal_target = dev_ideal_target;
	}

 	protected java.lang.Integer number;


	/**
	 *  The number of parameters of this type subjected to restraint in
	 *  least-squares refinement.
	 */
	public java.lang.Integer getNumber() 
	{
		return number;
	}
 
	public void setNumber(java.lang.Integer number)
	{
		this.number = number;
	}

 	protected java.lang.Integer rejects;


	/**
	 *  The number of parameters of this type that deviate from ideal
	 *  values by more than the amount defined in
	 *  attribute criterion in category refine_ls_restr in the model obtained by restrained
	 *  least-squares refinement.
	 */
	public java.lang.Integer getRejects() 
	{
		return rejects;
	}
 
	public void setRejects(java.lang.Integer rejects)
	{
		this.rejects = rejects;
	}

 	protected java.lang.String type;


	/**
	 *  The type of the parameter being restrained.
	 *  Explicit sets of data values are provided for the programs
	 *  PROTIN/PROLSQ (beginning with p_) and RESTRAIN (beginning with
	 *  RESTRAIN_). As computer programs change, these data values
	 *  are given as examples, not as an enumeration list. Computer
	 *  programs that convert a data block to a refinement table will
	 *  expect the exact form of the data values given here to be used.
	 *  bond distance
	 *  p_bond_d
	 *  bond angle expressed as a distance
	 *  p_angle_d
	 *  planar 1,4 distance
	 *  p_planar_d
	 *  X-H bond distance
	 *  p_xhbond_d
	 *  X-H bond angle expressed as a distance
	 *  p_xhangle_d
	 *  hydrogen distance
	 *  p_hydrog_d
	 *  special distance
	 *  p_special_d
	 *  planes
	 *  p_planar
	 *  chiral centres
	 *  p_chiral
	 *  single-torsion non-bonded contact
	 *  p_singtor_nbd
	 *  multiple-torsion non-bonded contact
	 *  p_multtor_nbd
	 *  possible (X...Y) hydrogen bond
	 *  p_xyhbond_nbd
	 *  possible (X-H...Y) hydrogen bond
	 *  p_xhyhbond_nbd
	 *  special torsion angle
	 *  p_special_tor
	 *  planar torsion angle
	 *  p_planar_tor
	 *  staggered torsion angle
	 *  p_staggered_tor
	 *  orthonormal torsion angle
	 *  p_orthonormal_tor
	 *  main-chain bond isotropic displacement parameter
	 *  p_mcbond_it
	 *  main-chain angle isotropic displacement parameter
	 *  p_mcangle_it
	 *  side-chain bond isotropic displacement parameter
	 *  p_scbond_it
	 *  side-chain angle isotropic displacement parameter
	 *  p_scangle_it
	 *  X-H bond isotropic displacement parameter
	 *  p_xhbond_it
	 *  X-H angle isotropic displacement parameter
	 *  p_xhangle_it
	 *  special isotropic displacement parameter
	 *  p_special_it
	 *  The root-mean-square deviation
	 *  of the difference between the values calculated from the structures
	 *  used to compile the restraints dictionary parameters and the dictionary
	 *  values themselves in the distance range less than 2.12 Angstroms.
	 *  RESTRAIN_Distances < 2.12
	 *  The root-mean-square deviation
	 *  of the difference between the values calculated from the structures
	 *  used to compile the restraints dictionary parameters and the dictionary
	 *  values themselves in the distance range 2.12 - 2.625 Angstroms.
	 *  RESTRAIN_Distances 2.12 < D < 2.625
	 *  The root-mean-square deviation
	 *  of the difference between the values calculated from the structures
	 *  used to compile the restraints dictionary parameters and the dictionary
	 *  values themselves in the distance range greater than 2.625 Angstroms.
	 *  RESTRAIN_Distances > 2.625
	 *  The root-mean-square deviation
	 *  of the difference between the values calculated from the structures
	 *  used to compile the restraints dictionary parameters and the dictionary
	 *  values themselves for peptide planes.
	 *  RESTRAIN_Peptide Planes
	 *  The root-mean-square deviation
	 *  of the difference between the values calculated from the structures
	 *  used to compile the restraints dictionary parameters and the dictionary
	 *  values themselves for rings and planes other than peptide planes.
	 *  RESTRAIN_Ring and other planes
	 *  RESTRAIN_rms diffs for Uiso atoms at dist 1.2-1.4
	 *  RESTRAIN_rms diffs for Uiso atoms at dist 1.4-1.6
	 *  RESTRAIN_rms diffs for Uiso atoms at dist 1.8-2.0
	 *  RESTRAIN_rms diffs for Uiso atoms at dist 2.0-2.2
	 *  RESTRAIN_rms diffs for Uiso atoms at dist 2.2-2.4
	 *  RESTRAIN_rms diffs for Uiso atoms at dist >2.4
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.Float weight;


	/**
	 *  The weighting value applied to this type of restraint in
	 *  the least-squares refinement.
	 */
	public java.lang.Float getWeight() 
	{
		return weight;
	}
 
	public void setWeight(java.lang.Float weight)
	{
		this.weight = weight;
	}

 }
