package org.pdb.beans;

/**
 *  Data items in the REFINE_LS_RESTR_TYPE category record details
 *  about the restraint types used in the least-squares refinement.
 *  
 * <pre>
 *  Example 1 - based on RESTRAIN refinement for the CCP4 test data set
 *  toxd.
 *  <PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances &lt; 2.12">
 *  <PDBx:number>509</PDBx:number>
 *  <PDBx:dev_ideal>0.005</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.022</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances 2.12 &lt; D &lt; 2.625">
 *  <PDBx:number>671</PDBx:number>
 *  <PDBx:dev_ideal>0.016</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.037</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances &gt; 2.625">
 *  <PDBx:number>39</PDBx:number>
 *  <PDBx:dev_ideal>0.034</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.043</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Peptide Planes">
 *  <PDBx:number>59</PDBx:number>
 *  <PDBx:dev_ideal>0.002</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.010</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Ring and other planes">
 *  <PDBx:number>26</PDBx:number>
 *  <PDBx:dev_ideal>0.014</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.010</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.2-1.4">
 *  <PDBx:number>212</PDBx:number>
 *  <PDBx:dev_ideal>0.106</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.4-1.6">
 *  <PDBx:number>288</PDBx:number>
 *  <PDBx:dev_ideal>0.101</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.8-2.0">
 *  <PDBx:number>6</PDBx:number>
 *  <PDBx:dev_ideal>0.077</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 2.0-2.2">
 *  <PDBx:number>10</PDBx:number>
 *  <PDBx:dev_ideal>0.114</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 2.2-2.4">
 *  <PDBx:number>215</PDBx:number>
 *  <PDBx:dev_ideal>0.119</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist &gt;2.4">
 *  <PDBx:number>461</PDBx:number>
 *  <PDBx:dev_ideal>0.106</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  </PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr_typeCategory>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances &lt; 2.12">
 *  <PDBx:distance_cutoff_high>2.12</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances 2.12 &lt; D &lt; 2.625">
 *  <PDBx:distance_cutoff_low>2.12</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.625</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances &gt; 2.625">
 *  <PDBx:distance_cutoff_low>2.625</PDBx:distance_cutoff_low>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.2-1.4">
 *  <PDBx:distance_cutoff_low>1.2</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>1.4</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.4-1.6">
 *  <PDBx:distance_cutoff_low>1.4</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>1.6</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.8-2.0">
 *  <PDBx:distance_cutoff_low>1.8</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.0</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 2.0-2.2">
 *  <PDBx:distance_cutoff_low>2.0</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.2</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 2.2-2.4">
 *  <PDBx:distance_cutoff_low>2.2</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.4</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist &gt;2.4">
 *  <PDBx:distance_cutoff_low>2.4</PDBx:distance_cutoff_low>
 *  </PDBx:refine_ls_restr_type>
 *  </PDBx:refine_ls_restr_typeCategory>
 * </pre>
 */
public class Refine_ls_restr_type 
{
		protected java.lang.Float distance_cutoff_high;


	/**
	 *  The upper limit in angstroms of the distance range applied to
	 *  the current restraint type.
	 */
	public java.lang.Float getDistance_cutoff_high() 
	{
		return distance_cutoff_high;
	}
 
	public void setDistance_cutoff_high(java.lang.Float distance_cutoff_high)
	{
		this.distance_cutoff_high = distance_cutoff_high;
	}

 	protected java.lang.Float distance_cutoff_low;


	/**
	 *  The lower limit in angstroms of the distance range applied to
	 *  the current restraint type.
	 */
	public java.lang.Float getDistance_cutoff_low() 
	{
		return distance_cutoff_low;
	}
 
	public void setDistance_cutoff_low(java.lang.Float distance_cutoff_low)
	{
		this.distance_cutoff_low = distance_cutoff_low;
	}

 	protected java.lang.String type;


	/**
	 *  This data item is a pointer to  attribute type in category refine_ls_restr in the
	 *  REFINE_LS_RESTR category.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
