package org.pdb.beans;

/**
 *  Data items in the REFINE_LS_SHELL category record details about
 *  the results of the least-squares refinement broken down into
 *  shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_ls_shellCategory>
 *  <PDBx:refine_ls_shell d_res_low="8.00" d_res_high="4.51">
 *  <PDBx:number_reflns_obs>1226</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.196</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="4.51" d_res_high="3.48">
 *  <PDBx:number_reflns_obs>1679</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.146</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="3.48" d_res_high="2.94">
 *  <PDBx:number_reflns_obs>2014</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.160</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.94" d_res_high="2.59">
 *  <PDBx:number_reflns_obs>2147</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.182</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.59" d_res_high="2.34">
 *  <PDBx:number_reflns_obs>2127</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.193</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.34" d_res_high="2.15">
 *  <PDBx:number_reflns_obs>2061</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.203</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.15" d_res_high="2.00">
 *  <PDBx:number_reflns_obs>1647</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.188</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  </PDBx:refine_ls_shellCategory>
 * </pre>
 */
public class Refine_ls_shell 
{
		protected java.lang.Float R_factor_R_free;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were
	 *  used as the test reflections (i.e. were excluded from the
	 *  refinement) when the refinement included the calculation
	 *  of a 'free' R factor. Details of how reflections were assigned
	 *  to the working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_R_free() 
	{
		return R_factor_R_free;
	}
 
	public void setR_factor_R_free(java.lang.Float R_factor_R_free)
	{
		this.R_factor_R_free = R_factor_R_free;
	}

 	protected java.lang.Float R_factor_R_free_error;


	/**
	 *  The estimated error in  attribute R_factor_R_free.
	 *  in category refine_ls_shell The method used to estimate the error is described in the
	 *  item  attribute ls_R_factor_R_free_error_details in category refine.
	 */
	public java.lang.Float getR_factor_R_free_error() 
	{
		return R_factor_R_free_error;
	}
 
	public void setR_factor_R_free_error(java.lang.Float R_factor_R_free_error)
	{
		this.R_factor_R_free_error = R_factor_R_free_error;
	}

 	protected java.lang.Float R_factor_R_work;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the working reflections (i.e. were included in the
	 *  refinement) when the refinement included the calculation of
	 *  a 'free' R factor. Details of how reflections were assigned
	 *  to the working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_R_work() 
	{
		return R_factor_R_work;
	}
 
	public void setR_factor_R_work(java.lang.Float R_factor_R_work)
	{
		this.R_factor_R_work = R_factor_R_work;
	}

 	protected java.lang.Float R_factor_all;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low.
	 *  in category refine_ls_shell
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_all() 
	{
		return R_factor_all;
	}
 
	public void setR_factor_all(java.lang.Float R_factor_all)
	{
		this.R_factor_all = R_factor_all;
	}

 	protected java.lang.Float R_factor_obs;


	/**
	 *  Residual factor R for reflections that satisfy the resolution
	 *  limits established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation criterion
	 *  established by  attribute observed_criterion.
	 *  in category reflns
	 *  sum|F~obs~ - F~calc~|
	 *  R = ---------------------
	 *  sum|F~obs~|
	 *  
	 *  F~obs~  = the observed structure-factor amplitudes
	 *  F~calc~ = the calculated structure-factor amplitudes
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getR_factor_obs() 
	{
		return R_factor_obs;
	}
 
	public void setR_factor_obs(java.lang.Float R_factor_obs)
	{
		this.R_factor_obs = R_factor_obs;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data in this shell. This is called
	 *  the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data in this shell. This is called the lowest
	 *  resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Integer number_reflns_R_free;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the test reflections (i.e. were excluded from the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor. Details of how reflections were assigned to the
	 *  working and test sets are given in  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_R_free() 
	{
		return number_reflns_R_free;
	}
 
	public void setNumber_reflns_R_free(java.lang.Integer number_reflns_R_free)
	{
		this.number_reflns_R_free = number_reflns_R_free;
	}

 	protected java.lang.Integer number_reflns_R_work;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the working reflections (i.e. were included in the
	 *  refinement) when the refinement included the calculation of
	 *  a 'free' R factor. Details of how reflections were assigned
	 *  to the working and test sets are given in  attribute R_free_details in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_R_work() 
	{
		return number_reflns_R_work;
	}
 
	public void setNumber_reflns_R_work(java.lang.Integer number_reflns_R_work)
	{
		this.number_reflns_R_work = number_reflns_R_work;
	}

 	protected java.lang.Integer number_reflns_all;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell.
	 */
	public java.lang.Integer getNumber_reflns_all() 
	{
		return number_reflns_all;
	}
 
	public void setNumber_reflns_all(java.lang.Integer number_reflns_all)
	{
		this.number_reflns_all = number_reflns_all;
	}

 	protected java.lang.Integer number_reflns_obs;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation criterion
	 *  established by  attribute observed_criterion in category reflns.
	 */
	public java.lang.Integer getNumber_reflns_obs() 
	{
		return number_reflns_obs;
	}
 
	public void setNumber_reflns_obs(java.lang.Integer number_reflns_obs)
	{
		this.number_reflns_obs = number_reflns_obs;
	}

 	protected java.lang.Integer pdbx_total_number_of_bins_used;


	/**
	 *  Total number of bins used.
	 */
	public java.lang.Integer getPdbx_total_number_of_bins_used() 
	{
		return pdbx_total_number_of_bins_used;
	}
 
	public void setPdbx_total_number_of_bins_used(java.lang.Integer pdbx_total_number_of_bins_used)
	{
		this.pdbx_total_number_of_bins_used = pdbx_total_number_of_bins_used;
	}

 	protected java.lang.Float percent_reflns_R_free;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the test reflections (i.e. were excluded from the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor, expressed as a percentage of the number of
	 *  geometrically observable reflections that satisfy the
	 *  reflection limits.
	 */
	public java.lang.Float getPercent_reflns_R_free() 
	{
		return percent_reflns_R_free;
	}
 
	public void setPercent_reflns_R_free(java.lang.Float percent_reflns_R_free)
	{
		this.percent_reflns_R_free = percent_reflns_R_free;
	}

 	protected java.lang.Float percent_reflns_obs;


	/**
	 *  The number of reflections that satisfy the resolution limits
	 *  established by  attribute d_res_high in category refine_ls_shell and
	 *  attribute d_res_low in category refine_ls_shell and the observation criterion
	 *  established by  attribute observed_criterion in category reflns expressed as a
	 *  percentage of the number of geometrically observable
	 *  reflections that satisfy the resolution limits.
	 */
	public java.lang.Float getPercent_reflns_obs() 
	{
		return percent_reflns_obs;
	}
 
	public void setPercent_reflns_obs(java.lang.Float percent_reflns_obs)
	{
		this.percent_reflns_obs = percent_reflns_obs;
	}

 	protected java.lang.Float redundancy_reflns_all;


	/**
	 *  The ratio of the total number of observations of the reflections
	 *  that satisfy the resolution limits established by
	 *  _refine_ls_shell.d_res_high and _refine_ls_shell.d_res_low
	 *  to the number of crystallographically unique reflections that
	 *  satisfy the same limits.
	 */
	public java.lang.Float getRedundancy_reflns_all() 
	{
		return redundancy_reflns_all;
	}
 
	public void setRedundancy_reflns_all(java.lang.Float redundancy_reflns_all)
	{
		this.redundancy_reflns_all = redundancy_reflns_all;
	}

 	protected java.lang.Float redundancy_reflns_obs;


	/**
	 *  The ratio of the total number of observations of the
	 *  reflections that satisfy the resolution limits established by
	 *  _refine_ls_shell.d_res_high and _refine_ls_shell.d_res_low and
	 *  the observation criterion established by
	 *  attribute observed_criterion in category reflns to the number of crystallographically
	 *  unique reflections that satisfy the same limits.
	 */
	public java.lang.Float getRedundancy_reflns_obs() 
	{
		return redundancy_reflns_obs;
	}
 
	public void setRedundancy_reflns_obs(java.lang.Float redundancy_reflns_obs)
	{
		this.redundancy_reflns_obs = redundancy_reflns_obs;
	}

 	protected java.lang.Float wR_factor_R_free;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high
	 *  in category refine_ls_shell and  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the test reflections (i.e. were excluded from the refinement)
	 *  when the refinement included the calculation of a 'free'
	 *  R factor. Details of how reflections were assigned to the
	 *  working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getWR_factor_R_free() 
	{
		return wR_factor_R_free;
	}
 
	public void setWR_factor_R_free(java.lang.Float wR_factor_R_free)
	{
		this.wR_factor_R_free = wR_factor_R_free;
	}

 	protected java.lang.Float wR_factor_R_work;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high
	 *  in category refine_ls_shell and  attribute d_res_low in category refine_ls_shell and the observation limit
	 *  established by  attribute observed_criterion in category reflns and that were used
	 *  as the working reflections (i.e. were included in the
	 *  refinement) when the refinement included the calculation of
	 *  a 'free' R factor. Details of how reflections were assigned
	 *  to the working and test sets are given in  attribute R_free_details.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getWR_factor_R_work() 
	{
		return wR_factor_R_work;
	}
 
	public void setWR_factor_R_work(java.lang.Float wR_factor_R_work)
	{
		this.wR_factor_R_work = wR_factor_R_work;
	}

 	protected java.lang.Float wR_factor_all;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high
	 *  in category refine_ls_shell and  attribute d_res_low.
	 *  in category refine_ls_shell
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getWR_factor_all() 
	{
		return wR_factor_all;
	}
 
	public void setWR_factor_all(java.lang.Float wR_factor_all)
	{
		this.wR_factor_all = wR_factor_all;
	}

 	protected java.lang.Float wR_factor_obs;


	/**
	 *  Weighted residual factor wR for reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high
	 *  in category refine_ls_shell and  attribute d_res_low in category refine_ls_shell and the observation criterion
	 *  established by  attribute observed_criterion.
	 *  in category reflns
	 *  ( sum|w |Y~obs~ - Y~calc~|^2^| )^1/2^
	 *  wR = ( ---------------------------- )
	 *  (        sum|w Y~obs~^2^|      )
	 *  
	 *  Y~obs~  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y~calc~ = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getWR_factor_obs() 
	{
		return wR_factor_obs;
	}
 
	public void setWR_factor_obs(java.lang.Float wR_factor_obs)
	{
		this.wR_factor_obs = wR_factor_obs;
	}

 }
