package org.pdb.beans;

/**
 *  Data items in the REFINE_OCCUPANCY category record details
 *  about the treatment of atom occupancies during refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_occupancyCategory>
 *  <PDBx:refine_occupancy class="protein">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>1.00</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="solvent">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>1.00</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="inhibitor orientation 1">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>0.65</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="inhibitor orientation 2">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>0.35</PDBx:value>
 *  <PDBx:details> The inhibitor binds to the enzyme in two alternative
 *  conformations. The occupancy of each conformation was
 *  adjusted so as to result in approximately equal mean
 *  thermal factors for the atoms in each conformation.</PDBx:details>
 *  </PDBx:refine_occupancy>
 *  </PDBx:refine_occupancyCategory>
 * </pre>
 */
public class Refine_occupancy 
{
		protected java.lang.String class_;


	/**
	 *  The class of atoms treated similarly for occupancy refinement.
	 *  all
	 *  protein
	 *  solvent
	 *  sugar-phosphate backbone
	 */
	public java.lang.String getClass_() 
	{
		return class_;
	}
 
	public void setClass_(java.lang.String class_)
	{
		this.class_ = class_;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the occupancy refinement for
	 *  a class of atoms described in  attribute class in category refine_occupancy.
	 *  The inhibitor binds to the enzyme in two
	 *  alternative conformations. The occupancy of
	 *  each conformation was adjusted so as to result
	 *  in approximately equal mean thermal factors
	 *  for the atoms in each conformation.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String treatment;


	/**
	 *  The treatment of occupancies for a class of atoms
	 *  described in  attribute class in category refine_occupancy.
	 */
	public java.lang.String getTreatment() 
	{
		return treatment;
	}
 
	public void setTreatment(java.lang.String treatment)
	{
		this.treatment = treatment;
	}

 	protected java.lang.Float value;


	/**
	 *  The value of occupancy assigned to a class of atoms defined in
	 *  attribute class in category refine_occupancy.  Meaningful only for atoms with fixed
	 *  occupancy.
	 *  1.0
	 *  0.41
	 */
	public java.lang.Float getValue() 
	{
		return value;
	}
 
	public void setValue(java.lang.Float value)
	{
		this.value = value;
	}

 }
