package org.pdb.beans;

/**
 *  Data items in the REFLN category record details about the
 *  reflection data used to determine the ATOM_SITE data items.
 *  
 *  The REFLN data items refer to individual reflections and must
 *  be included in looped lists.
 *  
 *  The REFLNS data items specify the parameters that apply to all
 *  reflections. The REFLNS data items are not looped.
 *  
 * <pre>
 *  Example 1 - based on data set fetod of Todres, Yanovsky, Ermekov & Struchkov
 *  [Acta Cryst. (1993), C49, 1352-1354].
 *  <PDBx:reflnCategory>
 *  <PDBx:refln index_h="2" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>85.57</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>58.90</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>1.45</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="3" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>15718.18</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>15631.06</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>30.40</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="4" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>55613.11</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>49840.09</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>61.86</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="5" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>246.85</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>241.86</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>10.02</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="6" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>82.16</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>69.97</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>1.93</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="7" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>1133.62</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>947.79</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>11.78</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="8" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>2558.04</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>2453.33</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>20.44</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="9" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>283.88</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>393.66</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>7.79</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="10" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>283.70</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>171.98</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>4.26</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  </PDBx:reflnCategory>
 * </pre>
 */
public class Refln 
{
		protected java.lang.Float A_calc;


	/**
	 *  The calculated value of structure-factor component A in
	 *  electrons.
	 *  
	 *  A = |F|cos(phase)
	 */
	public java.lang.Float getA_calc() 
	{
		return A_calc;
	}
 
	public void setA_calc(java.lang.Float A_calc)
	{
		this.A_calc = A_calc;
	}

 	protected java.lang.Float A_calc_au;


	/**
	 *  The calculated value of structure-factor component A in
	 *  arbitrary units.
	 *  
	 *  A = |F|cos(phase)
	 */
	public java.lang.Float getA_calc_au() 
	{
		return A_calc_au;
	}
 
	public void setA_calc_au(java.lang.Float A_calc_au)
	{
		this.A_calc_au = A_calc_au;
	}

 	protected java.lang.Float A_meas;


	/**
	 *  The measured value of structure-factor component A in electrons.
	 *  
	 *  A = |F|cos(phase)
	 */
	public java.lang.Float getA_meas() 
	{
		return A_meas;
	}
 
	public void setA_meas(java.lang.Float A_meas)
	{
		this.A_meas = A_meas;
	}

 	protected java.lang.Float A_meas_au;


	/**
	 *  The measured value of structure-factor component A in
	 *  arbitrary units.
	 *  
	 *  A = |F|cos(phase)
	 */
	public java.lang.Float getA_meas_au() 
	{
		return A_meas_au;
	}
 
	public void setA_meas_au(java.lang.Float A_meas_au)
	{
		this.A_meas_au = A_meas_au;
	}

 	protected java.lang.Float B_calc;


	/**
	 *  The calculated value of structure-factor component B in
	 *  electrons.
	 *  
	 *  B = |F|sin(phase)
	 */
	public java.lang.Float getB_calc() 
	{
		return B_calc;
	}
 
	public void setB_calc(java.lang.Float B_calc)
	{
		this.B_calc = B_calc;
	}

 	protected java.lang.Float B_calc_au;


	/**
	 *  The calculated value of structure-factor component B in
	 *  arbitrary units.
	 *  
	 *  B = |F|sin(phase)
	 */
	public java.lang.Float getB_calc_au() 
	{
		return B_calc_au;
	}
 
	public void setB_calc_au(java.lang.Float B_calc_au)
	{
		this.B_calc_au = B_calc_au;
	}

 	protected java.lang.Float B_meas;


	/**
	 *  The measured value of structure-factor component B in electrons.
	 *  
	 *  B = |F|sin(phase)
	 */
	public java.lang.Float getB_meas() 
	{
		return B_meas;
	}
 
	public void setB_meas(java.lang.Float B_meas)
	{
		this.B_meas = B_meas;
	}

 	protected java.lang.Float B_meas_au;


	/**
	 *  The measured value of structure-factor component B in
	 *  arbitrary units.
	 *  
	 *  B = |F|sin(phase)
	 */
	public java.lang.Float getB_meas_au() 
	{
		return B_meas_au;
	}
 
	public void setB_meas_au(java.lang.Float B_meas_au)
	{
		this.B_meas_au = B_meas_au;
	}

 	protected java.lang.Float F_calc;


	/**
	 *  The calculated value of the structure factor in electrons.
	 */
	public java.lang.Float getF_calc() 
	{
		return F_calc;
	}
 
	public void setF_calc(java.lang.Float F_calc)
	{
		this.F_calc = F_calc;
	}

 	protected java.lang.Float F_calc_au;


	/**
	 *  The calculated value of the structure factor in arbitrary
	 *  units.
	 */
	public java.lang.Float getF_calc_au() 
	{
		return F_calc_au;
	}
 
	public void setF_calc_au(java.lang.Float F_calc_au)
	{
		this.F_calc_au = F_calc_au;
	}

 	protected java.lang.Float F_meas;


	/**
	 *  The measured value of the structure factor in electrons.
	 */
	public java.lang.Float getF_meas() 
	{
		return F_meas;
	}
 
	public void setF_meas(java.lang.Float F_meas)
	{
		this.F_meas = F_meas;
	}

 	protected java.lang.Float F_meas_au;


	/**
	 *  The measured value of the structure factor in arbitrary units.
	 */
	public java.lang.Float getF_meas_au() 
	{
		return F_meas_au;
	}
 
	public void setF_meas_au(java.lang.Float F_meas_au)
	{
		this.F_meas_au = F_meas_au;
	}

 	protected java.lang.Float F_meas_sigma;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  attribute F_meas in category refln in electrons.
	 */
	public java.lang.Float getF_meas_sigma() 
	{
		return F_meas_sigma;
	}
 
	public void setF_meas_sigma(java.lang.Float F_meas_sigma)
	{
		this.F_meas_sigma = F_meas_sigma;
	}

 	protected java.lang.Float F_meas_sigma_au;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  attribute F_meas_au in category refln in arbitrary units.
	 */
	public java.lang.Float getF_meas_sigma_au() 
	{
		return F_meas_sigma_au;
	}
 
	public void setF_meas_sigma_au(java.lang.Float F_meas_sigma_au)
	{
		this.F_meas_sigma_au = F_meas_sigma_au;
	}

 	protected java.lang.Float F_squared_calc;


	/**
	 *  The calculated value of the squared structure factor in
	 *  electrons squared.
	 */
	public java.lang.Float getF_squared_calc() 
	{
		return F_squared_calc;
	}
 
	public void setF_squared_calc(java.lang.Float F_squared_calc)
	{
		this.F_squared_calc = F_squared_calc;
	}

 	protected java.lang.Float F_squared_meas;


	/**
	 *  The measured value of the squared structure factor in electrons
	 *  squared.
	 */
	public java.lang.Float getF_squared_meas() 
	{
		return F_squared_meas;
	}
 
	public void setF_squared_meas(java.lang.Float F_squared_meas)
	{
		this.F_squared_meas = F_squared_meas;
	}

 	protected java.lang.Float F_squared_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  squared structure factor in electrons squared.
	 */
	public java.lang.Float getF_squared_sigma() 
	{
		return F_squared_sigma;
	}
 
	public void setF_squared_sigma(java.lang.Float F_squared_sigma)
	{
		this.F_squared_sigma = F_squared_sigma;
	}

 	protected java.lang.String class_code;


	/**
	 *  The code identifying the class to which this reflection has been
	 *  assigned. This code must match a value of  attribute code.
	 *  in category reflns_class Reflections may be grouped into classes for a variety of
	 *  purposes. For example, for modulated structures each reflection
	 *  class may be defined by the number m=sum|m~i~|, where the m~i~
	 *  are the integer coefficients that, in addition to h,k,l, index
	 *  the corresponding diffraction vector in the basis defined
	 *  for the reciprocal lattice.
	 */
	public java.lang.String getClass_code() 
	{
		return class_code;
	}
 
	public void setClass_code(java.lang.String class_code)
	{
		this.class_code = class_code;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.Float d_spacing;


	/**
	 *  The d spacing in angstroms for this reflection. This is related
	 *  to the (sin theta)/lambda value by the expression
	 *  attribute d_spacing in category refln = 2/(_refln.sint/lambda).
	 */
	public java.lang.Float getD_spacing() 
	{
		return d_spacing;
	}
 
	public void setD_spacing(java.lang.Float d_spacing)
	{
		this.d_spacing = d_spacing;
	}

 	protected java.lang.Float fom;


	/**
	 *  The figure of merit m for this reflection.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  int is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFom() 
	{
		return fom;
	}
 
	public void setFom(java.lang.Float fom)
	{
		this.fom = fom;
	}

 	protected java.lang.String include_status;


	/**
	 *  Classification of a reflection so as to indicate its status with
	 *  respect to inclusion in the refinement and the calculation of
	 *  R factors.
	 */
	public java.lang.String getInclude_status() 
	{
		return include_status;
	}
 
	public void setInclude_status(java.lang.String include_status)
	{
		this.include_status = include_status;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of the reflection. The values of the Miller
	 *  indices in the REFLN category must correspond to the cell
	 *  defined by cell lengths and cell angles in the CELL category.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of the reflection. The values of the Miller
	 *  indices in the REFLN category must correspond to the cell
	 *  defined by cell lengths and cell angles in the CELL category.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of the reflection. The values of the Miller
	 *  indices in the REFLN category must correspond to the cell
	 *  defined by cell lengths and cell angles in the CELL category.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float intensity_calc;


	/**
	 *  The calculated value of the intensity in the same units as
	 *  attribute intensity_meas in category refln.
	 */
	public java.lang.Float getIntensity_calc() 
	{
		return intensity_calc;
	}
 
	public void setIntensity_calc(java.lang.Float intensity_calc)
	{
		this.intensity_calc = intensity_calc;
	}

 	protected java.lang.Float intensity_meas;


	/**
	 *  The measured value of the intensity.
	 */
	public java.lang.Float getIntensity_meas() 
	{
		return intensity_meas;
	}
 
	public void setIntensity_meas(java.lang.Float intensity_meas)
	{
		this.intensity_meas = intensity_meas;
	}

 	protected java.lang.Float intensity_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  intensity in the same units as  attribute intensity_meas in category refln.
	 */
	public java.lang.Float getIntensity_sigma() 
	{
		return intensity_sigma;
	}
 
	public void setIntensity_sigma(java.lang.Float intensity_sigma)
	{
		this.intensity_sigma = intensity_sigma;
	}

 	protected java.lang.Float mean_path_length_tbar;


	/**
	 *  Mean path length in millimetres through the crystal for this
	 *  reflection.
	 */
	public java.lang.Float getMean_path_length_tbar() 
	{
		return mean_path_length_tbar;
	}
 
	public void setMean_path_length_tbar(java.lang.Float mean_path_length_tbar)
	{
		this.mean_path_length_tbar = mean_path_length_tbar;
	}

 	protected java.lang.Float pdbx_F_calc_part_solvent;


	/**
	 *  The calculated value of the structure factor in arbitrary
	 *  units reflecting only the contribution of the solvent model.
	 */
	public java.lang.Float getPdbx_F_calc_part_solvent() 
	{
		return pdbx_F_calc_part_solvent;
	}
 
	public void setPdbx_F_calc_part_solvent(java.lang.Float pdbx_F_calc_part_solvent)
	{
		this.pdbx_F_calc_part_solvent = pdbx_F_calc_part_solvent;
	}

 	protected java.lang.Float pdbx_F_calc_with_solvent;


	/**
	 *  The calculated value of the structure factor in arbitrary
	 *  units including the contribution of the solvent model.
	 */
	public java.lang.Float getPdbx_F_calc_with_solvent() 
	{
		return pdbx_F_calc_with_solvent;
	}
 
	public void setPdbx_F_calc_with_solvent(java.lang.Float pdbx_F_calc_with_solvent)
	{
		this.pdbx_F_calc_with_solvent = pdbx_F_calc_with_solvent;
	}

 	protected java.lang.Float pdbx_F_minus;


	/**
	 *  The structure factor F(-h,-k,-l) of the Friedel pair.
	 */
	public java.lang.Float getPdbx_F_minus() 
	{
		return pdbx_F_minus;
	}
 
	public void setPdbx_F_minus(java.lang.Float pdbx_F_minus)
	{
		this.pdbx_F_minus = pdbx_F_minus;
	}

 	protected java.lang.Float pdbx_F_minus_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  structure factor F(-h,-k,-l) of the Friedel pair.
	 */
	public java.lang.Float getPdbx_F_minus_sigma() 
	{
		return pdbx_F_minus_sigma;
	}
 
	public void setPdbx_F_minus_sigma(java.lang.Float pdbx_F_minus_sigma)
	{
		this.pdbx_F_minus_sigma = pdbx_F_minus_sigma;
	}

 	protected java.lang.Float pdbx_F_plus;


	/**
	 *  The structure factor F(h,k,l) of the Friedel pair.
	 */
	public java.lang.Float getPdbx_F_plus() 
	{
		return pdbx_F_plus;
	}
 
	public void setPdbx_F_plus(java.lang.Float pdbx_F_plus)
	{
		this.pdbx_F_plus = pdbx_F_plus;
	}

 	protected java.lang.Float pdbx_F_plus_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  structure factor F(h,k,l) of the Friedel pair.
	 */
	public java.lang.Float getPdbx_F_plus_sigma() 
	{
		return pdbx_F_plus_sigma;
	}
 
	public void setPdbx_F_plus_sigma(java.lang.Float pdbx_F_plus_sigma)
	{
		this.pdbx_F_plus_sigma = pdbx_F_plus_sigma;
	}

 	protected java.lang.Float pdbx_HL_A_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient A~iso~ for this
	 *  reflection.
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getPdbx_HL_A_iso() 
	{
		return pdbx_HL_A_iso;
	}
 
	public void setPdbx_HL_A_iso(java.lang.Float pdbx_HL_A_iso)
	{
		this.pdbx_HL_A_iso = pdbx_HL_A_iso;
	}

 	protected java.lang.Float pdbx_HL_B_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient B~iso~ for this
	 *  reflection.
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getPdbx_HL_B_iso() 
	{
		return pdbx_HL_B_iso;
	}
 
	public void setPdbx_HL_B_iso(java.lang.Float pdbx_HL_B_iso)
	{
		this.pdbx_HL_B_iso = pdbx_HL_B_iso;
	}

 	protected java.lang.Float pdbx_HL_C_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient C~iso~ for this
	 *  reflection.
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getPdbx_HL_C_iso() 
	{
		return pdbx_HL_C_iso;
	}
 
	public void setPdbx_HL_C_iso(java.lang.Float pdbx_HL_C_iso)
	{
		this.pdbx_HL_C_iso = pdbx_HL_C_iso;
	}

 	protected java.lang.Float pdbx_HL_D_iso;


	/**
	 *  The isomorphous Hendrickson-Lattman coefficient D~iso~ for this
	 *  reflection.
	 *  
	 *  Ref: Hendrickson, W. A. & Lattman, E. E. (1970). Acta
	 *  Cryst. B26, 136-143.
	 */
	public java.lang.Float getPdbx_HL_D_iso() 
	{
		return pdbx_HL_D_iso;
	}
 
	public void setPdbx_HL_D_iso(java.lang.Float pdbx_HL_D_iso)
	{
		this.pdbx_HL_D_iso = pdbx_HL_D_iso;
	}

 	protected java.lang.Float pdbx_I_minus;


	/**
	 *  The intensity of the I(-h,-k,-l) partner
	 *  of the Friedel pair.
	 */
	public java.lang.Float getPdbx_I_minus() 
	{
		return pdbx_I_minus;
	}
 
	public void setPdbx_I_minus(java.lang.Float pdbx_I_minus)
	{
		this.pdbx_I_minus = pdbx_I_minus;
	}

 	protected java.lang.Float pdbx_I_minus_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  intensity I(-h,-k,-l) partner of the Friedel pair.
	 */
	public java.lang.Float getPdbx_I_minus_sigma() 
	{
		return pdbx_I_minus_sigma;
	}
 
	public void setPdbx_I_minus_sigma(java.lang.Float pdbx_I_minus_sigma)
	{
		this.pdbx_I_minus_sigma = pdbx_I_minus_sigma;
	}

 	protected java.lang.Float pdbx_I_plus;


	/**
	 *  The intensity of the I(h,k,l) partner of
	 *  the Friedel pair.
	 */
	public java.lang.Float getPdbx_I_plus() 
	{
		return pdbx_I_plus;
	}
 
	public void setPdbx_I_plus(java.lang.Float pdbx_I_plus)
	{
		this.pdbx_I_plus = pdbx_I_plus;
	}

 	protected java.lang.Float pdbx_I_plus_sigma;


	/**
	 *  The standard uncertainty (derived from measurement) of the
	 *  intensity I(h,k,l) partner of the Friedel pair.
	 */
	public java.lang.Float getPdbx_I_plus_sigma() 
	{
		return pdbx_I_plus_sigma;
	}
 
	public void setPdbx_I_plus_sigma(java.lang.Float pdbx_I_plus_sigma)
	{
		this.pdbx_I_plus_sigma = pdbx_I_plus_sigma;
	}

 	protected java.lang.Float pdbx_anom_difference;


	/**
	 *  The amplitude difference of the Friedel pair,
	 *  D(hkl) = F(hkl) - F(-h-k-l).
	 */
	public java.lang.Float getPdbx_anom_difference() 
	{
		return pdbx_anom_difference;
	}
 
	public void setPdbx_anom_difference(java.lang.Float pdbx_anom_difference)
	{
		this.pdbx_anom_difference = pdbx_anom_difference;
	}

 	protected java.lang.Float pdbx_anom_difference_sigma;


	/**
	 *  The the standard deviation of the amplitude difference
	 *  of the Friedel pair,  D(hkl) = F(hkl) - F(-h-k-l).
	 */
	public java.lang.Float getPdbx_anom_difference_sigma() 
	{
		return pdbx_anom_difference_sigma;
	}
 
	public void setPdbx_anom_difference_sigma(java.lang.Float pdbx_anom_difference_sigma)
	{
		this.pdbx_anom_difference_sigma = pdbx_anom_difference_sigma;
	}

 	protected java.lang.Float pdbx_phase_calc_part_solvent;


	/**
	 *  The calculated structure-factor phase in degrees reflecting
	 *  only the contribution of the solvent model.
	 */
	public java.lang.Float getPdbx_phase_calc_part_solvent() 
	{
		return pdbx_phase_calc_part_solvent;
	}
 
	public void setPdbx_phase_calc_part_solvent(java.lang.Float pdbx_phase_calc_part_solvent)
	{
		this.pdbx_phase_calc_part_solvent = pdbx_phase_calc_part_solvent;
	}

 	protected java.lang.Float pdbx_phase_calc_with_solvent;


	/**
	 *  The calculated structure-factor phase in degrees including
	 *  the contribution of the solvent model.
	 */
	public java.lang.Float getPdbx_phase_calc_with_solvent() 
	{
		return pdbx_phase_calc_with_solvent;
	}
 
	public void setPdbx_phase_calc_with_solvent(java.lang.Float pdbx_phase_calc_with_solvent)
	{
		this.pdbx_phase_calc_with_solvent = pdbx_phase_calc_with_solvent;
	}

 	protected java.lang.Float phase_calc;


	/**
	 *  The calculated structure-factor phase in degrees.
	 */
	public java.lang.Float getPhase_calc() 
	{
		return phase_calc;
	}
 
	public void setPhase_calc(java.lang.Float phase_calc)
	{
		this.phase_calc = phase_calc;
	}

 	protected java.lang.Float phase_meas;


	/**
	 *  The measured structure-factor phase in degrees.
	 */
	public java.lang.Float getPhase_meas() 
	{
		return phase_meas;
	}
 
	public void setPhase_meas(java.lang.Float phase_meas)
	{
		this.phase_meas = phase_meas;
	}

 	protected java.lang.String refinement_status;


	/**
	 *  Status of a reflection in the structure-refinement process.
	 */
	public java.lang.String getRefinement_status() 
	{
		return refinement_status;
	}
 
	public void setRefinement_status(java.lang.String refinement_status)
	{
		this.refinement_status = refinement_status;
	}

 	protected java.lang.String scale_group_code;


	/**
	 *  This data item is a pointer to  attribute group_code in category reflns_scale in the
	 *  REFLNS_SCALE category.
	 */
	public java.lang.String getScale_group_code() 
	{
		return scale_group_code;
	}
 
	public void setScale_group_code(java.lang.String scale_group_code)
	{
		this.scale_group_code = scale_group_code;
	}

 	protected java.lang.Float sint_over_lambda;


	/**
	 *  The (sin theta)/lambda value in reciprocal angstroms for this
	 *  reflection.
	 */
	public java.lang.Float getSint_over_lambda() 
	{
		return sint_over_lambda;
	}
 
	public void setSint_over_lambda(java.lang.Float sint_over_lambda)
	{
		this.sint_over_lambda = sint_over_lambda;
	}

 	protected java.lang.String status;


	/**
	 *  Classification of a reflection so as to indicate its status with
	 *  respect to inclusion in the refinement and the calculation of
	 *  R factors.
	 */
	public java.lang.String getStatus() 
	{
		return status;
	}
 
	public void setStatus(java.lang.String status)
	{
		this.status = status;
	}

 	protected java.lang.Integer symmetry_epsilon;


	/**
	 *  The symmetry reinforcement factor corresponding to the number of
	 *  times the reflection indices are generated identically from the
	 *  space-group symmetry operations.
	 */
	public java.lang.Integer getSymmetry_epsilon() 
	{
		return symmetry_epsilon;
	}
 
	public void setSymmetry_epsilon(java.lang.Integer symmetry_epsilon)
	{
		this.symmetry_epsilon = symmetry_epsilon;
	}

 	protected java.lang.Integer symmetry_multiplicity;


	/**
	 *  The number of symmetry-equivalent reflections. The equivalent
	 *  reflections have the same structure-factor magnitudes because
	 *  of the space-group symmetry and the Friedel relationship.
	 */
	public java.lang.Integer getSymmetry_multiplicity() 
	{
		return symmetry_multiplicity;
	}
 
	public void setSymmetry_multiplicity(java.lang.Integer symmetry_multiplicity)
	{
		this.symmetry_multiplicity = symmetry_multiplicity;
	}

 	protected java.lang.Float wavelength;


	/**
	 *  The mean wavelength in angstroms of radiation used to measure
	 *  this reflection. This is an important parameter for data
	 *  collected using energy-dispersive detectors or the Laue
	 *  method.
	 */
	public java.lang.Float getWavelength() 
	{
		return wavelength;
	}
 
	public void setWavelength(java.lang.Float wavelength)
	{
		this.wavelength = wavelength;
	}

 	protected java.lang.String wavelength_id;


	/**
	 *  This data item is a pointer to  attribute wavelength_id in category diffrn_radiation in
	 *  the DIFFRN_RADIATION category.
	 */
	public java.lang.String getWavelength_id() 
	{
		return wavelength_id;
	}
 
	public void setWavelength_id(java.lang.String wavelength_id)
	{
		this.wavelength_id = wavelength_id;
	}

 }
