package org.pdb.beans;

/**
 *  Data items in the REFLN_SYS_ABS category record details about
 *  the reflection data that should be systematically absent,
 *  given the designated space group.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:refln_sys_absCategory>
 *  <PDBx:refln_sys_abs index_h="0" index_k="3" index_l="0">
 *  <PDBx:I>28.32</PDBx:I>
 *  <PDBx:sigmaI>22.95</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>1.23</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="5" index_l="0">
 *  <PDBx:I>14.11</PDBx:I>
 *  <PDBx:sigmaI>16.38</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>0.86</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="7" index_l="0">
 *  <PDBx:I>114.81</PDBx:I>
 *  <PDBx:sigmaI>20.22</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>5.67</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="9" index_l="0">
 *  <PDBx:I>32.99</PDBx:I>
 *  <PDBx:sigmaI>24.51</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>1.35</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  </PDBx:refln_sys_absCategory>
 * </pre>
 */
public class Refln_sys_abs 
{
		protected java.lang.Float I;


	/**
	 *  The measured value of the intensity in arbitrary units.
	 */
	public java.lang.Float getI() 
	{
		return I;
	}
 
	public void setI(java.lang.Float I)
	{
		this.I = I;
	}

 	protected java.lang.Float I_over_sigmaI;


	/**
	 *  The ratio of _refln_sys_abs.I to _refln_sys_abs.sigmaI.  Used
	 *  to evaluate whether a reflection that should be systematically
	 *  absent according to the designated space group is in fact
	 *  absent.
	 */
	public java.lang.Float getI_over_sigmaI() 
	{
		return I_over_sigmaI;
	}
 
	public void setI_over_sigmaI(java.lang.Float I_over_sigmaI)
	{
		this.I_over_sigmaI = I_over_sigmaI;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of the reflection. The values of the Miller
	 *  indices in the REFLN_SYS_ABS category must correspond to
	 *  the cell defined by cell lengths and cell angles in the CELL
	 *  category.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of the reflection. The values of the Miller
	 *  indices in the REFLN_SYS_ABS category must correspond to the
	 *  cell defined by cell lengths and cell angles in the CELL
	 *  category.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of the reflection. The values of the Miller
	 *  indices in the REFLN_SYS_ABS category must correspond to the
	 *  cell defined by cell lengths and cell angles in the CELL
	 *  category.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float sigmaI;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  attribute I in category refln_sys_abs in arbitrary units.
	 */
	public java.lang.Float getSigmaI() 
	{
		return sigmaI;
	}
 
	public void setSigmaI(java.lang.Float sigmaI)
	{
		this.sigmaI = sigmaI;
	}

 }
