package org.pdb.beans;

/**
 *  Data items in the REFLNS_SCALE category record details about
 *  the structure-factor scales. They are referenced from within
 *  the REFLN list through  attribute scale_group_code in category refln.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide [(POG)4 EKG (POG)5]3.
 *  <PDBx:reflns_scaleCategory>
 *  <PDBx:reflns_scale group_code="SG1">
 *  <PDBx:meas_F>4.0</PDBx:meas_F>
 *  </PDBx:reflns_scale>
 *  </PDBx:reflns_scaleCategory>
 * </pre>
 */
public class Reflns_scale 
{
		protected java.lang.String group_code;


	/**
	 *  The code identifying a scale  attribute meas_F,
	 *  in category reflns_scale _reflns_scale.meas_F_squared or _reflns_scale.meas_intensity.
	 *  These are linked to the REFLN list by the
	 *  attribute scale_group_code in category refln.  These codes
	 *  need not correspond to those in the DIFFRN_SCALE list.
	 *  1
	 *  2
	 *  c1
	 *  c2
	 */
	public java.lang.String getGroup_code() 
	{
		return group_code;
	}
 
	public void setGroup_code(java.lang.String group_code)
	{
		this.group_code = group_code;
	}

 	protected java.lang.Float meas_F;


	/**
	 *  A scale associated with  attribute group_code in category reflns_scale.
	 */
	public java.lang.Float getMeas_F() 
	{
		return meas_F;
	}
 
	public void setMeas_F(java.lang.Float meas_F)
	{
		this.meas_F = meas_F;
	}

 	protected java.lang.Float meas_F_squared;


	/**
	 *  A scale associated with  attribute group_code in category reflns_scale.
	 */
	public java.lang.Float getMeas_F_squared() 
	{
		return meas_F_squared;
	}
 
	public void setMeas_F_squared(java.lang.Float meas_F_squared)
	{
		this.meas_F_squared = meas_F_squared;
	}

 	protected java.lang.Float meas_intensity;


	/**
	 *  A scale associated with  attribute group_code in category reflns_scale.
	 */
	public java.lang.Float getMeas_intensity() 
	{
		return meas_intensity;
	}
 
	public void setMeas_intensity(java.lang.Float meas_intensity)
	{
		this.meas_intensity = meas_intensity;
	}

 }
