package org.pdb.beans;

/**
 *  Data items in the STRUCT category record details about the
 *  description of the crystallographic structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:structCategory>
 *  <PDBx:struct entry_id="5HVP">
 *  <PDBx:title> HIV-1 protease complex with acetyl-pepstatin</PDBx:title>
 *  </PDBx:struct>
 *  </PDBx:structCategory>
 * </pre>
 */
public class Struct 
{
		protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String pdbx_descriptor;


	/**
	 *  An automatically generated descriptor for an NDB structure or
	 *  the unstructured content of the PDB COMPND record.
	 *  
	 *  5'-D(*CP*GP*CP*(HYD)AP*AP*AP*TP*TP*TP*GP*CP*G)-3'
	 */
	public java.lang.String getPdbx_descriptor() 
	{
		return pdbx_descriptor;
	}
 
	public void setPdbx_descriptor(java.lang.String pdbx_descriptor)
	{
		this.pdbx_descriptor = pdbx_descriptor;
	}

 	protected java.lang.Float pdbx_formula_weight;


	/**
	 *  Estimated formula mass in daltons of the
	 *  deposited structure assembly.
	 */
	public java.lang.Float getPdbx_formula_weight() 
	{
		return pdbx_formula_weight;
	}
 
	public void setPdbx_formula_weight(java.lang.Float pdbx_formula_weight)
	{
		this.pdbx_formula_weight = pdbx_formula_weight;
	}

 	protected java.lang.String pdbx_formula_weight_method;


	/**
	 *  Method used to determine  attribute pdbx_formula_weight in category struct.
	 *  MASS SPEC
	 *  CALCULATION
	 */
	public java.lang.String getPdbx_formula_weight_method() 
	{
		return pdbx_formula_weight_method;
	}
 
	public void setPdbx_formula_weight_method(java.lang.String pdbx_formula_weight_method)
	{
		this.pdbx_formula_weight_method = pdbx_formula_weight_method;
	}

 	protected java.lang.String pdbx_model_details;


	/**
	 *  Text description of the methodology which produced this
	 *  model structure.
	 *  
	 *  This model was produced from a 10 nanosecond Amber/MD simulation
	 *  starting from PDB structure ID 1ABC.
	 */
	public java.lang.String getPdbx_model_details() 
	{
		return pdbx_model_details;
	}
 
	public void setPdbx_model_details(java.lang.String pdbx_model_details)
	{
		this.pdbx_model_details = pdbx_model_details;
	}

 	protected java.lang.String title;


	/**
	 *  A title for the data block. The author should attempt to convey
	 *  the essence of the structure archived in the CIF in the title,
	 *  and to distinguish this structural result from others.
	 *  5'-D(*(I)CP*CP*GP*G)-3
	 *  T4 lysozyme mutant - S32A
	 *  hen egg white lysozyme at -30 degrees C
	 *  quail egg white lysozyme at 2 atmospheres
	 */
	public java.lang.String getTitle() 
	{
		return title;
	}
 
	public void setTitle(java.lang.String title)
	{
		this.title = title;
	}

 }
