package org.pdb.beans;

/**
 *  Data items in the STRUCT_ASYM category record details about the
 *  structural elements in the asymmetric unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_asymCategory>
 *  <PDBx:struct_asym id="A">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="B">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="C">
 *  <PDBx:entity_id>2</PDBx:entity_id>
 *  <PDBx:details>one partially occupied position for the inhibitor</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="D">
 *  <PDBx:entity_id>2</PDBx:entity_id>
 *  <PDBx:details>one partially occupied position for the inhibitor</PDBx:details>
 *  </PDBx:struct_asym>
 *  </PDBx:struct_asymCategory>
 * </pre>
 */
public class Struct_asym 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of this portion of the contents
	 *  of the asymmetric unit.
	 *  The drug binds to this enzyme in two roughly
	 *  twofold symmetric modes. Hence this
	 *  biological unit (3) is roughly twofold
	 *  symmetric to biological unit (2). Disorder in
	 *  the protein chain indicated with alternative
	 *  ID 2 should be used with this biological unit.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_asym must uniquely identify a record in
	 *  the STRUCT_ASYM list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  1
	 *  A
	 *  2B3
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_blank_PDB_chainid_flag;


	/**
	 *  A flag indicating that this entity was originally labeled
	 *  with a blank PDB chain id.
	 */
	public java.lang.String getPdbx_blank_PDB_chainid_flag() 
	{
		return pdbx_blank_PDB_chainid_flag;
	}
 
	public void setPdbx_blank_PDB_chainid_flag(java.lang.String pdbx_blank_PDB_chainid_flag)
	{
		this.pdbx_blank_PDB_chainid_flag = pdbx_blank_PDB_chainid_flag;
	}

 	protected java.lang.String pdbx_modified;


	/**
	 *  This data item indicates whether the structural elements are modified.
	 *  y
	 */
	public java.lang.String getPdbx_modified() 
	{
		return pdbx_modified;
	}
 
	public void setPdbx_modified(java.lang.String pdbx_modified)
	{
		this.pdbx_modified = pdbx_modified;
	}

 }
