package org.pdb.beans;

/**
 *  Data items in the STRUCT_BIOL_GEN category record details about
 *  the generation of each biological unit. The STRUCT_BIOL_GEN
 *  data items provide the specifications of the components that
 *  constitute that biological unit, which may include symmetry
 *  elements.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biol_genCategory>
 *  <PDBx:struct_biol_gen biol_id="1" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="1" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="C" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="D" symmetry="1_555"></PDBx:struct_biol_gen>
 *  </PDBx:struct_biol_genCategory>
 * </pre>
 */
public class Struct_biol_gen 
{
		protected java.lang.String asym_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_asym in the STRUCT_ASYM
	 *  category.
	 */
	public java.lang.String getAsym_id() 
	{
		return asym_id;
	}
 
	public void setAsym_id(java.lang.String asym_id)
	{
		this.asym_id = asym_id;
	}

 	protected java.lang.String biol_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_biol in the STRUCT_BIOL
	 *  category.
	 */
	public java.lang.String getBiol_id() 
	{
		return biol_id;
	}
 
	public void setBiol_id(java.lang.String biol_id)
	{
		this.biol_id = biol_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the symmetry generation of
	 *  this portion of the biological structure.
	 *  The zinc atom lies on a special position;
	 *  application of symmetry elements to generate
	 *  the insulin hexamer will generate excess zinc
	 *  atoms, which must be removed by hand.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Integer pdbx_PDB_order;


	/**
	 *  An ordering index used to reproduce the presentation of
	 *  chain order in the original PDB format data files.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.Integer getPdbx_PDB_order() 
	{
		return pdbx_PDB_order;
	}
 
	public void setPdbx_PDB_order(java.lang.Integer pdbx_PDB_order)
	{
		this.pdbx_PDB_order = pdbx_PDB_order;
	}

 	protected java.lang.String pdbx_full_symmetry_operation;


	/**
	 *  This item expresses category  attribute symmetry
	 *  in category struct_biol_gen on an X, Y and Z basis.
	 *  -X, Y+1/2, -Z
	 */
	public java.lang.String getPdbx_full_symmetry_operation() 
	{
		return pdbx_full_symmetry_operation;
	}
 
	public void setPdbx_full_symmetry_operation(java.lang.String pdbx_full_symmetry_operation)
	{
		this.pdbx_full_symmetry_operation = pdbx_full_symmetry_operation;
	}

 	protected java.lang.String symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  atom set specified by  attribute asym_id in category struct_biol_gen to generate a
	 *  portion of the biological structure.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSymmetry() 
	{
		return symmetry;
	}
 
	public void setSymmetry(java.lang.String symmetry)
	{
		this.symmetry = symmetry;
	}

 }
