package org.pdb.beans;

/**
 *  Data items in the STRUCT_BIOL_KEYWORDS category record
 *  keywords that describe each biological unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biol_keywordsCategory>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartyl-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartic-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="acid-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartyl-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartic-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="acid-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="enzyme"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="dimer"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="drug-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="inhibitor-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="drug-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="inhibitor-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="drug-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="inhibitor-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="drug-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="inhibitor-protease complex"></PDBx:struct_biol_keywords>
 *  </PDBx:struct_biol_keywordsCategory>
 * </pre>
 */
public class Struct_biol_keywords 
{
		protected java.lang.String biol_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_biol in the STRUCT_BIOL
	 *  category.
	 */
	public java.lang.String getBiol_id() 
	{
		return biol_id;
	}
 
	public void setBiol_id(java.lang.String biol_id)
	{
		this.biol_id = biol_id;
	}

 	protected java.lang.String text;


	/**
	 *  Keywords describing this biological entity.
	 *  antibody
	 *  antigen
	 *  enzyme
	 *  cytokine
	 *  tRNA
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
