package org.pdb.beans;

/**
 *  Data items in the STRUCT_CONF category record details about
 *  the backbone conformation of a segment of polymer.
 *  
 *  Data items in the STRUCT_CONF_TYPE category define the
 *  criteria used to identify the backbone conformations.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_confCategory>
 *  <PDBx:struct_conf id="HELX1">
 *  <PDBx:conf_type_id>HELX_RH_AL_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ARG</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>87</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>92</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="HELX2">
 *  <PDBx:conf_type_id>HELX_RH_AL_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ARG</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>287</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>292</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN1">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>PRO</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>1</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>LEU</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>5</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN2">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>CYS</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>295</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>PHE</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>299</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN3">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>CYS</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>95</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>PHE</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>299</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN4">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>PRO</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>201</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>LEU</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>205</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN1">
 *  <PDBx:conf_type_id>TURN_TY1P_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ILE</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>15</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>18</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN2">
 *  <PDBx:conf_type_id>TURN_TY2_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>GLY</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>49</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLY</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>52</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN3">
 *  <PDBx:conf_type_id>TURN_TY1P_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ILE</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>55</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>HIS</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>69</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN4">
 *  <PDBx:conf_type_id>TURN_TY1_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>THR</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>91</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLY</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>94</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  </PDBx:struct_confCategory>
 * </pre>
 */
public class Struct_conf 
{
		protected java.lang.String beg_auth_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_asym_id() 
	{
		return beg_auth_asym_id;
	}
 
	public void setBeg_auth_asym_id(java.lang.String beg_auth_asym_id)
	{
		this.beg_auth_asym_id = beg_auth_asym_id;
	}

 	protected java.lang.String beg_auth_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_comp_id() 
	{
		return beg_auth_comp_id;
	}
 
	public void setBeg_auth_comp_id(java.lang.String beg_auth_comp_id)
	{
		this.beg_auth_comp_id = beg_auth_comp_id;
	}

 	protected java.lang.String beg_auth_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_seq_id() 
	{
		return beg_auth_seq_id;
	}
 
	public void setBeg_auth_seq_id(java.lang.String beg_auth_seq_id)
	{
		this.beg_auth_seq_id = beg_auth_seq_id;
	}

 	protected java.lang.String beg_label_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_asym_id() 
	{
		return beg_label_asym_id;
	}
 
	public void setBeg_label_asym_id(java.lang.String beg_label_asym_id)
	{
		this.beg_label_asym_id = beg_label_asym_id;
	}

 	protected java.lang.String beg_label_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_comp_id() 
	{
		return beg_label_comp_id;
	}
 
	public void setBeg_label_comp_id(java.lang.String beg_label_comp_id)
	{
		this.beg_label_comp_id = beg_label_comp_id;
	}

 	protected java.lang.Integer beg_label_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment begins.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getBeg_label_seq_id() 
	{
		return beg_label_seq_id;
	}
 
	public void setBeg_label_seq_id(java.lang.Integer beg_label_seq_id)
	{
		this.beg_label_seq_id = beg_label_seq_id;
	}

 	protected java.lang.String conf_type_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_conf_type in the
	 *  STRUCT_CONF_TYPE category.
	 */
	public java.lang.String getConf_type_id() 
	{
		return conf_type_id;
	}
 
	public void setConf_type_id(java.lang.String conf_type_id)
	{
		this.conf_type_id = conf_type_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the conformation assignment.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String end_auth_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_asym_id() 
	{
		return end_auth_asym_id;
	}
 
	public void setEnd_auth_asym_id(java.lang.String end_auth_asym_id)
	{
		this.end_auth_asym_id = end_auth_asym_id;
	}

 	protected java.lang.String end_auth_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_comp_id() 
	{
		return end_auth_comp_id;
	}
 
	public void setEnd_auth_comp_id(java.lang.String end_auth_comp_id)
	{
		this.end_auth_comp_id = end_auth_comp_id;
	}

 	protected java.lang.String end_auth_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_seq_id() 
	{
		return end_auth_seq_id;
	}
 
	public void setEnd_auth_seq_id(java.lang.String end_auth_seq_id)
	{
		this.end_auth_seq_id = end_auth_seq_id;
	}

 	protected java.lang.String end_label_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_asym_id() 
	{
		return end_label_asym_id;
	}
 
	public void setEnd_label_asym_id(java.lang.String end_label_asym_id)
	{
		this.end_label_asym_id = end_label_asym_id;
	}

 	protected java.lang.String end_label_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_comp_id() 
	{
		return end_label_comp_id;
	}
 
	public void setEnd_label_comp_id(java.lang.String end_label_comp_id)
	{
		this.end_label_comp_id = end_label_comp_id;
	}

 	protected java.lang.Integer end_label_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getEnd_label_seq_id() 
	{
		return end_label_seq_id;
	}
 
	public void setEnd_label_seq_id(java.lang.Integer end_label_seq_id)
	{
		this.end_label_seq_id = end_label_seq_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_conf must uniquely identify a record in
	 *  the STRUCT_CONF list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_PDB_helix_class;


	/**
	 *  This item is a place holder for the helix class used in the PDB
	 *  HELIX record.
	 */
	public java.lang.String getPdbx_PDB_helix_class() 
	{
		return pdbx_PDB_helix_class;
	}
 
	public void setPdbx_PDB_helix_class(java.lang.String pdbx_PDB_helix_class)
	{
		this.pdbx_PDB_helix_class = pdbx_PDB_helix_class;
	}

 	protected java.lang.String pdbx_PDB_helix_id;


	/**
	 *  A placeholder for the helix identifier of the PDB
	 *  HELIX record.
	 */
	public java.lang.String getPdbx_PDB_helix_id() 
	{
		return pdbx_PDB_helix_id;
	}
 
	public void setPdbx_PDB_helix_id(java.lang.String pdbx_PDB_helix_id)
	{
		this.pdbx_PDB_helix_id = pdbx_PDB_helix_id;
	}

 	protected java.lang.Integer pdbx_PDB_helix_length;


	/**
	 *  A placeholder for the lengths of the helix of the PDB
	 *  HELIX record.
	 */
	public java.lang.Integer getPdbx_PDB_helix_length() 
	{
		return pdbx_PDB_helix_length;
	}
 
	public void setPdbx_PDB_helix_length(java.lang.Integer pdbx_PDB_helix_length)
	{
		this.pdbx_PDB_helix_length = pdbx_PDB_helix_length;
	}

 	protected java.lang.String pdbx_beg_PDB_ins_code;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment starts.
	 */
	public java.lang.String getPdbx_beg_PDB_ins_code() 
	{
		return pdbx_beg_PDB_ins_code;
	}
 
	public void setPdbx_beg_PDB_ins_code(java.lang.String pdbx_beg_PDB_ins_code)
	{
		this.pdbx_beg_PDB_ins_code = pdbx_beg_PDB_ins_code;
	}

 	protected java.lang.String pdbx_end_PDB_ins_code;


	/**
	 *  A component of the identifier for the residue at which the
	 *  conformation segment ends.
	 */
	public java.lang.String getPdbx_end_PDB_ins_code() 
	{
		return pdbx_end_PDB_ins_code;
	}
 
	public void setPdbx_end_PDB_ins_code(java.lang.String pdbx_end_PDB_ins_code)
	{
		this.pdbx_end_PDB_ins_code = pdbx_end_PDB_ins_code;
	}

 }
