package org.pdb.beans;

/**
 *  Data items in the STRUCT_CONF_TYPE category record details
 *  about the criteria used to identify backbone conformations of a
 *  segment of polymer.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_conf_typeCategory>
 *  <PDBx:struct_conf_type id="HELX_RH_AL_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="STRN_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY1_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY1P_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY2_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY2P_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  </PDBx:struct_conf_typeCategory>
 * </pre>
 */
public class Struct_conf_type 
{
		protected java.lang.String criteria;


	/**
	 *  The criteria used to assign this conformation type.
	 *  author judgement
	 *  phi=54-74, psi=30-50
	 */
	public java.lang.String getCriteria() 
	{
		return criteria;
	}
 
	public void setCriteria(java.lang.String criteria)
	{
		this.criteria = criteria;
	}

 	protected java.lang.String id_;


	/**
	 *  The descriptor that categorizes the type of the conformation
	 *  of the backbone of the polymer (whether protein or nucleic acid).
	 *  Explicit values for the torsion angles that define each
	 *  conformation are not given here, but it is expected that the
	 *  author would provide such information in either the
	 *  _struct_conf_type.criteria or _struct_conf_type.reference data
	 *  items, or both.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String reference;


	/**
	 *  A literature reference that defines the criteria used to assign
	 *  this conformation type and subtype.
	 */
	public java.lang.String getReference() 
	{
		return reference;
	}
 
	public void setReference(java.lang.String reference)
	{
		this.reference = reference;
	}

 }
